/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.DefUseFactory;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.MethodCall;

public abstract class DefUseExecutionTraceAnalyzer {
    public static long timeGetCoveredGoals = 0L;

    public static int getPreviousDefinitionId(String targetVariable, ExecutionTrace objectTrace, Integer targetDUPos, Integer objectId) {
        int prevPos = -1;
        int prevDef = -1;
        Map defMap = objectTrace.getPassedDefinitions(targetVariable).get(objectId);
        for (Integer duPos : defMap.keySet()) {
            if (duPos >= targetDUPos || duPos <= prevPos) continue;
            prevDef = (Integer)defMap.get(duPos);
            prevPos = duPos;
        }
        return prevDef;
    }

    public static int getNextOverwritingDefinitionPosition(Definition targetDefinition, ExecutionTrace objectTrace, Integer goalDefPos, Integer objectId) {
        int lastPos = Integer.MAX_VALUE;
        Map<Integer, HashMap<Integer, Integer>> objectMap = objectTrace.getPassedDefinitions(targetDefinition.getVariableName());
        if (objectMap == null) {
            return lastPos;
        }
        Map defMap = objectMap.get(objectId);
        if (defMap == null) {
            return lastPos;
        }
        for (Integer defPos : defMap.keySet()) {
            if (defPos <= goalDefPos || defPos >= lastPos || ((Integer)defMap.get(defPos)).intValue() == targetDefinition.getDefId()) continue;
            lastPos = defPos;
        }
        return lastPos;
    }

    public static List<Integer> getUsePositions(Use targetUse, ExecutionTrace trace, int objectId) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        Map<Integer, HashMap<Integer, Integer>> objectMap = trace.getPassedUses(targetUse.getVariableName());
        if (objectMap == null) {
            return r;
        }
        Map useMap = objectMap.get(objectId);
        if (useMap == null) {
            return r;
        }
        for (Integer usePos : useMap.keySet()) {
            if (((Integer)useMap.get(usePos)).intValue() != targetUse.getUseId()) continue;
            r.add(usePos);
        }
        return r;
    }

    public static List<Integer> getDefinitionPositions(Definition targetDefinition, ExecutionTrace trace, int objectId) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        Map<Integer, HashMap<Integer, Integer>> objectMap = trace.getPassedDefinitions(targetDefinition.getVariableName());
        if (objectMap == null) {
            return r;
        }
        Map defMap = objectMap.get(objectId);
        if (defMap == null) {
            return r;
        }
        for (Integer defPos : defMap.keySet()) {
            if (((Integer)defMap.get(defPos)).intValue() != targetDefinition.getDefId()) continue;
            r.add(defPos);
        }
        return r;
    }

    public static Map<Integer, Integer> getOverwritingDefinitionsBetween(Definition targetDefinition, ExecutionTrace trace, int startingDUPos, int endDUPos, int objectId) {
        if (startingDUPos > endDUPos) {
            throw new IllegalArgumentException("start must be lower or equal end");
        }
        HashMap<Integer, Integer> r = new HashMap<Integer, Integer>();
        Map<Integer, HashMap<Integer, Integer>> objectMap = trace.getPassedDefinitions(targetDefinition.getVariableName());
        if (objectMap == null) {
            return r;
        }
        Map defMap = objectMap.get(objectId);
        if (defMap == null) {
            return r;
        }
        for (Integer defPos : defMap.keySet()) {
            if (defPos < startingDUPos || defPos > endDUPos) continue;
            int defId = (Integer)defMap.get(defPos);
            if (defId == targetDefinition.getDefId()) {
                throw new IllegalStateException("expect given trace not to have passed goalDefinition in the given duCounter-range");
            }
            if (r.get(defId) != null) continue;
            r.put(defId, defPos);
        }
        return r;
    }

    public static Set<BytecodeInstruction> getDefinitionsIn(String targetVariable, Set<BytecodeInstruction> vertices) {
        HashSet<BytecodeInstruction> r = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction vertex : vertices) {
            Definition currentDefinition;
            if (!DefUsePool.isKnownAsDefinition(vertex) || !(currentDefinition = DefUseFactory.makeDefinition(vertex)).getVariableName().equals(targetVariable)) continue;
            r.add(vertex);
        }
        return r;
    }

    public static Set<BytecodeInstruction> getOverwritingDefinitionsIn(Definition targetDefinition, Collection<BytecodeInstruction> vertices) {
        HashSet<BytecodeInstruction> r = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction vertex : vertices) {
            BytecodeInstruction vertexInOtherGraph;
            Definition currentDefinition;
            if (!vertex.isDefinition() || !DefUseExecutionTraceAnalyzer.isOverwritingDefinition(targetDefinition, currentDefinition = DefUseFactory.makeDefinition(vertexInOtherGraph = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getRawCFG(vertex.getClassName(), vertex.getMethodName()).getInstruction(vertex.getInstructionId())))) continue;
            r.add(vertex);
        }
        return r;
    }

    public static boolean isOverwritingDefinition(Definition targetDefinition, Definition definition) {
        if (definition.getDefId() == -1) {
            throw new IllegalArgumentException("expect given Definition to have it's defId set");
        }
        return targetDefinition.getVariableName().equals(definition.getVariableName()) && targetDefinition.getDefId() != definition.getDefId();
    }

    public static int getActiveDefinitionIdAt(String targetVariable, ExecutionTrace trace, int usePos, int objectId) {
        int lastDef = -1;
        int lastPos = -1;
        Map<Integer, HashMap<Integer, Integer>> objectMap = trace.getPassedDefinitions(targetVariable);
        if (objectMap == null) {
            return -1;
        }
        Map defMap = objectMap.get(objectId);
        if (defMap == null) {
            return -1;
        }
        for (Integer defPos : defMap.keySet()) {
            if (defPos > usePos || lastPos >= defPos) continue;
            lastDef = (Integer)defMap.get(defPos);
            lastPos = defPos;
        }
        return lastDef;
    }

    public static Object getActiveObjectAtDefinition(ExecutionTrace trace, String targetVariable, int objectId, int usePos) {
        Map<String, HashMap<Integer, HashMap<Integer, Object>>> defDataObjects = trace.getDefinitionDataObjects();
        defDataObjects.get(targetVariable).get(objectId);
        Object lastDef = null;
        int lastPos = -1;
        Map objectMap = defDataObjects.get(targetVariable);
        if (objectMap == null) {
            return -1;
        }
        Map defMap = (Map)objectMap.get(objectId);
        if (defMap == null) {
            return -1;
        }
        for (Integer defPos : defMap.keySet()) {
            if (defPos > usePos || lastPos >= defPos) continue;
            lastDef = defMap.get(defPos);
            lastPos = defPos;
        }
        return lastDef;
    }

    public static Object getActiveObjectAtUse(ExecutionTrace trace, String targetVariable, int objectId, int usePos) {
        Map<String, HashMap<Integer, HashMap<Integer, Object>>> defDataObjects = trace.getDefinitionDataObjects();
        defDataObjects.get(targetVariable).get(objectId);
        Object lastDef = null;
        int lastPos = -1;
        Map objectMap = defDataObjects.get(targetVariable);
        if (objectMap == null) {
            return -1;
        }
        Map defMap = (Map)objectMap.get(objectId);
        if (defMap == null) {
            return -1;
        }
        for (Integer defPos : defMap.keySet()) {
            if (defPos > usePos || lastPos >= defPos) continue;
            lastDef = defMap.get(defPos);
            lastPos = defPos;
        }
        return lastDef;
    }

    public static void printFinishCalls(ExecutionTrace trace) {
        for (MethodCall call : trace.getMethodCalls()) {
            System.out.println("Found MethodCall for: " + call.methodName + " on object " + call.callingObjectID);
            System.out.println("#passed branches: " + call.branchTrace.size());
            for (int i = 0; i < call.defuseCounterTrace.size(); ++i) {
                System.out.println(i + ". at Branch " + call.branchTrace.get(i) + " true_dist: " + call.trueDistanceTrace.get(i) + " false_dist: " + call.falseDistanceTrace.get(i) + " duCounter: " + call.defuseCounterTrace.get(i));
                System.out.println();
            }
        }
    }

    public static Set<DefUseCoverageTestFitness> getCoveredGoals(List<ExecutionResult> results) {
        long start = System.currentTimeMillis();
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        for (ExecutionResult result : results) {
            Set<DefUseCoverageTestFitness> goals = DefUseExecutionTraceAnalyzer.getCoveredGoals(result);
            r.addAll(goals);
        }
        timeGetCoveredGoals += System.currentTimeMillis() - start;
        return r;
    }

    public static Set<DefUseCoverageTestFitness> getCoveredGoals(ExecutionResult result) {
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedDefs = result.getTrace().getDefinitionData();
        Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedUses = result.getTrace().getUseData();
        for (String goalVariable : passedDefs.keySet()) {
            if (passedUses.get(goalVariable) == null) continue;
            for (Integer objectId : passedDefs.get(goalVariable).keySet()) {
                if (passedUses.get(goalVariable).get(objectId) == null) continue;
                Map currentDefMap = passedDefs.get(goalVariable).get(objectId);
                Map currentUseMap = passedUses.get(goalVariable).get(objectId);
                ArrayList duCounterTrace = new ArrayList(currentDefMap.keySet());
                duCounterTrace.addAll(currentUseMap.keySet());
                Collections.sort(duCounterTrace);
                int traceLength = duCounterTrace.size();
                Integer[] sortedDefDUTrace = duCounterTrace.toArray(new Integer[traceLength]);
                int activeDef = -1;
                for (int i = 0; i < traceLength; ++i) {
                    int currentUse;
                    DefUseCoverageTestFitness currentGoal;
                    int currentDUCounter = sortedDefDUTrace[i];
                    if (currentDefMap.containsKey(currentDUCounter)) {
                        activeDef = (Integer)currentDefMap.get(currentDUCounter);
                        continue;
                    }
                    if (activeDef == -1 || (currentGoal = DefUseCoverageFactory.retrieveGoal(activeDef, currentUse = ((Integer)currentUseMap.get(currentDUCounter)).intValue())) == null) continue;
                    r.add(currentGoal);
                }
            }
        }
        return r;
    }
}

