/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public class InputCoverageGoal
implements Serializable,
Comparable<InputCoverageGoal> {
    private static final long serialVersionUID = -2917009638438833179L;
    private final String className;
    private final String methodName;
    private final int argIndex;
    private final String type;
    private final String valueDescriptor;
    private final Number numericValue;

    public InputCoverageGoal(String className, String methodName, int argIndex, Type type, String valueDescriptor) {
        this(className, methodName, argIndex, type, valueDescriptor, null);
    }

    public InputCoverageGoal(String className, String methodName, int argIndex, Type type, String valueDescriptor, Number numericValue) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.argIndex = argIndex;
        this.type = type.toString();
        this.valueDescriptor = valueDescriptor;
        this.numericValue = numericValue;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getArgIndex() {
        return this.argIndex;
    }

    public Type getType() {
        return Type.getType((String)this.type);
    }

    public String getValueDescriptor() {
        return this.valueDescriptor;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public String toString() {
        return this.className + "." + this.methodName + "[" + this.argIndex + "]:" + this.valueDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.argIndex;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.valueDescriptor == null ? 0 : this.valueDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputCoverageGoal other = (InputCoverageGoal)obj;
        if (this.argIndex != other.argIndex) {
            return false;
        }
        if (!this.methodName.equals(other.methodName) && this.className.equals(other.className)) {
            return false;
        }
        if (this.type == null && other.type != null || this.type != null && other.type == null) {
            return false;
        }
        if (this.type != null && !this.type.equals(other.type)) {
            return false;
        }
        if (this.valueDescriptor == null && other.valueDescriptor != null || this.valueDescriptor != null && other.valueDescriptor == null) {
            return false;
        }
        return this.valueDescriptor == null || this.valueDescriptor.equals(other.valueDescriptor);
    }

    @Override
    public int compareTo(InputCoverageGoal o) {
        int diff = this.className.compareTo(o.className);
        if (diff == 0) {
            int diff2 = this.methodName.compareTo(o.methodName);
            if (diff2 == 0) {
                if (this.argIndex == o.argIndex) {
                    int diff3 = this.type.compareTo(o.type);
                    if (diff3 == 0) {
                        return this.valueDescriptor.compareTo(o.valueDescriptor);
                    }
                    return diff3;
                }
                return Integer.compare(this.argIndex, o.argIndex);
            }
            return diff2;
        }
        return diff;
    }

    public static Set<InputCoverageGoal> createCoveredGoalsFromParameters(String className, String methodName, String methodDesc, List<Object> argumentsValues) {
        LinkedHashSet<InputCoverageGoal> goals = new LinkedHashSet<InputCoverageGoal>();
        Type[] argTypes = Type.getArgumentTypes((String)methodDesc);
        for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            Object argValue = argumentsValues.get(i);
            String argValueDesc = "";
            Number numberValue = null;
            switch (argType.getSort()) {
                case 1: {
                    argValueDesc = (Boolean)argValue != false ? "True" : "False";
                    break;
                }
                case 2: {
                    char c = ((Character)argValue).charValue();
                    numberValue = c;
                    if (Character.isAlphabetic(c)) {
                        argValueDesc = "AlphabeticChar";
                        break;
                    }
                    if (Character.isDigit(c)) {
                        argValueDesc = "Digit";
                        break;
                    }
                    argValueDesc = "OtherChar";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    double value = argValue instanceof Character ? ((Number)Integer.valueOf(((Character)argValue).charValue())).doubleValue() : ((Number)argValue).doubleValue();
                    numberValue = value;
                    argValueDesc = value < 0.0 ? "Negative" : (value == 0.0 ? "Zero" : "Positive");
                    break;
                }
                case 9: {
                    if (argValue == null) {
                        argValueDesc = "Null";
                        break;
                    }
                    argValueDesc = Array.getLength(argValue) == 0 ? "EmptyArray" : "NonEmptyArray";
                    break;
                }
                case 10: {
                    if (argValue == null) {
                        argValueDesc = "Null";
                        break;
                    }
                    if (argType.getClassName().equals("java.lang.String")) {
                        argValueDesc = ((String)argValue).isEmpty() ? "EmptyString" : "NonEmptyString";
                        break;
                    }
                    if (argValue instanceof List) {
                        argValueDesc = ((List)argValue).isEmpty() ? "EmptyList" : "NonEmptyList";
                        break;
                    }
                    if (argValue instanceof Set) {
                        argValueDesc = ((Set)argValue).isEmpty() ? "EmptySet" : "NonEmptySet";
                        break;
                    }
                    if (argValue instanceof Map) {
                        argValueDesc = ((Map)argValue).isEmpty() ? "EmptyMap" : "NonEmptyMap";
                        break;
                    }
                    argValueDesc = "NonNull";
                    break;
                }
            }
            if (argValueDesc.isEmpty()) continue;
            goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
        }
        return goals;
    }
}

