/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.output;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorManager;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputCoverageGoal
implements Serializable,
Comparable<OutputCoverageGoal> {
    private static final long serialVersionUID = 3539419075883329059L;
    private static final Logger logger = LoggerFactory.getLogger(OutputCoverageGoal.class);
    private final String className;
    private final String methodName;
    private final String type;
    private final String valueDescriptor;
    private final Number numericValue;

    public OutputCoverageGoal(String className, String methodName, Type type, String valueDescriptor) {
        this(className, methodName, type, valueDescriptor, null);
    }

    public OutputCoverageGoal(String className, String methodName, Type type, String valueDescriptor, Number numericValue) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.type = type.toString();
        this.valueDescriptor = valueDescriptor;
        this.numericValue = numericValue;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Type getType() {
        return Type.getType((String)this.type);
    }

    public String getValueDescriptor() {
        return this.valueDescriptor;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public String toString() {
        return this.className + "." + this.methodName + ":" + this.valueDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.valueDescriptor == null ? 0 : this.valueDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputCoverageGoal other = (OutputCoverageGoal)obj;
        if (!this.methodName.equals(other.methodName) && this.className.equals(other.className)) {
            return false;
        }
        if (this.type == null && other.type != null || this.type != null && other.type == null) {
            return false;
        }
        if (this.type != null && !this.type.equals(other.type)) {
            return false;
        }
        if (this.valueDescriptor == null && other.valueDescriptor != null || this.valueDescriptor != null && other.valueDescriptor == null) {
            return false;
        }
        return this.valueDescriptor == null || this.valueDescriptor.equals(other.valueDescriptor);
    }

    @Override
    public int compareTo(OutputCoverageGoal o) {
        int diff = this.className.compareTo(o.className);
        if (diff == 0) {
            int diff2 = this.methodName.compareTo(o.methodName);
            if (diff2 == 0) {
                int diff3 = this.type.compareTo(o.type);
                if (diff3 == 0) {
                    return this.valueDescriptor.compareTo(o.valueDescriptor);
                }
                return diff3;
            }
            return diff2;
        }
        return diff;
    }

    public static Set<OutputCoverageGoal> createGoalsFromObject(String className, String methodName, String methodDesc, Object returnValue) {
        LinkedHashSet<OutputCoverageGoal> goals = new LinkedHashSet<OutputCoverageGoal>();
        if (!DependencyAnalysis.isTargetClassName(className)) {
            return goals;
        }
        if (methodName.equals("hashCode")) {
            return goals;
        }
        String methodNameWithDesc = methodName + methodDesc;
        Type returnType = Type.getReturnType((String)methodDesc);
        switch (returnType.getSort()) {
            case 1: {
                String desc = (Boolean)returnValue != false ? "True" : "False";
                goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, desc));
                break;
            }
            case 2: {
                char c = ((Character)returnValue).charValue();
                if (Character.isAlphabetic(c)) {
                    goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "AlphabeticChar"));
                    break;
                }
                if (Character.isDigit(c)) {
                    goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "Digit"));
                    break;
                }
                goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "OtherChar"));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                assert (returnValue instanceof Number);
                if (!OutputCoverageGoal.isJavaNumber(returnValue)) break;
                double value = ((Number)returnValue).doubleValue();
                String numDesc = value < 0.0 ? "Negative" : (value == 0.0 ? "Zero" : "Positive");
                goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, numDesc, (Number)returnValue));
                break;
            }
            case 9: {
                if (returnValue == null) {
                    goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "Null"));
                    break;
                }
                String arrDesc = Array.getLength(returnValue) == 0 ? "EmptyArray" : "NonEmptyArray";
                goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, arrDesc));
                break;
            }
            case 10: {
                if (returnValue == null) {
                    goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "Null"));
                    break;
                }
                goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "NonNull"));
                if (returnType.getClassName().equals("java.lang.String")) {
                    String valDesc = ((String)returnValue).isEmpty() ? "EmptyString" : "NonEmptyString";
                    goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, valDesc));
                    break;
                }
                for (Inspector inspector : InspectorManager.getInstance().getInspectors(returnValue.getClass())) {
                    String insp = inspector.getMethodCall() + Type.getMethodDescriptor((Method)inspector.getMethod());
                    try {
                        Object val = inspector.getValue(returnValue);
                        if (val instanceof Boolean) {
                            String valDesc = (Boolean)val != false ? "True" : "False";
                            goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + valDesc));
                            continue;
                        }
                        if (!OutputCoverageGoal.isJavaNumber(val)) continue;
                        double dv = ((Number)val).doubleValue();
                        String valDesc = dv < 0.0 ? "Negative" : (dv == 0.0 ? "Zero" : "Positive");
                        goals.add(new OutputCoverageGoal(className, methodNameWithDesc, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + valDesc));
                    }
                    catch (InvocationTargetException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                break;
            }
        }
        return goals;
    }

    private static boolean isJavaNumber(Object val) {
        return val instanceof Number && val.getClass().getName().startsWith("java.");
    }
}

