/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.output;

import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.coverage.io.output.OutputObserver;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1383064944691491355L;
    protected static final Logger logger = LoggerFactory.getLogger(OutputCoverageTestFitness.class);
    private final OutputCoverageGoal goal;

    public OutputCoverageTestFitness(OutputCoverageGoal goal) throws IllegalArgumentException {
        if (goal == null) {
            throw new IllegalArgumentException("goal cannot be null");
        }
        this.goal = goal;
        boolean hasObserver = false;
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        for (ExecutionObserver ob : executor.getExecutionObservers()) {
            if (!(ob instanceof OutputObserver)) continue;
            hasObserver = true;
            break;
        }
        if (!hasObserver) {
            OutputObserver observer = new OutputObserver();
            executor.addObserver(observer);
            logger.info("Added observer for output coverage");
        }
    }

    public String getClassName() {
        return this.goal.getClassName();
    }

    public String getMethod() {
        return this.goal.getMethodName();
    }

    public Type getType() {
        return this.goal.getType();
    }

    public String getValueDescriptor() {
        return this.goal.getValueDescriptor();
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        block0: for (Set<OutputCoverageGoal> coveredGoals : result.getOutputGoals().values()) {
            if (!coveredGoals.contains(this.goal)) continue;
            for (OutputCoverageGoal coveredGoal : coveredGoals) {
                double distance;
                if (!coveredGoal.equals(this.goal) || (distance = this.calculateDistance(coveredGoal)) < 0.0) continue;
                fitness = distance;
                continue block0;
            }
        }
        assert (fitness >= 0.0);
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    private double calculateDistance(OutputCoverageGoal coveredGoal) {
        switch (coveredGoal.getType().getSort()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Number returnValue = coveredGoal.getNumericValue();
                assert (returnValue != null);
                assert (returnValue instanceof Number);
                double value = returnValue.doubleValue();
                if (Double.isNaN(value)) {
                    return -1.0;
                }
                double distanceToNegative = 0.0;
                double distanceToZero = 0.0;
                double distanceToPositive = 0.0;
                if (value < 0.0) {
                    distanceToNegative = 0.0;
                    distanceToZero = Math.abs(value);
                    distanceToPositive = Math.abs(value) + 1.0;
                } else if (value == 0.0) {
                    distanceToNegative = 1.0;
                    distanceToZero = 0.0;
                    distanceToPositive = 1.0;
                } else {
                    distanceToNegative = value + 1.0;
                    distanceToZero = value;
                    distanceToPositive = 0.0;
                }
                if (coveredGoal.getValueDescriptor().equals("Negative")) {
                    return distanceToNegative;
                }
                if (coveredGoal.getValueDescriptor().equals("Zero")) {
                    return distanceToZero;
                }
                if (!coveredGoal.getValueDescriptor().equals("Positive")) break;
                return distanceToPositive;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }

    public String toString() {
        return "[Output]: " + this.goal.toString();
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.goal.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputCoverageTestFitness other = (OutputCoverageTestFitness)obj;
        return this.goal.equals(other.goal);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof OutputCoverageTestFitness) {
            OutputCoverageTestFitness otherOutputFitness = (OutputCoverageTestFitness)other;
            return this.goal.compareTo(otherOutputFitness.goal);
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }

    private static final Class<?> getClassForName(String type) {
        try {
            if (type.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("byte")) {
                return Byte.TYPE;
            }
            if (type.equals("char")) {
                return Character.TYPE;
            }
            if (type.equals("double")) {
                return Double.TYPE;
            }
            if (type.equals("float")) {
                return Float.TYPE;
            }
            if (type.equals("int")) {
                return Integer.TYPE;
            }
            if (type.equals("long")) {
                return Long.TYPE;
            }
            if (type.equals("short")) {
                return Short.TYPE;
            }
            if (type.equals("String") || type.equals("Boolean") || type.equals("Short") || type.equals("Long") || type.equals("Integer") || type.equals("Float") || type.equals("Double") || type.equals("Byte") || type.equals("Character")) {
                return Class.forName("java.lang." + type);
            }
            if (type.endsWith("[]")) {
                type = type.replace("[]", "");
                return Class.forName("[L" + type + ";");
            }
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

