/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageFactory;
import org.evosuite.coverage.method.MethodTraceCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodTraceCoverageSuiteFitness
extends MethodCoverageSuiteFitness {
    private static final long serialVersionUID = 4958063899628649732L;
    private static final Logger logger = LoggerFactory.getLogger(MethodTraceCoverageSuiteFitness.class);

    @Override
    protected void determineCoverageGoals() {
        List<MethodTraceCoverageTestFitness> goals = new MethodTraceCoverageFactory().getCoverageGoals();
        for (MethodTraceCoverageTestFitness goal : goals) {
            this.methodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
    }

    @Override
    protected void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredMethods, double fitness) {
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

