/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.coverage.rho.RhoAux;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhoCoverageFactory
extends AbstractFitnessFactory<LineCoverageTestFitness>
implements Serializable {
    private static final long serialVersionUID = -4124074445663735815L;
    private static final Logger logger = LoggerFactory.getLogger(RhoCoverageFactory.class);
    private static List<LineCoverageTestFitness> goals = new ArrayList<LineCoverageTestFitness>();
    private static int number_of_ones = 0;
    private static int number_of_test_cases = 0;
    private static double rho = 1.0;
    private static List<List<Integer>> matrix = new ArrayList<List<Integer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadCoverage() {
        if (!new File(Properties.COVERAGE_MATRIX_FILENAME).exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(Properties.COVERAGE_MATRIX_FILENAME));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] split = sCurrentLine.split(" ");
                ArrayList<Integer> test = new ArrayList<Integer>();
                for (int i = 0; i < split.length - 1; ++i) {
                    if (split[i].compareTo("1") != 0) continue;
                    test.add(goals.get(i).getLine());
                }
                matrix.add(test);
                number_of_ones += test.size();
                ++number_of_test_cases;
            }
            rho = (double)number_of_ones / (double)number_of_test_cases / (double)goals.size();
            logger.debug("RhoScore of an existing test suite: " + rho);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.RhoScore_T0, rho);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Size_T0, number_of_test_cases);
            rho = Math.abs(0.5 - rho);
            logger.debug("(RhoScore - 0.5) of an existing test suite: " + rho);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public List<LineCoverageTestFitness> getCoverageGoals() {
        return RhoCoverageFactory.getGoals();
    }

    public static List<LineCoverageTestFitness> getGoals() {
        if (!goals.isEmpty()) {
            return goals;
        }
        goals = RhoAux.getLineGoals();
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        if (Properties.USE_EXISTING_COVERAGE) {
            Collections.sort(goals, new Comparator<LineCoverageTestFitness>(){

                @Override
                public int compare(LineCoverageTestFitness l1, LineCoverageTestFitness l2) {
                    return Integer.compare(l1.getLine(), l2.getLine());
                }
            });
            RhoCoverageFactory.loadCoverage();
        } else {
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.RhoScore_T0, 1.0);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Size_T0, number_of_test_cases);
        }
        return goals;
    }

    public static int getNumberGoals() {
        if (goals.isEmpty()) {
            RhoCoverageFactory.getGoals();
        }
        return goals.size();
    }

    public static int getNumber_of_Ones() {
        return number_of_ones;
    }

    public static int getNumber_of_Test_Cases() {
        assert (number_of_test_cases == matrix.size());
        return number_of_test_cases;
    }

    public static double getRho() {
        return rho;
    }

    public static List<List<Integer>> getMatrix() {
        return matrix;
    }

    public static boolean exists(List<Integer> newTest) {
        return matrix.contains(newTest);
    }

    protected static void reset() {
        goals.clear();
        number_of_ones = 0;
        number_of_test_cases = 0;
        rho = 1.0;
        matrix.clear();
    }
}

