/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.util.HashSet;
import java.util.List;
import org.evosuite.coverage.statement.StatementCoverageFactory;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class StatementCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -4479582777935260157L;

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        List<ExecutionResult> results = this.runTestSuite(suite);
        double fitness = 0.0;
        List<StatementCoverageTestFitness> totalGoals = StatementCoverageFactory.retrieveCoverageGoals();
        HashSet<TestFitnessFunction> coveredGoals = new HashSet<TestFitnessFunction>();
        for (TestFitnessFunction testFitnessFunction : totalGoals) {
            double goalFitness = Double.MAX_VALUE;
            for (ExecutionResult result : results) {
                TestChromosome tc = new TestChromosome();
                tc.setTestCase(result.test);
                double resultFitness = testFitnessFunction.getFitness(tc, result);
                if (resultFitness < goalFitness) {
                    goalFitness = resultFitness;
                }
                if (goalFitness != 0.0) continue;
                coveredGoals.add(testFitnessFunction);
                break;
            }
            fitness += goalFitness;
        }
        if (totalGoals.size() > 0) {
            suite.setCoverage(this, (double)coveredGoals.size() / (double)totalGoals.size());
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredGoals.size());
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }
}

