/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.utils.PublicCloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Chromosome
implements Comparable<Chromosome>,
Serializable,
PublicCloneable<Chromosome> {
    private static final long serialVersionUID = -6921897301005213358L;
    private static final Logger logger = LoggerFactory.getLogger(Chromosome.class);
    private LinkedHashMap<FitnessFunction<?>, Double> fitnessValues = new LinkedHashMap();
    private LinkedHashMap<FitnessFunction<?>, Double> previousFitnessValues = new LinkedHashMap();
    private boolean changed = true;
    private boolean localSearchApplied = false;
    private LinkedHashMap<FitnessFunction<?>, Double> coverageValues = new LinkedHashMap();
    private LinkedHashMap<FitnessFunction<?>, Integer> numsNotCoveredGoals = new LinkedHashMap();
    private LinkedHashMap<FitnessFunction<?>, Integer> numsCoveredGoals = new LinkedHashMap();
    protected int age = 0;
    protected int rank = -1;
    protected double distance = 0.0;
    private int numberOfMutations = 0;
    private int numberOfEvaluations = 0;
    protected double kineticEnergy = Properties.INITIAL_KINETIC_ENERGY;
    protected int numCollisions = 0;

    protected Chromosome() {
    }

    public double getFitness() {
        if (this.fitnessValues.size() > 1) {
            double sumFitnesses = 0.0;
            for (FitnessFunction<?> fitnessFunction : this.fitnessValues.keySet()) {
                sumFitnesses += this.fitnessValues.get(fitnessFunction).doubleValue();
            }
            return sumFitnesses;
        }
        return this.fitnessValues.isEmpty() ? 0.0 : this.fitnessValues.get(this.fitnessValues.keySet().iterator().next());
    }

    public <T extends Chromosome> double getFitness(FitnessFunction<T> ff) {
        return this.fitnessValues.containsKey(ff) ? this.fitnessValues.get(ff).doubleValue() : ff.getFitness(this);
    }

    public Map<FitnessFunction<?>, Double> getFitnessValues() {
        return this.fitnessValues;
    }

    public Map<FitnessFunction<?>, Double> getPreviousFitnessValues() {
        return this.previousFitnessValues;
    }

    public boolean hasExecutedFitness(FitnessFunction<?> ff) {
        return this.previousFitnessValues.containsKey(ff);
    }

    public void setFitnessValues(Map<FitnessFunction<?>, Double> fits) {
        this.fitnessValues.clear();
        this.fitnessValues.putAll(fits);
    }

    public void setPreviousFitnessValues(Map<FitnessFunction<?>, Double> lastFits) {
        this.previousFitnessValues.clear();
        this.previousFitnessValues.putAll(lastFits);
    }

    public void addFitness(FitnessFunction<?> ff) {
        if (ff.isMaximizationFunction()) {
            this.addFitness(ff, 0.0, 0.0, 0);
        } else {
            this.addFitness(ff, Double.MAX_VALUE, 0.0, 0);
        }
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue) {
        this.addFitness(ff, fitnessValue, 0.0, 0);
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue, double coverage) {
        this.fitnessValues.put(ff, fitnessValue);
        this.previousFitnessValues.put(ff, fitnessValue);
        this.coverageValues.put(ff, coverage);
        this.numsCoveredGoals.put(ff, 0);
        this.numsNotCoveredGoals.put(ff, -1);
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue, double coverage, int numCoveredGoals) {
        this.fitnessValues.put(ff, fitnessValue);
        this.previousFitnessValues.put(ff, fitnessValue);
        this.coverageValues.put(ff, coverage);
        this.numsCoveredGoals.put(ff, numCoveredGoals);
        this.numsNotCoveredGoals.put(ff, -1);
    }

    public void setFitness(FitnessFunction<?> ff, double value) throws IllegalArgumentException {
        if (Double.compare(value, Double.NaN) == 0 || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Invalid value of Fitness: " + value + ", Fitness: " + ff.getClass().getName());
        }
        if (!this.fitnessValues.containsKey(ff)) {
            this.previousFitnessValues.put(ff, value);
            this.fitnessValues.put(ff, value);
        } else {
            this.previousFitnessValues.put(ff, this.fitnessValues.get(ff));
            this.fitnessValues.put(ff, value);
        }
    }

    public boolean hasFitnessChanged() {
        for (FitnessFunction<?> ff : this.fitnessValues.keySet()) {
            if (this.fitnessValues.get(ff).equals(this.previousFitnessValues.get(ff))) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract Chromosome clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public int compareTo(Chromosome c) {
        int i = (int)Math.signum(this.getFitness() - c.getFitness());
        if (i == 0) {
            return this.compareSecondaryObjective(c);
        }
        return i;
    }

    public abstract <T extends Chromosome> int compareSecondaryObjective(T var1);

    public abstract void mutate();

    public void crossOver(Chromosome other, int position) throws ConstructionFailedException {
        this.crossOver(other, position, position);
    }

    public abstract void crossOver(Chromosome var1, int var2, int var3) throws ConstructionFailedException;

    public abstract boolean localSearch(LocalSearchObjective<? extends Chromosome> var1);

    public abstract int size();

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.localSearchApplied = false;
    }

    public boolean hasLocalSearchBeenApplied() {
        return this.localSearchApplied;
    }

    public void setLocalSearchApplied(boolean localSearchApplied) {
        this.localSearchApplied = localSearchApplied;
    }

    public double getCoverage() {
        double cov;
        double sum = 0.0;
        for (FitnessFunction<?> fitnessFunction : this.coverageValues.keySet()) {
            sum += this.coverageValues.get(fitnessFunction).doubleValue();
        }
        double d = cov = this.coverageValues.isEmpty() ? 0.0 : sum / (double)this.coverageValues.size();
        assert (cov >= 0.0 && cov <= 1.0) : "Incorrect coverage value " + cov + ". Expected value between 0 and 1";
        return cov;
    }

    public int getNumOfCoveredGoals() {
        int sum = 0;
        for (FitnessFunction<?> fitnessFunction : this.numsCoveredGoals.keySet()) {
            sum += this.numsCoveredGoals.get(fitnessFunction).intValue();
        }
        return sum;
    }

    public int getNumOfNotCoveredGoals() {
        int sum = 0;
        for (FitnessFunction<?> fitnessFunction : this.numsNotCoveredGoals.keySet()) {
            sum += this.numsNotCoveredGoals.get(fitnessFunction).intValue();
        }
        return sum;
    }

    public void setNumsOfCoveredGoals(Map<FitnessFunction<?>, Integer> fits) {
        this.numsCoveredGoals.clear();
        this.numsCoveredGoals.putAll(fits);
    }

    public void setNumsOfNotCoveredGoals(Map<FitnessFunction<?>, Integer> fits) {
        this.numsNotCoveredGoals.clear();
        this.numsNotCoveredGoals.putAll(fits);
    }

    public void setNumOfNotCoveredGoals(FitnessFunction<?> ff, int numCoveredGoals) {
        this.numsNotCoveredGoals.put(ff, numCoveredGoals);
    }

    public Map<FitnessFunction<?>, Integer> getNumsOfCoveredGoals() {
        return this.numsCoveredGoals;
    }

    public LinkedHashMap<FitnessFunction<?>, Integer> getNumsNotCoveredGoals() {
        return this.numsNotCoveredGoals;
    }

    public Map<FitnessFunction<?>, Double> getCoverageValues() {
        return this.coverageValues;
    }

    public void setCoverageValues(Map<FitnessFunction<?>, Double> coverages) {
        this.coverageValues.clear();
        this.coverageValues.putAll(coverages);
    }

    public double getCoverage(FitnessFunction<?> ff) {
        return this.coverageValues.containsKey(ff) ? this.coverageValues.get(ff) : 0.0;
    }

    public void setCoverage(FitnessFunction<?> ff, double coverage) {
        this.coverageValues.put(ff, coverage);
    }

    public int getNumOfCoveredGoals(FitnessFunction<?> ff) {
        return this.numsCoveredGoals.containsKey(ff) ? this.numsCoveredGoals.get(ff) : 0;
    }

    public int getNumOfNotCoveredGoals(FitnessFunction<?> ff) {
        return this.numsNotCoveredGoals.containsKey(ff) ? this.numsNotCoveredGoals.get(ff) : 0;
    }

    public void setNumOfCoveredGoals(FitnessFunction<?> ff, int numCoveredGoals) {
        this.numsCoveredGoals.put(ff, numCoveredGoals);
    }

    public void updateAge(int generation) {
        this.age = generation;
    }

    public int getAge() {
        return this.age;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int r) {
        this.rank = r;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getFitnessInstanceOf(Class<?> clazz) {
        for (FitnessFunction<?> fitnessFunction : this.fitnessValues.keySet()) {
            if (!clazz.isInstance(fitnessFunction)) continue;
            return this.fitnessValues.get(fitnessFunction);
        }
        return 0.0;
    }

    public double getCoverageInstanceOf(Class<?> clazz) {
        for (FitnessFunction<?> fitnessFunction : this.coverageValues.keySet()) {
            if (!clazz.isInstance(fitnessFunction)) continue;
            return this.coverageValues.get(fitnessFunction);
        }
        return 0.0;
    }

    public void increaseNumberOfMutations() {
        ++this.numberOfMutations;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public void setNumberOfMutations(int numberOfMutations) {
        this.numberOfMutations = numberOfMutations;
    }

    public void increaseNumberOfEvaluations() {
        ++this.numberOfEvaluations;
    }

    public int getNumberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    public void setNumberOfEvaluations(int numberOfEvaluations) {
        this.numberOfEvaluations = numberOfEvaluations;
    }

    public double getKineticEnergy() {
        return this.kineticEnergy;
    }

    public void setKineticEnergy(double kineticEnergy) {
        this.kineticEnergy = kineticEnergy;
    }

    public int getNumCollisions() {
        return this.numCollisions;
    }

    public void setNumCollisions(int numCollisions) {
        this.numCollisions = numCollisions;
    }

    public void resetNumCollisions() {
        this.numCollisions = 0;
    }

    public void increaseNumCollisionsByOne() {
        ++this.numCollisions;
    }
}

