/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.archive.CoverageArchive;
import org.evosuite.ga.archive.MIOArchive;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.reflection.PrivateFieldStatement;
import org.evosuite.testcase.statements.reflection.PrivateMethodStatement;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Archive<F extends TestFitnessFunction, T extends TestChromosome>
implements Serializable {
    private static final long serialVersionUID = 2604119519478973245L;
    private static final Logger logger = LoggerFactory.getLogger(Archive.class);
    protected final Map<String, Set<F>> nonCoveredTargetsOfEachMethod = new LinkedHashMap<String, Set<F>>();
    protected boolean hasBeenUpdated = false;

    public abstract void addTarget(F var1);

    public void addTargets(Collection<F> targets) {
        for (TestFitnessFunction target : targets) {
            this.addTarget(target);
        }
    }

    protected void registerNonCoveredTargetOfAMethod(F target) {
        String targetMethod = this.getMethodFullName(target);
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(targetMethod)) {
            this.nonCoveredTargetsOfEachMethod.put(targetMethod, new LinkedHashSet());
        }
        this.nonCoveredTargetsOfEachMethod.get(targetMethod).add(target);
    }

    protected void removeNonCoveredTargetOfAMethod(F target) {
        String targetMethod = this.getMethodFullName(target);
        if (this.nonCoveredTargetsOfEachMethod.containsKey(targetMethod)) {
            if (this.nonCoveredTargetsOfEachMethod.get(targetMethod).contains(target)) {
                this.nonCoveredTargetsOfEachMethod.get(targetMethod).remove(target);
            }
            if (this.nonCoveredTargetsOfEachMethod.get(targetMethod).isEmpty()) {
                this.nonCoveredTargetsOfEachMethod.remove(targetMethod);
                this.ignoreMethodCall(this.getClassName(target), this.getMethodName(target));
            }
        }
    }

    public abstract void updateArchive(F var1, T var2, double var3);

    public boolean isBetterThanCurrent(T currentSolution, T candidateSolution) {
        int penaltyCurrentSolution = this.calculatePenalty(((TestChromosome)currentSolution).getTestCase());
        int penaltyCandidateSolution = this.calculatePenalty(((TestChromosome)candidateSolution).getTestCase());
        if (penaltyCandidateSolution < penaltyCurrentSolution) {
            return true;
        }
        if (penaltyCandidateSolution > penaltyCurrentSolution) {
            return false;
        }
        assert (penaltyCandidateSolution == penaltyCurrentSolution);
        return ((TestChromosome)candidateSolution).size() < ((TestChromosome)currentSolution).size();
    }

    public abstract boolean isArchiveEmpty();

    public abstract int getNumberOfTargets();

    public abstract int getNumberOfCoveredTargets();

    public abstract Set<F> getCoveredTargets();

    public abstract int getNumberOfUncoveredTargets();

    public abstract Set<F> getUncoveredTargets();

    public abstract boolean hasTarget(F var1);

    public abstract int getNumberOfSolutions();

    public abstract Set<T> getSolutions();

    public abstract T getSolution();

    public abstract T getSolution(F var1);

    public abstract boolean hasSolution(F var1);

    public abstract T getRandomSolution();

    public abstract <C extends Chromosome> C mergeArchiveAndSolution(C var1);

    public abstract void shrinkSolutions(int var1);

    protected void ignoreMethodCall(String className, String methodName) {
        TestCluster cluster = TestCluster.getInstance();
        List<GenericAccessibleObject<?>> calls = cluster.getTestCalls();
        for (GenericAccessibleObject<?> call : calls) {
            String desc;
            if (!call.getDeclaringClass().getName().equals(className)) continue;
            if (call instanceof GenericMethod) {
                GenericMethod genericMethod = (GenericMethod)call;
                if (!methodName.startsWith(genericMethod.getName())) continue;
                desc = Type.getMethodDescriptor((Method)genericMethod.getMethod());
                if (!(genericMethod.getName() + desc).equals(methodName)) continue;
                logger.info("Removing method " + methodName + " from cluster");
                cluster.removeTestCall(call);
                logger.info("Testcalls left: " + cluster.getNumTestCalls());
                continue;
            }
            if (!(call instanceof GenericConstructor)) continue;
            GenericConstructor genericConstructor = (GenericConstructor)call;
            if (!methodName.startsWith("<init>")) continue;
            desc = Type.getConstructorDescriptor(genericConstructor.getConstructor());
            if (!("<init>" + desc).equals(methodName)) continue;
            logger.info("Removing constructor " + methodName + " from cluster");
            cluster.removeTestCall(call);
            logger.info("Testcalls left: " + cluster.getNumTestCalls());
        }
    }

    protected int calculatePenalty(TestCase testCase) {
        int penalty = 0;
        if (this.hasFunctionalMocks(testCase)) {
            ++penalty;
        }
        if (this.hasFunctionalMocksForGenerableTypes(testCase)) {
            ++penalty;
        }
        if (this.hasPrivateAccess(testCase)) {
            ++penalty;
        }
        return penalty;
    }

    private boolean hasFunctionalMocks(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof FunctionalMockStatement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFunctionalMocksForGenerableTypes(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof FunctionalMockStatement)) continue;
            FunctionalMockStatement fm = (FunctionalMockStatement)statement;
            Class<?> target = fm.getTargetClass();
            GenericClass gc = new GenericClass(target);
            if (!TestCluster.getInstance().hasGenerator(gc)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPrivateAccess(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof PrivateFieldStatement) && !(statement instanceof PrivateMethodStatement)) continue;
            return true;
        }
        return false;
    }

    protected String getMethodFullName(F target) {
        return this.getClassName(target) + this.getMethodName(target);
    }

    private String getClassName(F target) {
        return ((TestFitnessFunction)target).getTargetClass();
    }

    private String getMethodName(F target) {
        return ((TestFitnessFunction)target).getTargetMethod();
    }

    protected boolean isMethodFullyCovered(String methodFullName) {
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(methodFullName)) {
            return true;
        }
        return this.nonCoveredTargetsOfEachMethod.get(methodFullName).isEmpty();
    }

    public int getNumOfRemainingTargets(String methodFullName) {
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(methodFullName)) {
            return 0;
        }
        return this.nonCoveredTargetsOfEachMethod.get(methodFullName).size();
    }

    public abstract String toString();

    public void reset() {
        this.nonCoveredTargetsOfEachMethod.clear();
    }

    public boolean hasBeenUpdated() {
        return this.hasBeenUpdated;
    }

    public void setHasBeenUpdated(boolean b) {
        this.hasBeenUpdated = b;
    }

    public static final Archive<TestFitnessFunction, TestChromosome> getArchiveInstance() {
        switch (Properties.ARCHIVE_TYPE) {
            default: {
                return CoverageArchive.instance;
            }
            case MIO: 
        }
        return MIOArchive.instance;
    }
}

