/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.ConstraintVerifier;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testsuite.TestSuiteSerialization;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTestChromosomeFactory
implements ChromosomeFactory<TestChromosome> {
    private static final long serialVersionUID = -8499807341782893732L;
    private static final Logger logger = LoggerFactory.getLogger(ArchiveTestChromosomeFactory.class);
    private ChromosomeFactory<TestChromosome> defaultFactory = new RandomLengthTestFactory();
    private List<TestChromosome> seededTests;

    public ArchiveTestChromosomeFactory() {
        if (Properties.CTG_SEEDS_FILE_IN != null) {
            this.seededTests = TestSuiteSerialization.loadTests(Properties.CTG_SEEDS_FILE_IN);
            LoggingUtils.getEvoLogger().info("* Loaded {} tests from {}", (Object)this.seededTests.size(), (Object)Properties.CTG_SEEDS_FILE_IN);
        }
    }

    @Override
    public TestChromosome getChromosome() {
        if (this.seededTests != null && !this.seededTests.isEmpty()) {
            TestChromosome test = this.seededTests.remove(this.seededTests.size() - 1);
            test.getTestCase().removeAssertions();
            return test;
        }
        TestChromosome test = null;
        if (!Archive.getArchiveInstance().isArchiveEmpty() && Randomness.nextDouble() < Properties.SEED_CLONE) {
            logger.info("Creating test based on archive");
            test = new TestChromosome();
            test.setTestCase(Archive.getArchiveInstance().getRandomSolution().getTestCase());
            int mutations = Randomness.nextInt(Properties.SEED_MUTATIONS);
            for (int i = 0; i < mutations; ++i) {
                test.mutate();
            }
        } else {
            logger.info("Creating random test");
            test = this.defaultFactory.getChromosome();
        }
        assert (ConstraintVerifier.verifyTest(test));
        assert (!ConstraintVerifier.hasAnyOnlyForAssertionMethod(test.getTestCase()));
        return test;
    }
}

