/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageArchive<F extends TestFitnessFunction, T extends TestChromosome>
extends Archive<F, T> {
    private static final long serialVersionUID = -4046845573050661961L;
    private static final Logger logger = LoggerFactory.getLogger(CoverageArchive.class);
    private final Map<F, T> covered = new LinkedHashMap<F, T>();
    private final Set<F> uncovered = new LinkedHashSet<F>();
    public static final CoverageArchive<TestFitnessFunction, TestChromosome> instance = new CoverageArchive();

    @Override
    public void addTarget(F target) {
        assert (target != null);
        if (!this.uncovered.contains(target)) {
            logger.debug("Registering new target '" + target + "'");
            this.uncovered.add(target);
        }
        this.registerNonCoveredTargetOfAMethod(target);
    }

    @Override
    public void updateArchive(F target, T solution, double fitnessValue) {
        assert (target != null);
        assert (this.covered.containsKey(target) || this.uncovered.contains(target)) : "Unknown goal: " + target;
        if (fitnessValue > 0.0) {
            return;
        }
        boolean isNewCoveredTarget = false;
        boolean isNewSolutionBetterThanCurrent = false;
        TestChromosome currentSolution = (TestChromosome)this.covered.get(target);
        if (currentSolution == null) {
            logger.debug("Solution for non-covered target '" + target + "'");
            isNewCoveredTarget = true;
        } else {
            isNewSolutionBetterThanCurrent = this.isBetterThanCurrent(currentSolution, solution);
        }
        if (isNewCoveredTarget || isNewSolutionBetterThanCurrent) {
            this.addToArchive(target, solution);
        }
    }

    private void addToArchive(F target, T solution) {
        this.uncovered.remove(target);
        this.covered.put(target, solution);
        this.removeNonCoveredTargetOfAMethod(target);
        this.hasBeenUpdated = true;
        ExecutionResult result = ((ExecutableChromosome)solution).getLastExecutionResult();
        if (result != null && (result.hasTimeout() || result.hasTestException())) {
            AtMostOnceLogger.warn((Logger)logger, (String)("A solution with a timeout/exception result has been added to the archive. The covered goal was " + target.toString()));
        }
    }

    @Override
    public boolean isArchiveEmpty() {
        return this.covered.isEmpty();
    }

    @Override
    public int getNumberOfTargets() {
        return this.covered.keySet().size() + this.uncovered.size();
    }

    @Override
    public int getNumberOfCoveredTargets() {
        return this.covered.size();
    }

    @Override
    public Set<F> getCoveredTargets() {
        return this.covered.keySet();
    }

    @Override
    public int getNumberOfUncoveredTargets() {
        return this.uncovered.size();
    }

    @Override
    public Set<F> getUncoveredTargets() {
        return this.uncovered;
    }

    private Set<F> getTargets() {
        LinkedHashSet<F> targets = new LinkedHashSet<F>();
        targets.addAll(this.getCoveredTargets());
        targets.addAll(this.getUncoveredTargets());
        return targets;
    }

    @Override
    public boolean hasTarget(F target) {
        assert (target != null);
        return this.covered.containsKey(target) || this.uncovered.contains(target);
    }

    @Override
    public int getNumberOfSolutions() {
        return this.covered.size();
    }

    @Override
    public Set<T> getSolutions() {
        return new LinkedHashSet<T>(this.covered.values());
    }

    @Override
    public T getSolution() {
        return this.getRandomSolution();
    }

    @Override
    public T getSolution(F target) {
        assert (target != null);
        assert (this.covered.containsKey(target));
        return (T)((TestChromosome)this.covered.get(target));
    }

    @Override
    public boolean hasSolution(F target) {
        assert (target != null);
        return this.covered.containsKey(target);
    }

    @Override
    public T getRandomSolution() {
        TestChromosome randomChoice = (TestChromosome)Randomness.choice(this.getSolutions());
        if (randomChoice == null) {
            return null;
        }
        return (T)((TestChromosome)randomChoice.clone());
    }

    @Override
    public TestSuiteChromosome mergeArchiveAndSolution(Chromosome solution) {
        Properties.TEST_ARCHIVE = false;
        TestSuiteChromosome mergedSolution = (TestSuiteChromosome)solution.clone();
        mergedSolution.getTestChromosomes().removeIf(t -> t.isChanged() || t.getLastExecutionResult() != null && (t.getLastExecutionResult().hasTimeout() || t.getLastExecutionResult().hasTestException()));
        LinkedHashSet<TestChromosome> solutionsSampledFromArchive = new LinkedHashSet<TestChromosome>();
        for (TestFitnessFunction testFitnessFunction : this.getTargets()) {
            TestChromosome chromosome;
            boolean isGoalCovered = false;
            for (TestChromosome test : mergedSolution.getTestChromosomes()) {
                if (!test.getTestCase().isGoalCovered(testFitnessFunction)) continue;
                isGoalCovered = true;
                break;
            }
            if (isGoalCovered || (chromosome = (TestChromosome)this.covered.get(testFitnessFunction)) == null || solutionsSampledFromArchive.contains(chromosome)) continue;
            solutionsSampledFromArchive.add(chromosome);
            mergedSolution.addTest(chromosome);
        }
        for (FitnessFunction fitnessFunction : solution.getFitnessValues().keySet()) {
            fitnessFunction.getFitness(mergedSolution);
        }
        Properties.TEST_ARCHIVE = true;
        return mergedSolution;
    }

    @Override
    public void shrinkSolutions(int size) {
    }

    @Override
    public String toString() {
        return "NumTargets: " + this.getNumberOfTargets() + ", NumCoveredTargets: " + this.getNumberOfCoveredTargets() + ", NumSolutions: " + this.getNumberOfSolutions();
    }

    @Override
    public void reset() {
        super.reset();
        this.covered.clear();
        this.uncovered.clear();
    }
}

