/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIOArchive<F extends TestFitnessFunction, T extends TestChromosome>
extends Archive<F, T> {
    private static final long serialVersionUID = -6100903230303784634L;
    private static final Logger logger = LoggerFactory.getLogger(MIOArchive.class);
    protected final Map<F, Population> archive = new LinkedHashMap<F, Population>();
    public static final MIOArchive<TestFitnessFunction, TestChromosome> instance = new MIOArchive();

    @Override
    public void addTarget(F target) {
        assert (target != null);
        if (!this.archive.containsKey(target)) {
            logger.debug("Registering new target '" + target + "'");
            this.archive.put(target, new Population(Properties.NUMBER_OF_TESTS_PER_TARGET));
        }
        this.registerNonCoveredTargetOfAMethod(target);
    }

    @Override
    public void updateArchive(F target, T solution, double fitnessValue) {
        boolean isNewCoveredTarget;
        assert (target != null);
        assert (this.archive.containsKey(target));
        assert (fitnessValue >= 0.0);
        TestChromosome solutionClone = (TestChromosome)((TestChromosome)solution).clone();
        ExecutionResult executionResult = solutionClone.getLastExecutionResult();
        if (!executionResult.noThrownExceptions()) {
            solutionClone.getTestCase().chop(executionResult.getFirstPositionOfThrownException() + 1);
        }
        if (isNewCoveredTarget = this.archive.get(target).addSolution(1.0 - FitnessFunction.normalize(fitnessValue), solutionClone)) {
            this.removeNonCoveredTargetOfAMethod(target);
            this.hasBeenUpdated = true;
        }
    }

    @Override
    public boolean isArchiveEmpty() {
        return this.getNumberOfSolutions() == 0;
    }

    @Override
    public int getNumberOfTargets() {
        return this.archive.keySet().size();
    }

    @Override
    public int getNumberOfCoveredTargets() {
        return this.getCoveredTargets().size();
    }

    @Override
    public Set<F> getCoveredTargets() {
        return this.archive.keySet().stream().filter(target -> this.archive.get(target).isCovered()).collect(Collectors.toSet());
    }

    @Override
    public int getNumberOfUncoveredTargets() {
        return this.getUncoveredTargets().size();
    }

    @Override
    public Set<F> getUncoveredTargets() {
        return this.archive.keySet().stream().filter(target -> !this.archive.get(target).isCovered()).collect(Collectors.toSet());
    }

    @Override
    public boolean hasTarget(F target) {
        assert (target != null);
        return this.archive.containsKey(target);
    }

    @Override
    public int getNumberOfSolutions() {
        return this.getSolutions().size();
    }

    @Override
    public Set<T> getSolutions() {
        LinkedHashSet<TestChromosome> solutions = new LinkedHashSet<TestChromosome>();
        for (Population population : this.archive.values()) {
            TestChromosome solution = population.getBestSolutionIfAny();
            if (solution == null) continue;
            solutions.add(solution);
        }
        return solutions;
    }

    @Override
    public T getSolution() {
        List targetsWithSolutions = this.archive.keySet().stream().filter(target -> this.archive.get(target).numSolutions() > 0).collect(Collectors.toList());
        if (targetsWithSolutions.isEmpty()) {
            return null;
        }
        List potentialTargets = targetsWithSolutions.stream().filter(target -> !this.archive.get(target).isCovered()).collect(Collectors.toList());
        if (potentialTargets.isEmpty()) {
            potentialTargets = targetsWithSolutions.stream().filter(target -> this.archive.get(target).isCovered()).collect(Collectors.toList());
        }
        assert (!potentialTargets.isEmpty());
        potentialTargets.sort(new Comparator<F>(){

            @Override
            public int compare(F f0, F f1) {
                if (MIOArchive.this.archive.get(f0).counter() < MIOArchive.this.archive.get(f1).counter()) {
                    return -1;
                }
                if (MIOArchive.this.archive.get(f0).counter() > MIOArchive.this.archive.get(f1).counter()) {
                    return 1;
                }
                return 0;
            }
        });
        TestChromosome randomSolution = this.archive.get(potentialTargets.get(0)).sampleSolution();
        return (T)(randomSolution == null ? null : (TestChromosome)randomSolution.clone());
    }

    @Override
    public T getSolution(F target) {
        assert (target != null);
        assert (this.archive.containsKey(target));
        return (T)this.archive.get(target).getBestSolutionIfAny();
    }

    @Override
    public boolean hasSolution(F target) {
        assert (target != null);
        assert (this.archive.containsKey(target));
        return this.archive.get(target).isCovered();
    }

    @Override
    public T getRandomSolution() {
        return (T)((TestChromosome)Randomness.choice(this.getSolutions()));
    }

    @Override
    public TestSuiteChromosome mergeArchiveAndSolution(Chromosome solution) {
        Properties.TEST_ARCHIVE = false;
        TestSuiteChromosome mergedSolution = (TestSuiteChromosome)solution.clone();
        LinkedHashSet<TestChromosome> solutionsSampledFromArchive = new LinkedHashSet<TestChromosome>();
        for (TestFitnessFunction testFitnessFunction : this.archive.keySet()) {
            Population population;
            TestChromosome t;
            if (testFitnessFunction.isCoveredBy(mergedSolution) || (t = (population = this.archive.get(testFitnessFunction)).getBestSolutionIfAny()) == null || solutionsSampledFromArchive.contains(t)) continue;
            solutionsSampledFromArchive.add(t);
            TestChromosome tClone = (TestChromosome)t.clone();
            mergedSolution.addTest(tClone);
        }
        for (FitnessFunction fitnessFunction : solution.getFitnessValues().keySet()) {
            fitnessFunction.getFitness(mergedSolution);
        }
        Properties.TEST_ARCHIVE = true;
        logger.info("Final test suite size from archive: " + mergedSolution);
        return mergedSolution;
    }

    @Override
    public void shrinkSolutions(int newPopulationSize) {
        assert (newPopulationSize > 0);
        for (TestFitnessFunction target : this.archive.keySet()) {
            this.archive.get(target).shrinkPopulation(newPopulationSize);
        }
    }

    @Override
    public String toString() {
        return "NumTargets: " + this.getNumberOfTargets() + ", NumCoveredTargets: " + this.getNumberOfCoveredTargets() + ", NumSolutions: " + this.getNumberOfSolutions();
    }

    @Override
    public void reset() {
        super.reset();
        this.archive.clear();
    }

    private class Population
    implements Serializable {
        private static final long serialVersionUID = 1671692598239736237L;
        private int counter = 0;
        private int capacity;
        private List<Pair<Double, T>> solutions = null;

        private Population(int populationSize) {
            this.capacity = populationSize;
            this.solutions = new ArrayList(populationSize);
        }

        private int counter() {
            return this.counter;
        }

        private boolean isCovered() {
            return this.solutions.size() == 1 && this.capacity == 1 && (Double)this.solutions.get(0).getLeft() == 1.0;
        }

        private boolean addSolution(Double h, T t) {
            assert (h >= 0.0 && h <= 1.0);
            if (h == 0.0) {
                return false;
            }
            if (h < 1.0 && this.isCovered()) {
                return false;
            }
            ImmutablePair candidateSolution = new ImmutablePair((Object)h, t);
            boolean added = false;
            if (h == 1.0) {
                if (this.isCovered()) {
                    Pair currentSolution = this.solutions.get(0);
                    if (this.isPairBetterThanCurrent(currentSolution, (Pair)candidateSolution)) {
                        added = true;
                        this.solutions.set(0, (Pair)candidateSolution);
                    }
                } else {
                    added = true;
                    this.capacity = 1;
                    this.solutions.clear();
                    this.solutions.add((Pair)candidateSolution);
                }
            } else if (this.solutions.size() < this.capacity) {
                this.solutions.add((Pair)candidateSolution);
                this.sortPairSolutions();
            } else {
                this.sortPairSolutions();
                Pair worstSolution = this.solutions.get(this.capacity - 1);
                if (this.isPairBetterThanCurrent(worstSolution, (Pair)candidateSolution)) {
                    this.solutions.set(this.capacity - 1, (Pair)candidateSolution);
                }
            }
            assert (this.solutions.size() <= this.capacity);
            if (added) {
                this.counter = 0;
            }
            return added;
        }

        private boolean isPairBetterThanCurrent(Pair<Double, T> currentSolution, Pair<Double, T> candidateSolution) {
            int cmp = Double.compare((Double)currentSolution.getLeft(), (Double)candidateSolution.getLeft());
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            assert (cmp == 0);
            return MIOArchive.this.isBetterThanCurrent((TestChromosome)currentSolution.getRight(), (TestChromosome)candidateSolution.getRight());
        }

        private T sampleSolution() {
            if (this.numSolutions() == 0) {
                return null;
            }
            ++this.counter;
            return (TestChromosome)Randomness.choice(this.solutions).getRight();
        }

        private void sortPairSolutions() {
            this.solutions.sort(new Comparator<Pair<Double, T>>(){

                @Override
                public int compare(Pair<Double, T> solution0, Pair<Double, T> solution1) {
                    if ((Double)solution0.getLeft() < (Double)solution1.getLeft()) {
                        return 1;
                    }
                    if ((Double)solution0.getLeft() > (Double)solution1.getLeft()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }

        private int numSolutions() {
            return this.solutions.size();
        }

        private T getBestSolutionIfAny() {
            if (this.numSolutions() == 0 || !this.isCovered()) {
                return null;
            }
            return (TestChromosome)this.solutions.get(0).getRight();
        }

        private void shrinkPopulation(int newPopulationSize) {
            assert (newPopulationSize > 0);
            if (this.isCovered()) {
                return;
            }
            this.capacity = newPopulationSize;
            if (this.numSolutions() < newPopulationSize) {
                return;
            }
            ArrayList shrinkSolutions = new ArrayList(newPopulationSize);
            for (int i = 0; i < newPopulationSize; ++i) {
                shrinkSolutions.add(this.solutions.get(i));
            }
            this.solutions.clear();
            this.solutions.addAll(shrinkSolutions);
        }

        public int hashCode() {
            return 31 * this.counter + this.capacity + this.solutions.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Population p = (Population)obj;
            if (this.counter != p.counter) {
                return false;
            }
            if (this.capacity != p.capacity) {
                return false;
            }
            if (this.solutions.size() != p.solutions.size()) {
                return false;
            }
            return this.solutions.equals(p.solutions);
        }
    }
}

