/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;

public class DominanceComparator
implements Comparator<Chromosome>,
Serializable {
    private static final long serialVersionUID = -3962098107892633870L;

    @Override
    public int compare(Chromosome c1, Chromosome c2) {
        boolean dominate1 = false;
        boolean dominate2 = false;
        for (FitnessFunction<?> ff : c1.getFitnessValues().keySet()) {
            double value2;
            double value1 = c1.getFitness(ff);
            int flag = value1 < (value2 = c2.getFitness(ff)) ? -1 : (value1 > value2 ? 1 : 0);
            if (flag == -1) {
                dominate1 = true;
            }
            if (flag != 1) continue;
            dominate2 = true;
        }
        if (dominate1 == dominate2) {
            return 0;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

