/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.FitnessReplacementFunction;
import org.evosuite.ga.Neighbourhood;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellularGA<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 7846967347821123201L;
    private static final Logger logger = LoggerFactory.getLogger(CellularGA.class);
    protected ReplacementFunction replacementFunction;
    private Neighbourhood<T> neighb;
    private List<T> temp_cells = new ArrayList<T>();
    private static final double DELTA = 1.0E-9;

    public CellularGA(Properties.CGA_Models model, ChromosomeFactory<T> factory) {
        super(factory);
        this.neighb = new Neighbourhood(Properties.POPULATION);
        this.setReplacementFunction(new FitnessReplacementFunction());
        LoggingUtils.getEvoLogger().info("* Running the Cellular GA with the '" + (Object)((Object)Properties.MODEL) + "' neighbourhoods model ");
    }

    public void run() {
        this.evolve();
        this.replacePopulations(this.population, this.temp_cells);
        for (Chromosome individual : this.population) {
            assert (((TestSuiteChromosome)individual).totalLengthOfTestCases() < Properties.MAX_SIZE * Properties.CHROMOSOME_LENGTH);
        }
        this.updateFitnessFunctionsAndValues();
        ++this.currentIteration;
    }

    @Override
    public void evolve() {
        this.temp_cells = this.elitism();
        for (int i = 0; i < this.population.size() - this.temp_cells.size(); ++i) {
            Chromosome offspring2;
            Chromosome offspring1;
            block7: {
                List<T> neighbors = this.neighb.getNeighbors(this.population, i);
                if (this.getFitnessFunction().isMaximizationFunction()) {
                    Collections.sort(neighbors, Collections.reverseOrder());
                } else {
                    Collections.sort(neighbors);
                }
                List<T> parents = this.selectionFunction.select(neighbors, 2);
                Chromosome parent1 = (Chromosome)parents.get(0);
                Chromosome parent2 = (Chromosome)parents.get(1);
                offspring1 = parent1.clone();
                offspring2 = parent2.clone();
                try {
                    if (!(Randomness.nextDouble() <= Properties.CROSSOVER_RATE)) break block7;
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                catch (ConstructionFailedException e) {
                    logger.info("CrossOver failed");
                    continue;
                }
            }
            Chromosome bestOffspring = this.getBestOffspring(offspring1, offspring2);
            this.notifyMutation(bestOffspring);
            bestOffspring.mutate();
            if (bestOffspring.isChanged()) {
                bestOffspring.updateAge(this.currentIteration);
            }
            if (bestOffspring.size() > 0 && !this.isTooLong(bestOffspring)) {
                this.temp_cells.add(bestOffspring);
                continue;
            }
            this.temp_cells.add(this.population.get(i));
        }
    }

    public void replacePopulations(List<T> main, List<T> temp) {
        assert (main.size() == temp.size());
        for (int i = 0; i < Properties.POPULATION; ++i) {
            Chromosome mainIndividual = (Chromosome)main.get(i);
            Chromosome tempIndividual = (Chromosome)temp.get(i);
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(mainIndividual);
                this.notifyEvaluation(mainIndividual);
                fitnessFunction.getFitness(tempIndividual);
                this.notifyEvaluation(tempIndividual);
            }
            if (!this.isBetterOrEqual(tempIndividual, mainIndividual) || tempIndividual.size() <= 0 || this.isTooLong(tempIndividual)) continue;
            main.set(i, tempIndividual);
        }
    }

    public T getBestOffspring(T offspring1, T offspring2) {
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(offspring1);
            this.notifyEvaluation((Chromosome)offspring1);
            fitnessFunction.getFitness(offspring2);
            this.notifyEvaluation((Chromosome)offspring2);
        }
        if (this.isBetterOrEqual((Chromosome)offspring1, (Chromosome)offspring2)) {
            return offspring1;
        }
        return offspring2;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        logger.debug("Calculating fitness of initial population");
        this.calculateFitnessAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        if (this.population.isEmpty()) {
            this.initializePopulation();
            assert (!this.population.isEmpty()) : "Could not create any test";
        }
        logger.debug("Starting evolution");
        int starvationCounter = 0;
        double bestFitness = Double.MAX_VALUE;
        double lastBestFitness = Double.MAX_VALUE;
        if (this.getFitnessFunction().isMaximizationFunction()) {
            bestFitness = 0.0;
            lastBestFitness = 0.0;
        }
        while (!this.isFinished()) {
            logger.info("Population size before: " + this.population.size());
            double bestFitnessBeforeEvolution = this.getBestFitness();
            this.run();
            this.sortPopulation();
            double bestFitnessAfterEvolution = this.getBestFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(bestFitnessAfterEvolution >= bestFitnessBeforeEvolution - 1.0E-9) : !$assertionsDisabled && !(bestFitnessAfterEvolution <= bestFitnessBeforeEvolution + 1.0E-9)) {
                throw new AssertionError((Object)("best fitness before evolve()/sortPopulation() was: " + bestFitnessBeforeEvolution + ", now best fitness is " + bestFitnessAfterEvolution));
            }
            double bestFitnessBeforeLocalSearch = this.getBestFitness();
            this.applyLocalSearch();
            double bestFitnessAfterLocalSearch = this.getBestFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(bestFitnessAfterLocalSearch >= bestFitnessBeforeLocalSearch - 1.0E-9) : !$assertionsDisabled && !(bestFitnessAfterLocalSearch <= bestFitnessBeforeLocalSearch + 1.0E-9)) {
                throw new AssertionError((Object)("best fitness before applyLocalSearch() was: " + bestFitnessBeforeLocalSearch + ", now best fitness is " + bestFitnessAfterLocalSearch));
            }
            double newFitness = this.getBestFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(newFitness >= bestFitness - 1.0E-9) : !$assertionsDisabled && !(newFitness <= bestFitness + 1.0E-9)) {
                throw new AssertionError((Object)("best fitness was: " + bestFitness + ", now best fitness is " + newFitness));
            }
            bestFitness = newFitness;
            if (Double.compare(bestFitness, lastBestFitness) == 0) {
                ++starvationCounter;
            } else {
                logger.info("reset starvationCounter after " + starvationCounter + " iterations");
                starvationCounter = 0;
                lastBestFitness = bestFitness;
            }
            this.updateSecondaryCriterion(starvationCounter);
            logger.info("Current iteration: " + this.currentIteration);
            this.notifyIteration();
            logger.info("Population size: " + this.population.size());
            logger.info("Best individual has fitness: " + ((Chromosome)this.population.get(0)).getFitness());
            logger.info("Worst individual has fitness: " + ((Chromosome)this.population.get(this.population.size() - 1)).getFitness());
        }
        TimeController.execute(this::updateBestIndividualFromArchive, "update from archive", 5000L);
        this.notifySearchFinished();
    }

    private double getBestFitness() {
        Object bestIndividual = this.getBestIndividual();
        for (FitnessFunction ff : this.fitnessFunctions) {
            ff.getFitness(bestIndividual);
        }
        return ((Chromosome)bestIndividual).getFitness();
    }

    public void setReplacementFunction(ReplacementFunction replacement_function) {
        this.replacementFunction = replacement_function;
    }

    public ReplacementFunction getReplacementFunction() {
        return this.replacementFunction;
    }
}

