/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.tuple.Pair;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.comparators.StrengthFitnessComparator;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPEA2<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = -7638497183625040479L;
    private static final Logger logger = LoggerFactory.getLogger(SPEA2.class);
    private DominanceComparator comparator = new DominanceComparator();
    private List<T> archive = null;

    public SPEA2(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        ArrayList<Chromosome> offspringPopulation = new ArrayList<Chromosome>(Properties.POPULATION);
        while (offspringPopulation.size() < Properties.POPULATION) {
            T parent1 = this.selectionFunction.select(this.archive);
            T parent2 = this.selectionFunction.select(this.archive);
            Chromosome offspring1 = ((Chromosome)parent1).clone();
            Chromosome chromosome = ((Chromosome)parent2).clone();
            if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                try {
                    this.crossoverFunction.crossOver(offspring1, chromosome);
                }
                catch (ConstructionFailedException e) {
                    logger.error("Crossover failed: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (Randomness.nextDouble() <= Properties.MUTATION_RATE) {
                this.notifyMutation(offspring1);
                offspring1.mutate();
                this.notifyMutation(chromosome);
                chromosome.mutate();
            }
            offspringPopulation.add(offspring1);
            offspringPopulation.add(chromosome);
        }
        for (Chromosome element : offspringPopulation) {
            for (FitnessFunction<Chromosome> fitnessFunction : this.getFitnessFunctions()) {
                fitnessFunction.getFitness(element);
                this.notifyEvaluation(element);
            }
        }
        this.population.clear();
        this.population.addAll(offspringPopulation);
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.archive = new ArrayList<T>(Properties.POPULATION);
        for (Chromosome element : this.population) {
            for (FitnessFunction<Chromosome> fitnessFunction : this.getFitnessFunctions()) {
                fitnessFunction.getFitness(element);
                this.notifyEvaluation(element);
            }
        }
        this.updateArchive();
        this.writeIndividuals(this.archive);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        while (!this.isFinished()) {
            this.evolve();
            this.updateArchive();
            this.notifyIteration();
            this.writeIndividuals(this.archive);
        }
        this.population = this.archive;
        this.notifySearchFinished();
    }

    private void updateArchive() {
        ArrayList<T> union = new ArrayList<T>(2 * Properties.POPULATION);
        union.addAll(this.population);
        union.addAll(this.archive);
        this.computeStrength(union);
        this.archive = this.environmentalSelection(union);
    }

    protected List<T> environmentalSelection(List<T> union) {
        ArrayList<T> populationCopy = new ArrayList<T>(union.size());
        populationCopy.addAll(union);
        ArrayList<Chromosome> tmpPopulation = new ArrayList<Chromosome>(populationCopy.size());
        Iterator it = populationCopy.iterator();
        while (it.hasNext()) {
            Chromosome individual = (Chromosome)it.next();
            if (!(individual.getDistance() < 1.0)) continue;
            tmpPopulation.add(individual);
            it.remove();
        }
        if (tmpPopulation.size() == Properties.POPULATION) {
            return tmpPopulation;
        }
        if (tmpPopulation.size() < Properties.POPULATION) {
            Collections.sort(populationCopy, new StrengthFitnessComparator());
            int remain = (union.size() < Properties.POPULATION ? union.size() : Properties.POPULATION) - tmpPopulation.size();
            for (int i = 0; i < remain; ++i) {
                tmpPopulation.add((Chromosome)populationCopy.get(i));
            }
            return tmpPopulation;
        }
        double[][] distance = this.euclideanDistanceMatrix(tmpPopulation);
        LinkedList distanceList = new LinkedList();
        for (int i = 0; i < tmpPopulation.size(); ++i) {
            LinkedList<Pair> distanceNodeList = new LinkedList<Pair>();
            for (int j = 0; j < tmpPopulation.size(); ++j) {
                if (i == j) continue;
                distanceNodeList.add(Pair.of((Object)j, (Object)distance[i][j]));
            }
            Collections.sort(distanceNodeList, new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> pair1, Pair<Integer, Double> pair2) {
                    if ((Double)pair1.getRight() < (Double)pair2.getRight()) {
                        return -1;
                    }
                    if ((Double)pair1.getRight() > (Double)pair2.getRight()) {
                        return 1;
                    }
                    return 0;
                }
            });
            distanceList.add(distanceNodeList);
        }
        while (tmpPopulation.size() > Properties.POPULATION) {
            double minDistance = Double.POSITIVE_INFINITY;
            int minimumIndex = -1;
            block5: for (int i = 0; i < distanceList.size(); ++i) {
                List list = (List)distanceList.get(i);
                Pair point = (Pair)list.get(0);
                if ((Double)point.getRight() < minDistance) {
                    minDistance = (Double)point.getRight();
                    minimumIndex = i;
                    continue;
                }
                if ((Double)point.getRight() != minDistance) continue;
                for (int k = 0; k < list.size(); ++k) {
                    double kdist2;
                    double kdist1 = (Double)((Pair)list.get(k)).getRight();
                    if (kdist1 == (kdist2 = ((Double)((Pair)((List)distanceList.get(minimumIndex)).get(k)).getRight()).doubleValue())) continue;
                    if (!(kdist1 < kdist2)) continue block5;
                    minimumIndex = i;
                    continue block5;
                }
            }
            assert (minimumIndex != -1);
            tmpPopulation.remove(minimumIndex);
            distanceList.remove(minimumIndex);
            for (List list : distanceList) {
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext()) {
                    if ((Integer)((Pair)iterator.next()).getLeft() != minimumIndex) continue;
                    iterator.remove();
                }
            }
        }
        return tmpPopulation;
    }

    protected void computeStrength(List<T> solution) {
        int[] strength = new int[solution.size()];
        for (int i = 0; i < solution.size() - 1; ++i) {
            for (int j = i + 1; j < solution.size(); ++j) {
                int comparison = this.comparator.compare((Chromosome)solution.get(i), (Chromosome)solution.get(j));
                if (comparison < 0) {
                    int n = i;
                    strength[n] = strength[n] + 1;
                    continue;
                }
                if (comparison <= 0) continue;
                int n = j;
                strength[n] = strength[n] + 1;
            }
        }
        double[] rawFitness = new double[solution.size()];
        for (int i = 0; i < solution.size() - 1; ++i) {
            for (int j = i + 1; j < solution.size(); ++j) {
                int comparison = this.comparator.compare((Chromosome)solution.get(i), (Chromosome)solution.get(j));
                if (comparison > 0) {
                    int n = i;
                    rawFitness[n] = rawFitness[n] + (double)strength[j];
                    continue;
                }
                if (comparison >= 0) continue;
                int n = j;
                rawFitness[n] = rawFitness[n] + (double)strength[i];
            }
        }
        double[][] distance = this.euclideanDistanceMatrix(solution);
        int k = 1;
        for (int i = 0; i < distance.length; ++i) {
            Arrays.sort(distance[i]);
            double kDistance = 1.0 / (distance[i][k] + 2.0);
            ((Chromosome)solution.get(i)).setDistance(rawFitness[i] + kDistance);
        }
    }

    protected double[][] euclideanDistanceMatrix(List<T> solution) {
        double[][] distance = new double[solution.size()][solution.size()];
        for (int i = 0; i < solution.size(); ++i) {
            distance[i][i] = 0.0;
            for (int j = i + 1; j < solution.size(); ++j) {
                distance[i][j] = this.distanceBetweenObjectives((Chromosome)solution.get(i), (Chromosome)solution.get(j));
                distance[j][i] = distance[i][j];
            }
        }
        return distance;
    }

    protected double distanceBetweenObjectives(T t1, T t2) {
        double distance = 0.0;
        for (FitnessFunction<?> ff : ((Chromosome)t1).getFitnessValues().keySet()) {
            double diff = ((Chromosome)t1).getFitness(ff) - ((Chromosome)t2).getFitness(ff);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }
}

