/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.lips;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.ProgressMonitor;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.SortByFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.metaheuristics.lips.BudgetConsumptionMonitor;
import org.evosuite.ga.metaheuristics.mosa.structural.BranchesManager;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIPS<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(LIPS.class);
    protected Map<FitnessFunction<T>, T> archive = new HashMap<FitnessFunction<T>, T>();
    protected Set<FitnessFunction<T>> uncoveredBranches = new HashSet<FitnessFunction<T>>();
    protected TestSuiteFitnessFunction suiteFitness;
    protected LinkedList<FitnessFunction<T>> worklist = new LinkedList();
    protected LinkedList<FitnessFunction<T>> alreadyAttemptedBranches = new LinkedList();
    protected FitnessFunction<T> currentTarget;
    protected BranchesManager<T> CFG;
    protected long startSearch4Branch = 0L;
    protected long startGlobalSearch = 0L;
    protected long budget4branch;
    protected BudgetConsumptionMonitor budgetMonitor;

    public LIPS(ChromosomeFactory<T> factory) {
        super(factory);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.BRANCH)) {
            this.suiteFitness = new BranchCoverageSuiteFitness();
        }
        this.startGlobalSearch = System.currentTimeMillis();
        this.budgetMonitor = new BudgetConsumptionMonitor();
    }

    @Override
    protected void evolve() {
        ArrayList<Chromosome> newGeneration = new ArrayList<Chromosome>();
        Collections.sort(this.population, new SortByFitness(this.currentTarget, false));
        newGeneration.add(((Chromosome)this.population.get(0)).clone());
        newGeneration.add(((Chromosome)this.population.get(1)).clone());
        while (newGeneration.size() < Properties.POPULATION) {
            Object parent1 = this.selectionFunction.select(this.population);
            Object parent2 = this.selectionFunction.select(this.population);
            Chromosome offspring1 = ((Chromosome)parent1).clone();
            Chromosome offspring2 = ((Chromosome)parent2).clone();
            try {
                if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                this.notifyMutation(offspring1);
                offspring1.mutate();
                newGeneration.add(offspring1);
                this.notifyMutation(offspring2);
                offspring2.mutate();
                newGeneration.add(offspring2);
                if (offspring1.isChanged()) {
                    offspring1.updateAge(this.currentIteration);
                }
                if (!offspring2.isChanged()) continue;
                offspring2.updateAge(this.currentIteration);
            }
            catch (ConstructionFailedException e) {
                logger.info("CrossOver/Mutation failed.");
            }
        }
        this.population.clear();
        this.population = newGeneration;
        this.calculateFitness();
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION - 1);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        this.CFG = new BranchesManager(this.fitnessFunctions);
        this.searchInitialization();
        this.initializePopulation();
        this.calculateFitness();
        while (!this.isFinished() && this.uncoveredBranches.size() > 0) {
            this.evolve();
            if (this.archive.containsKey(this.currentTarget)) {
                if (this.worklist.size() > 0) {
                    this.currentTarget = this.worklist.removeLast();
                }
                this.startSearch4Branch = System.currentTimeMillis();
            } else if (Math.abs(System.currentTimeMillis() - this.startSearch4Branch) >= this.budget4branch) {
                this.alreadyAttemptedBranches.add(this.currentTarget);
                if (this.worklist.size() > 0) {
                    this.currentTarget = this.worklist.removeLast();
                } else {
                    this.worklist.addAll(this.alreadyAttemptedBranches);
                    this.alreadyAttemptedBranches.clear();
                    this.currentTarget = this.worklist.removeLast();
                }
                this.startSearch4Branch = System.currentTimeMillis();
                logger.debug("SWITCHING TARGET");
            }
            this.updateBudget4Branch();
            ++this.currentIteration;
            this.notifyIteration();
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Time2MaxCoverage, this.budgetMonitor.getTime2MaxCoverage());
        this.notifySearchFinished();
    }

    private void calculateFitness() {
        for (Chromosome test : this.population) {
            test.setChanged(true);
            this.runTest(test);
            double value = this.currentTarget.getFitness(test);
            if (value == 0.0) {
                this.updateArchive(test, this.currentTarget);
                this.updateWorkList(test);
            }
            this.computeCollateralCoverage(test);
            this.budgetMonitor.checkMaxCoverage(this.archive.keySet().size());
        }
    }

    protected void searchInitialization() {
        logger.info("generating firts test t0");
        this.notifySearchStarted();
        for (FitnessFunction goal : this.fitnessFunctions) {
            this.uncoveredBranches.add(goal);
        }
        this.worklist.addAll(this.CFG.getGraph().getRootBranches());
        Object t0 = this.chromosomeFactory.getChromosome();
        this.runTest(t0);
        this.population.add(t0);
        this.updateWorkList(t0);
        this.currentTarget = this.worklist.removeLast();
    }

    protected void runTest(T c) {
        if (!((Chromosome)c).isChanged()) {
            return;
        }
        TestCase test = ((TestChromosome)c).getTestCase();
        ExecutionResult result = TestCaseExecutor.runTest(test);
        ((TestChromosome)c).setLastExecutionResult(result);
        ((Chromosome)c).setChanged(false);
        this.notifyEvaluation((Chromosome)c);
    }

    protected void computeCollateralCoverage(T c) {
        for (FitnessFunction fitnessFunction : this.worklist) {
            double value = fitnessFunction.getFitness(c);
            if (value != 0.0) continue;
            this.updateArchive(c, fitnessFunction);
        }
        this.worklist.removeAll(this.archive.keySet());
        this.alreadyAttemptedBranches.removeAll(this.archive.keySet());
    }

    protected void updateWorkList(T c) {
        HashSet<FitnessFunction> coveredBranches = new HashSet<FitnessFunction>();
        for (FitnessFunction branch : this.fitnessFunctions) {
            double value = branch.getFitness(c);
            if (value != 0.0) continue;
            coveredBranches.add(branch);
        }
        for (FitnessFunction branch : coveredBranches) {
            this.updateArchive(c, branch);
            for (FitnessFunction<T> dependent : this.CFG.getGraph().getStructuralChildren(branch)) {
                if (!this.uncoveredBranches.contains(dependent) || this.worklist.contains(dependent)) continue;
                this.worklist.addFirst(dependent);
            }
        }
    }

    private void updateArchive(T solution, FitnessFunction<T> covered) {
        TestChromosome tch = (TestChromosome)solution;
        tch.getTestCase().getCoveredGoals().add((TestFitnessFunction)covered);
        if (!this.archive.containsKey(covered)) {
            this.archive.put(covered, solution);
            this.uncoveredBranches.remove(covered);
        }
    }

    @Override
    protected void notifyEvaluation(Chromosome chromosome) {
        for (SearchListener listener : this.listeners) {
            if (listener instanceof ProgressMonitor) continue;
            listener.fitnessEvaluation(chromosome);
        }
    }

    @Override
    public T getBestIndividual() {
        TestSuiteChromosome best = new TestSuiteChromosome();
        for (Chromosome test : this.getArchive()) {
            best.addTest((TestChromosome)test);
        }
        double coverage = (double)this.archive.size() / (double)this.fitnessFunctions.size();
        best.setCoverage(this.suiteFitness, coverage);
        best.setFitness(this.suiteFitness, this.fitnessFunctions.size() - this.archive.size());
        return (T)best;
    }

    protected List<T> getArchive() {
        HashSet<T> set = new HashSet<T>();
        set.addAll(this.archive.values());
        ArrayList<T> arch = new ArrayList<T>();
        arch.addAll(set);
        return arch;
    }

    @Override
    public List<T> getBestIndividuals() {
        TestSuiteChromosome bestTestCases = new TestSuiteChromosome();
        for (Chromosome chromosome : this.getFinalTestSuite()) {
            bestTestCases.addTest((TestChromosome)chromosome);
        }
        for (FitnessFunction fitnessFunction : this.archive.keySet()) {
            bestTestCases.getCoveredGoals().add((TestFitnessFunction)fitnessFunction);
        }
        double fitness = (double)this.fitnessFunctions.size() - this.numberOfCoveredTargets();
        double coverage = this.numberOfCoveredTargets() / (double)this.fitnessFunctions.size();
        bestTestCases.setFitness(this.suiteFitness, fitness);
        bestTestCases.setCoverage(this.suiteFitness, coverage);
        bestTestCases.setNumOfCoveredGoals(this.suiteFitness, (int)this.numberOfCoveredTargets());
        bestTestCases.setNumOfNotCoveredGoals(this.suiteFitness, (int)((double)this.fitnessFunctions.size() - this.numberOfCoveredTargets()));
        ArrayList<TestSuiteChromosome> bests = new ArrayList<TestSuiteChromosome>(1);
        bests.add(bestTestCases);
        return bests;
    }

    protected List<T> getFinalTestSuite() {
        if (this.numberOfCoveredTargets() == 0.0) {
            return this.getArchive();
        }
        if (this.archive.size() == 0) {
            if (this.population.size() > 0) {
                ArrayList list = new ArrayList();
                list.add(this.population.get(this.population.size() - 1));
                return list;
            }
            return this.getArchive();
        }
        List<T> final_tests = this.getArchive();
        return final_tests;
    }

    protected double numberOfCoveredTargets() {
        return this.archive.keySet().size();
    }

    protected void updateBudget4Branch() {
        long budgetLeft = Properties.SEARCH_BUDGET * 1000L - (System.currentTimeMillis() - this.startGlobalSearch);
        long n_targets = this.fitnessFunctions.size() - this.archive.size() - this.alreadyAttemptedBranches.size();
        if (n_targets > 0L) {
            this.budget4branch = budgetLeft / n_targets;
        }
    }
}

