/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.ProgressMonitor;
import org.evosuite.Properties;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.exception.ExceptionCoverageHelper;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.metaheuristics.mosa.FastNonDominatedSorting;
import org.evosuite.ga.metaheuristics.mosa.MOSA;
import org.evosuite.ga.metaheuristics.mosa.MOSATournamentSelection;
import org.evosuite.ga.metaheuristics.mosa.RankBasedPreferenceSorting;
import org.evosuite.ga.metaheuristics.mosa.Ranking;
import org.evosuite.ga.metaheuristics.mosa.comparators.MOSADominanceComparator;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.secondaryobjectives.TestCaseSecondaryObjective;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMOSA<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(MOSA.class);
    protected List<TestSuiteFitnessFunction> suiteFitnesses;
    protected SelectionFunction<T> selectionFunction = new MOSATournamentSelection();
    protected Ranking<T> ranking;

    public AbstractMOSA(ChromosomeFactory<T> factory) {
        super(factory);
        this.suiteFitnesses = new ArrayList<TestSuiteFitnessFunction>();
        for (Properties.Criterion criterion : Properties.CRITERION) {
            TestSuiteFitnessFunction fit = FitnessFunctions.getFitnessFunction(criterion);
            this.suiteFitnesses.add(fit);
        }
        this.ranking = Properties.RANKING_TYPE == Properties.RankingType.PREFERENCE_SORTING ? new RankBasedPreferenceSorting() : (Properties.RANKING_TYPE == Properties.RankingType.FAST_NON_DOMINATED_SORTING ? new FastNonDominatedSorting() : new RankBasedPreferenceSorting());
        TestCaseSecondaryObjective.setSecondaryObjectives();
    }

    protected List<T> breedNextGeneration() {
        int i;
        ArrayList<Chromosome> offspringPopulation = new ArrayList<Chromosome>(Properties.POPULATION);
        for (i = 0; i < Properties.POPULATION / 2 && !this.isFinished(); ++i) {
            Chromosome offspring2;
            Chromosome offspring1;
            T parent2;
            T parent1;
            block8: {
                parent1 = this.selectionFunction.select(this.population);
                parent2 = this.selectionFunction.select(this.population);
                offspring1 = ((Chromosome)parent1).clone();
                offspring2 = ((Chromosome)parent2).clone();
                try {
                    if (!(Randomness.nextDouble() <= Properties.CROSSOVER_RATE)) break block8;
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                catch (ConstructionFailedException e) {
                    logger.debug("CrossOver failed.");
                    continue;
                }
            }
            this.removeUnusedVariables(offspring1);
            this.removeUnusedVariables(offspring2);
            this.mutate(offspring1, parent1);
            if (offspring1.isChanged()) {
                this.clearCachedResults(offspring1);
                offspring1.updateAge(this.currentIteration);
                this.calculateFitness(offspring1);
                offspringPopulation.add(offspring1);
            }
            this.mutate(offspring2, parent2);
            if (!offspring2.isChanged()) continue;
            this.clearCachedResults(offspring2);
            offspring2.updateAge(this.currentIteration);
            this.calculateFitness(offspring2);
            offspringPopulation.add(offspring2);
        }
        i = 0;
        while ((double)i < (double)Properties.POPULATION * Properties.P_TEST_INSERTION) {
            Chromosome tch = null;
            if (this.getCoveredGoals().size() == 0 || Randomness.nextBoolean()) {
                tch = (Chromosome)this.chromosomeFactory.getChromosome();
                tch.setChanged(true);
            } else {
                tch = ((Chromosome)Randomness.choice(this.getArchive())).clone();
                tch.mutate();
                tch.mutate();
            }
            if (tch.isChanged()) {
                tch.updateAge(this.currentIteration);
                this.calculateFitness(tch);
                offspringPopulation.add(tch);
            }
            ++i;
        }
        logger.info("Number of offsprings = {}", (Object)offspringPopulation.size());
        return offspringPopulation;
    }

    private void mutate(T offspring, T parent) {
        ((Chromosome)offspring).mutate();
        TestChromosome tch = (TestChromosome)offspring;
        if (!((Chromosome)offspring).isChanged()) {
            ((Chromosome)offspring).mutate();
        }
        if (!this.hasMethodCall(offspring)) {
            tch.setTestCase(((TestChromosome)parent).getTestCase().clone());
            boolean changed = tch.mutationInsert();
            if (changed) {
                for (Statement s : tch.getTestCase()) {
                    s.isValid();
                }
            }
            ((Chromosome)offspring).setChanged(changed);
        }
        this.notifyMutation((Chromosome)offspring);
    }

    private boolean hasMethodCall(T test) {
        boolean flag = false;
        TestCase tc = ((TestChromosome)test).getTestCase();
        for (Statement s : tc) {
            EntityWithParametersStatement ms;
            boolean isTargetMethod;
            if (s instanceof MethodStatement && (isTargetMethod = ((MethodStatement)(ms = (MethodStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) {
                return true;
            }
            if (!(s instanceof ConstructorStatement) || !(isTargetMethod = ((ConstructorStatement)(ms = (ConstructorStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) continue;
            return true;
        }
        return flag;
    }

    public void clearCachedResults(T chromosome) {
        ((TestChromosome)chromosome).clearCachedMutationResults();
        ((TestChromosome)chromosome).clearCachedResults();
        ((TestChromosome)chromosome).clearMutationHistory();
        ((TestChromosome)chromosome).getFitnessValues().clear();
    }

    public boolean removeUnusedVariables(T chromosome) {
        int sizeBefore = ((Chromosome)chromosome).size();
        TestCase t = ((TestChromosome)chromosome).getTestCase();
        ArrayList<Integer> to_delete = new ArrayList<Integer>(((Chromosome)chromosome).size());
        boolean has_deleted = false;
        int num = 0;
        for (Statement s : t) {
            VariableReference var = s.getReturnValue();
            boolean delete = false;
            delete = delete || s instanceof PrimitiveStatement;
            delete = delete || s instanceof ArrayStatement;
            boolean bl = delete = delete || s instanceof StringPrimitiveStatement;
            if (!t.hasReferences(var) && delete) {
                to_delete.add(num);
                has_deleted = true;
            }
            ++num;
        }
        Collections.sort(to_delete, Collections.reverseOrder());
        for (Integer position : to_delete) {
            t.remove(position);
        }
        int sizeAfter = ((Chromosome)chromosome).size();
        if (has_deleted) {
            logger.debug("Removed {} unused statements", (Object)(sizeBefore - sizeAfter));
        }
        return has_deleted;
    }

    @Override
    protected void notifyEvaluation(Chromosome chromosome) {
        for (SearchListener listener : this.listeners) {
            if (listener instanceof ProgressMonitor) continue;
            listener.fitnessEvaluation(chromosome);
        }
    }

    protected void calculateFitness() {
        logger.debug("Calculating fitness for " + this.population.size() + " individuals");
        Iterator iterator = this.population.iterator();
        while (iterator.hasNext()) {
            Chromosome c = (Chromosome)iterator.next();
            if (this.isFinished()) {
                if (!c.isChanged()) continue;
                iterator.remove();
                continue;
            }
            this.calculateFitness(c);
        }
    }

    @Override
    public List<T> getBestIndividuals() {
        List<T> finalTestSuite = this.getFinalTestSuite();
        if (finalTestSuite.isEmpty()) {
            return Arrays.asList(new TestSuiteChromosome());
        }
        TestSuiteChromosome bestTestCases = new TestSuiteChromosome();
        for (Chromosome chromosome : finalTestSuite) {
            bestTestCases.addTest((TestChromosome)chromosome);
        }
        for (FitnessFunction fitnessFunction : this.getCoveredGoals()) {
            bestTestCases.getCoveredGoals().add((TestFitnessFunction)fitnessFunction);
        }
        double fitness = (double)this.fitnessFunctions.size() - this.numberOfCoveredTargets();
        double coverage = this.numberOfCoveredTargets() / (double)this.fitnessFunctions.size();
        for (TestSuiteFitnessFunction suiteFitness : this.suiteFitnesses) {
            bestTestCases.setFitness(suiteFitness, fitness);
            bestTestCases.setCoverage(suiteFitness, coverage);
            bestTestCases.setNumOfCoveredGoals(suiteFitness, (int)this.numberOfCoveredTargets());
            bestTestCases.setNumOfNotCoveredGoals(suiteFitness, (int)((double)this.fitnessFunctions.size() - this.numberOfCoveredTargets()));
        }
        ArrayList<TestSuiteChromosome> bests = new ArrayList<TestSuiteChromosome>(1);
        bests.add(bestTestCases);
        return bests;
    }

    protected abstract void calculateFitness(T var1);

    protected abstract List<T> getFinalTestSuite();

    protected abstract List<T> getArchive();

    protected List<T> getNonDominatedSolutions(List<T> solutions) {
        MOSADominanceComparator<T> comparator = new MOSADominanceComparator<T>(this.getCoveredGoals());
        ArrayList<Chromosome> next_front = new ArrayList<Chromosome>(solutions.size());
        for (Chromosome p : solutions) {
            boolean isDominated = false;
            ArrayList<Chromosome> dominatedSolutions = new ArrayList<Chromosome>(solutions.size());
            for (Chromosome best : next_front) {
                int flag = comparator.compare(p, best);
                if (flag == -1) {
                    dominatedSolutions.add(best);
                }
                if (flag != 1) continue;
                isDominated = true;
            }
            if (isDominated) continue;
            next_front.add(p);
            next_front.removeAll(dominatedSolutions);
        }
        return next_front;
    }

    protected boolean areEqual(T test1, T test2) {
        TestChromosome tch1 = (TestChromosome)test1;
        TestChromosome tch2 = (TestChromosome)test2;
        if (tch1.size() != tch2.size()) {
            return false;
        }
        if (tch1.size() == 0) {
            return false;
        }
        if (tch2.size() == 0) {
            return false;
        }
        return tch1.getTestCase().toCode().equals(tch2.getTestCase().toCode());
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.calculateFitness();
        this.notifyIteration();
    }

    protected abstract double numberOfCoveredTargets();

    public abstract Set<FitnessFunction<T>> getCoveredGoals();

    public List<ExceptionCoverageTestFitness> deriveCoveredExceptions(T t) {
        ArrayList<ExceptionCoverageTestFitness> covered_exceptions = new ArrayList<ExceptionCoverageTestFitness>();
        TestChromosome testCh = (TestChromosome)t;
        ExecutionResult result = testCh.getLastExecutionResult();
        LinkedHashMap implicitTypesOfExceptions = new LinkedHashMap();
        LinkedHashMap explicitTypesOfExceptions = new LinkedHashMap();
        LinkedHashMap declaredTypesOfExceptions = new LinkedHashMap();
        for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
            boolean notDeclared;
            if (ExceptionCoverageHelper.shouldSkip(result, i)) continue;
            Class<?> exceptionClass = ExceptionCoverageHelper.getExceptionClass(result, i);
            String methodIdentifier = ExceptionCoverageHelper.getMethodIdentifier(result, i);
            boolean sutException = ExceptionCoverageHelper.isSutException(result, i);
            if (!sutException) continue;
            boolean bl = notDeclared = !ExceptionCoverageHelper.isDeclared(result, i);
            if (notDeclared) {
                boolean isExplicit = ExceptionCoverageHelper.isExplicit(result, i);
                if (isExplicit) {
                    if (!explicitTypesOfExceptions.containsKey(methodIdentifier)) {
                        explicitTypesOfExceptions.put(methodIdentifier, new LinkedHashSet());
                    }
                    ((Set)explicitTypesOfExceptions.get(methodIdentifier)).add(exceptionClass);
                } else {
                    if (!implicitTypesOfExceptions.containsKey(methodIdentifier)) {
                        implicitTypesOfExceptions.put(methodIdentifier, new LinkedHashSet());
                    }
                    ((Set)implicitTypesOfExceptions.get(methodIdentifier)).add(exceptionClass);
                }
            } else {
                if (!declaredTypesOfExceptions.containsKey(methodIdentifier)) {
                    declaredTypesOfExceptions.put(methodIdentifier, new LinkedHashSet());
                }
                ((Set)declaredTypesOfExceptions.get(methodIdentifier)).add(exceptionClass);
            }
            ExceptionCoverageTestFitness.ExceptionType type = ExceptionCoverageHelper.getType(result, i);
            ExceptionCoverageTestFitness goal = new ExceptionCoverageTestFitness(Properties.TARGET_CLASS, methodIdentifier, exceptionClass, type);
            covered_exceptions.add(goal);
        }
        return covered_exceptions;
    }
}

