/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mosa.Ranking;
import org.evosuite.ga.metaheuristics.mosa.comparators.MOSADominanceComparator;

public class FastNonDominatedSorting<T extends Chromosome>
implements Ranking<T> {
    private List<T>[] ranking_;
    private Map<FitnessFunction<T>, T> newCoveredGoals = new LinkedHashMap<FitnessFunction<T>, T>();

    @Override
    public void computeRankingAssignment(List<T> solutions, Set<FitnessFunction<T>> uncovered_goals) {
        List<T>[] fronts = this.getNextNonDominatedFronts(solutions, uncovered_goals);
        this.ranking_ = new ArrayList[fronts.length];
        for (int i = 0; i < fronts.length; ++i) {
            this.ranking_[i] = fronts[i];
        }
    }

    private List<T>[] getNextNonDominatedFronts(List<T> solutionSet, Set<FitnessFunction<T>> uncovered_goals) {
        int p;
        int i;
        MOSADominanceComparator<T> criterion_ = new MOSADominanceComparator<T>(uncovered_goals);
        List<T> solutionSet_ = solutionSet;
        int[] dominateMe = new int[solutionSet_.size()];
        List[] iDominate = new List[solutionSet_.size()];
        List[] front = new List[solutionSet_.size() + 1];
        for (i = 0; i < front.length; ++i) {
            front[i] = new LinkedList();
        }
        for (p = 0; p < solutionSet_.size(); ++p) {
            ((Chromosome)solutionSet.get(p)).setDistance(Double.MAX_VALUE);
        }
        for (p = 0; p < solutionSet_.size(); ++p) {
            iDominate[p] = new LinkedList();
            dominateMe[p] = 0;
        }
        for (p = 0; p < solutionSet_.size() - 1; ++p) {
            for (int q = p + 1; q < solutionSet_.size(); ++q) {
                int flagDominate = criterion_.compare((Object)solutionSet.get(p), (Object)solutionSet.get(q));
                if (flagDominate == -1) {
                    iDominate[p].add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                iDominate[q].add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (p = 0; p < solutionSet_.size(); ++p) {
            if (dominateMe[p] != 0) continue;
            front[0].add(p);
            ((Chromosome)solutionSet.get(p)).setRank(1);
        }
        i = 0;
        while (front[i].size() != 0) {
            Iterator it1 = front[++i - 1].iterator();
            while (it1.hasNext()) {
                Iterator it2 = iDominate[(Integer)it1.next()].iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    front[i].add(index);
                    ((Chromosome)solutionSet_.get(index)).setRank(i + 1);
                }
            }
        }
        ArrayList[] fronts = new ArrayList[i];
        for (int j = 0; j < i; ++j) {
            fronts[j] = new ArrayList();
            Iterator it1 = front[j].iterator();
            while (it1.hasNext()) {
                fronts[j].add(solutionSet.get((Integer)it1.next()));
            }
        }
        return fronts;
    }

    @Override
    public List<T> getSubfront(int rank) {
        return this.ranking_[rank];
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.ranking_.length;
    }

    public Map<FitnessFunction<T>, T> getNewCoveredGoals() {
        return this.newCoveredGoals;
    }
}

