/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.Comparator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.mosa.comparators.RankAndCrowdingDistanceComparator;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.utils.Randomness;

public class MOSATournamentSelection<T extends Chromosome>
extends SelectionFunction<T> {
    private static final long serialVersionUID = -7465418404056357932L;
    private Comparator<Object> comparator = new RankAndCrowdingDistanceComparator();

    @Override
    public int getIndex(List<T> population) {
        int new_num;
        int winner = new_num = Randomness.nextInt(population.size());
        for (int round = 0; round < Properties.TOURNAMENT_SIZE - 1; ++round) {
            Chromosome selected;
            int flag;
            new_num = Randomness.nextInt(population.size());
            if (new_num == winner) {
                new_num = (new_num + 1) % population.size();
            }
            if ((flag = this.comparator.compare(selected = (Chromosome)population.get(new_num), population.get(winner))) != -1) continue;
            winner = new_num;
        }
        return winner;
    }

    @Override
    public T select(List<T> population) {
        return (T)((Chromosome)population.get(this.getIndex(population)));
    }
}

