/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mosa.structural.DependencyEdge;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchFitnessGraph<T extends Chromosome, V extends FitnessFunction<T>> {
    private static final Logger logger = LoggerFactory.getLogger(BranchFitnessGraph.class);
    protected DefaultDirectedGraph<FitnessFunction<T>, DependencyEdge> graph = new DefaultDirectedGraph(DependencyEdge.class);
    protected Set<FitnessFunction<T>> rootBranches = new HashSet<FitnessFunction<T>>();

    public BranchFitnessGraph(Set<FitnessFunction<T>> goals) {
        for (FitnessFunction<T> fitness : goals) {
            this.graph.addVertex(fitness);
        }
        for (FitnessFunction<T> fitness : goals) {
            Branch branch = ((BranchCoverageTestFitness)fitness).getBranch();
            if (branch == null) {
                this.rootBranches.add(fitness);
                continue;
            }
            if (branch.getInstruction().isRootBranchDependent()) {
                this.rootBranches.add(fitness);
            }
            ActualControlFlowGraph rcfg = branch.getInstruction().getActualCFG();
            HashSet<BasicBlock> visitedBlock = new HashSet<BasicBlock>();
            Set<BasicBlock> parents = this.lookForParent(branch.getInstruction().getBasicBlock(), rcfg, visitedBlock);
            for (BasicBlock bb : parents) {
                Branch newB = this.extractBranch(bb);
                if (newB == null) {
                    this.rootBranches.add(fitness);
                    continue;
                }
                BranchCoverageGoal goal = new BranchCoverageGoal(newB, true, newB.getClassName(), newB.getMethodName());
                BranchCoverageTestFitness newFitness = new BranchCoverageTestFitness(goal);
                this.graph.addEdge((Object)newFitness, fitness);
                BranchCoverageGoal goal2 = new BranchCoverageGoal(newB, false, newB.getClassName(), newB.getMethodName());
                BranchCoverageTestFitness newfitness2 = new BranchCoverageTestFitness(goal2);
                this.graph.addEdge((Object)newfitness2, fitness);
            }
        }
    }

    public Set<BasicBlock> lookForParent(BasicBlock block, ActualControlFlowGraph acfg, Set<BasicBlock> visitedBlock) {
        HashSet<BasicBlock> realParent = new HashSet<BasicBlock>();
        Set<BasicBlock> parents = acfg.getParents(block);
        if (parents.size() == 0) {
            realParent.add(block);
            return realParent;
        }
        for (BasicBlock bb : parents) {
            if (visitedBlock.contains(bb)) continue;
            visitedBlock.add(bb);
            if (this.containsBranches(bb)) {
                realParent.add(bb);
                continue;
            }
            realParent.addAll(this.lookForParent(bb, acfg, visitedBlock));
        }
        return realParent;
    }

    public boolean containsBranches(BasicBlock block) {
        for (BytecodeInstruction inst : block) {
            if (inst.toBranch() == null) continue;
            return true;
        }
        return false;
    }

    public Branch extractBranch(BasicBlock block) {
        for (BytecodeInstruction inst : block) {
            if (!inst.isBranch() && !inst.isActualBranch()) continue;
            return inst.toBranch();
        }
        return null;
    }

    public Set<FitnessFunction<T>> getRootBranches() {
        return this.rootBranches;
    }

    public Set<FitnessFunction<T>> getStructuralChildren(FitnessFunction<T> parent) {
        Set outgoingEdges = this.graph.outgoingEdgesOf(parent);
        HashSet<FitnessFunction<T>> children = new HashSet<FitnessFunction<T>>();
        for (DependencyEdge edge : outgoingEdges) {
            children.add((FitnessFunction<T>)edge.getTarget());
        }
        return children;
    }

    public Set<FitnessFunction<T>> getStructuralParents(FitnessFunction<T> parent) {
        Set incomingEdges = this.graph.incomingEdgesOf(parent);
        HashSet<FitnessFunction<T>> parents = new HashSet<FitnessFunction<T>>();
        for (DependencyEdge edge : incomingEdges) {
            parents.add((FitnessFunction<T>)edge.getSource());
        }
        return parents;
    }
}

