/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import java.util.ArrayList;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mulambda.AbstractMuLambda;

public class MuPlusLambdaEA<T extends Chromosome>
extends AbstractMuLambda<T> {
    private static final long serialVersionUID = -8685698059226067598L;

    public MuPlusLambdaEA(ChromosomeFactory<T> factory, int mu, int lambda) {
        super(factory, mu, lambda);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void evolve() {
        ArrayList<Object> offsprings = new ArrayList<Object>(this.lambda);
        for (int i = 0; i < this.mu; ++i) {
            for (int j = 0; j < this.lambda / this.mu; ++j) {
                Chromosome offspring = ((Chromosome)this.population.get(i)).clone();
                this.notifyMutation(offspring);
                do {
                    offspring.mutate();
                } while (!offspring.isChanged());
                offsprings.add(offspring);
            }
        }
        for (Chromosome chromosome : offsprings) {
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(chromosome);
                this.notifyEvaluation(chromosome);
            }
        }
        for (int i = 0; i < this.population.size(); ++i) {
            void var3_9;
            Chromosome chromosome = (Chromosome)this.population.get(i);
            boolean offspring_is_better = false;
            for (Chromosome chromosome2 : offsprings) {
                if (!this.isBetterOrEqual(chromosome2, (Chromosome)var3_9)) continue;
                Chromosome chromosome3 = chromosome2;
                offspring_is_better = true;
            }
            if (offspring_is_better) {
                this.population.set(i, var3_9);
                offsprings.remove(var3_9);
            }
            ((Chromosome)this.population.get(i)).updateAge(this.currentIteration);
        }
        assert (this.population.size() == this.mu);
        ++this.currentIteration;
    }
}

