/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import java.util.ArrayList;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.metaheuristics.mulambda.AbstractMuLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnePlusLambdaLambdaGA<T extends Chromosome>
extends AbstractMuLambda<T> {
    private static final long serialVersionUID = 529089847512798127L;
    private static final Logger logger = LoggerFactory.getLogger(OnePlusLambdaLambdaGA.class);

    public OnePlusLambdaLambdaGA(ChromosomeFactory<T> factory, int lambda) {
        super(factory, 1, lambda);
    }

    @Override
    protected void evolve() {
        ArrayList<Chromosome> mutants = new ArrayList<Chromosome>();
        Chromosome parent = ((Chromosome)this.population.get(0)).clone();
        while (mutants.size() < this.lambda) {
            Chromosome MutationOffspring = parent.clone();
            this.notifyMutation(MutationOffspring);
            MutationOffspring.mutate();
            mutants.add(MutationOffspring);
        }
        this.population = mutants;
        this.updateFitnessFunctionsAndValues();
        this.calculateFitnessAndSortPopulation();
        Object bestMutantOffspring = this.getBestIndividual();
        ArrayList<Chromosome> crossoverOffspring = new ArrayList<Chromosome>();
        while (crossoverOffspring.size() < this.lambda) {
            try {
                Chromosome p1 = parent.clone();
                Chromosome p2 = ((Chromosome)bestMutantOffspring).clone();
                this.crossoverFunction.crossOver(p1, p2);
                crossoverOffspring.add(p1);
                crossoverOffspring.add(p2);
            }
            catch (ConstructionFailedException e) {
                logger.info("CrossOver failed.");
            }
        }
        this.population = crossoverOffspring;
        this.updateFitnessFunctionsAndValues();
        Object bestCrossoverOffspring = this.getBestIndividual();
        Object so_far_best_individual = this.isBetterOrEqual((Chromosome)bestCrossoverOffspring, parent) ? bestCrossoverOffspring : parent;
        if (this.isBetterOrEqual((Chromosome)so_far_best_individual, (Chromosome)bestMutantOffspring)) {
            this.population.set(0, so_far_best_individual);
        } else {
            this.population.set(0, bestMutantOffspring);
        }
        ++this.currentIteration;
    }
}

