/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.cfg.BytecodeAnalyzer;
import org.evosuite.instrumentation.coverage.BranchInstrumentation;
import org.evosuite.instrumentation.coverage.DefUseInstrumentation;
import org.evosuite.instrumentation.coverage.MethodInstrumentation;
import org.evosuite.instrumentation.coverage.MutationInstrumentation;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.instrumentation.AnnotatedMethodNode;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.utils.ArrayUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFGMethodAdapter
extends MethodVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CFGMethodAdapter.class);
    public static final List<String> EXCLUDE = Arrays.asList("<clinit>()V", "__STATIC_RESET()V", "__STATIC_RESET");
    public static Map<ClassLoader, Map<String, Set<String>>> methods = new HashMap<ClassLoader, Map<String, Set<String>>>();
    private final String methodName;
    private final MethodVisitor next;
    private final String plain_name;
    private final int access;
    private final String className;
    private final ClassLoader classLoader;
    private int lineNumber = 0;
    private boolean excludeMethod = false;

    public CFGMethodAdapter(ClassLoader classLoader, String className, int access, String name, String desc, String signature, String[] exceptions, MethodVisitor mv) {
        super(327680, (MethodVisitor)new AnnotatedMethodNode(access, name, desc, signature, exceptions));
        this.next = mv;
        this.className = className;
        this.access = access;
        this.methodName = name + desc;
        this.plain_name = name;
        this.classLoader = classLoader;
        if (!methods.containsKey(classLoader)) {
            methods.put(classLoader, new HashMap());
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumber = line;
        super.visitLineNumber(line, start);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Type.getDescriptor(EvoSuiteExclude.class).equals(desc)) {
            logger.info("Method has EvoSuite annotation: " + desc);
            this.excludeMethod = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        AnnotatedMethodNode mn;
        block15: {
            logger.debug("Creating CFG of " + this.className + "." + this.methodName);
            boolean isExcludedMethod = this.excludeMethod || EXCLUDE.contains(this.methodName);
            boolean isMainMethod = this.plain_name.equals("main") && Modifier.isStatic(this.access);
            ArrayList<MethodInstrumentation> instrumentations = new ArrayList<MethodInstrumentation>();
            if (DependencyAnalysis.shouldInstrument(this.className, this.methodName)) {
                if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS)) {
                    instrumentations.add(new BranchInstrumentation());
                    instrumentations.add(new DefUseInstrumentation());
                } else if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.WEAKMUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ONLYMUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
                    instrumentations.add(new BranchInstrumentation());
                    instrumentations.add(new MutationInstrumentation());
                } else {
                    instrumentations.add(new BranchInstrumentation());
                }
            }
            boolean executeOnMain = false;
            boolean executeOnExcluded = false;
            for (MethodInstrumentation instrumentation : instrumentations) {
                executeOnMain = executeOnMain || instrumentation.executeOnMainMethod();
                executeOnExcluded = executeOnExcluded || instrumentation.executeOnExcludedMethods();
            }
            mn = (AnnotatedMethodNode)this.mv;
            boolean checkForMain = false;
            if (Properties.CONSIDER_MAIN_METHODS) {
                checkForMain = true;
            } else {
                boolean bl = checkForMain = !isMainMethod || executeOnMain;
            }
            if (checkForMain && (!isExcludedMethod || executeOnExcluded) && (this.access & 0x400) == 0 && (this.access & 0x100) == 0) {
                logger.info("Analyzing method " + this.methodName + " in class " + this.className);
                BytecodeAnalyzer bytecodeAnalyzer = new BytecodeAnalyzer();
                logger.info("Generating CFG for method " + this.methodName);
                try {
                    bytecodeAnalyzer.analyze(this.classLoader, this.className, this.methodName, (MethodNode)mn);
                    logger.trace("Method graph for " + this.className + "." + this.methodName + " contains " + bytecodeAnalyzer.retrieveCFGGenerator().getRawGraph().vertexSet().size() + " nodes for " + bytecodeAnalyzer.getFrames().length + " instructions");
                    bytecodeAnalyzer.retrieveCFGGenerator().registerCFGs();
                    logger.info("Created CFG for method " + this.methodName);
                    if (!DependencyAnalysis.shouldInstrument(this.className, this.methodName)) break block15;
                    if (!methods.get(this.classLoader).containsKey(this.className)) {
                        methods.get(this.classLoader).put(this.className, new HashSet());
                    }
                    logger.info("Instrumenting method " + this.methodName + " in class " + this.className);
                    for (MethodInstrumentation instrumentation : instrumentations) {
                        instrumentation.analyze(this.classLoader, (MethodNode)mn, this.className, this.methodName, this.access);
                    }
                    this.handleBranchlessMethods();
                    String id = this.className + "." + this.methodName;
                    if (this.isUsable()) {
                        methods.get(this.classLoader).get(this.className).add(id);
                        logger.debug("Counting: " + id);
                    }
                }
                catch (AnalyzerException e) {
                    logger.error("Analyzer exception while analyzing " + this.className + "." + this.methodName + ": " + (Object)((Object)e));
                    e.printStackTrace();
                }
            } else {
                logger.debug("NOT Creating CFG of " + this.className + "." + this.methodName + ": " + checkForMain + ", " + (!isExcludedMethod || executeOnExcluded) + ", " + ((this.access & 0x400) == 0) + ", " + ((this.access & 0x100) == 0));
                super.visitEnd();
            }
        }
        mn.accept(this.next);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int maxNum = 7;
        super.visitMaxs(Math.max(maxNum, maxStack), maxLocals);
    }

    private void handleBranchlessMethods() {
        String id = this.className + "." + this.methodName;
        if (BranchPool.getInstance(this.classLoader).getNonArtificialBranchCountForMethod(this.className, this.methodName) == 0 && this.isUsable()) {
            logger.debug("Method has no branches: " + id);
            BranchPool.getInstance(this.classLoader).addBranchlessMethod(this.className, id, this.lineNumber);
        }
    }

    private boolean isUsable() {
        if ((this.access & 0x1000) != 0) {
            return false;
        }
        if ((this.access & 0x40) != 0) {
            return false;
        }
        if ((this.access & 0x100) != 0) {
            return false;
        }
        if (this.methodName.contains("<clinit>")) {
            return false;
        }
        return !(Properties.P_REFLECTION_ON_PRIVATE <= 0.0) || !this.methodName.contains("<init>") || (this.access & 2) != 2;
    }

    public Set<String> getMethods(String className) {
        return CFGMethodAdapter.getMethods(this.classLoader, className);
    }

    public static Set<String> getMethods(ClassLoader classLoader, String className) {
        HashSet<String> targetMethods = new HashSet<String>();
        if (!methods.containsKey(classLoader)) {
            return targetMethods;
        }
        for (String currentClass : methods.get(classLoader).keySet()) {
            if (!currentClass.equals(className) && !currentClass.startsWith(className + "$")) continue;
            targetMethods.addAll((Collection<String>)methods.get(classLoader).get(currentClass));
        }
        return targetMethods;
    }

    public Set<String> getMethods() {
        return CFGMethodAdapter.getMethods(this.classLoader);
    }

    public static Set<String> getMethods(ClassLoader classLoader) {
        HashSet<String> targetMethods = new HashSet<String>();
        if (!methods.containsKey(classLoader)) {
            return targetMethods;
        }
        for (String currentClass : methods.get(classLoader).keySet()) {
            targetMethods.addAll((Collection<String>)methods.get(classLoader).get(currentClass));
        }
        return targetMethods;
    }

    public Set<String> getMethodsPrefix(String className) {
        return CFGMethodAdapter.getMethodsPrefix(this.classLoader, className);
    }

    public static Set<String> getMethodsPrefix(ClassLoader classLoader, String className) {
        HashSet<String> matchingMethods = new HashSet<String>();
        if (!methods.containsKey(classLoader)) {
            return matchingMethods;
        }
        for (String name : methods.get(classLoader).keySet()) {
            if (!name.startsWith(className)) continue;
            matchingMethods.addAll((Collection<String>)methods.get(classLoader).get(name));
        }
        return matchingMethods;
    }

    public int getNumMethodsPrefix(String className) {
        return CFGMethodAdapter.getNumMethodsPrefix(this.classLoader, className);
    }

    public static int getNumMethodsPrefix(ClassLoader classLoader, String className) {
        int num = 0;
        if (!methods.containsKey(classLoader)) {
            return num;
        }
        for (String name : methods.get(classLoader).keySet()) {
            if (!name.startsWith(className)) continue;
            num += methods.get(classLoader).get(name).size();
        }
        return num;
    }

    public int getNumMethods() {
        return CFGMethodAdapter.getNumMethods(this.classLoader);
    }

    public static int getNumMethods(ClassLoader classLoader) {
        int num = 0;
        if (!methods.containsKey(classLoader)) {
            return num;
        }
        for (String name : methods.get(classLoader).keySet()) {
            num += methods.get(classLoader).get(name).size();
        }
        return num;
    }

    public int getNumMethodsMemberClasses(String className) {
        return CFGMethodAdapter.getNumMethodsMemberClasses(this.classLoader, className);
    }

    public static int getNumMethodsMemberClasses(ClassLoader classLoader, String className) {
        int num = 0;
        if (!methods.containsKey(classLoader)) {
            return num;
        }
        for (String name : methods.get(classLoader).keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            num += methods.get(classLoader).get(name).size();
        }
        return num;
    }
}

