/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.io.Serializable;
import java.util.Objects;
import org.evosuite.coverage.branch.Branch;

public class ControlDependency
implements Serializable,
Comparable<ControlDependency> {
    private static final long serialVersionUID = 6288839964561655730L;
    private final Branch branch;
    private final boolean branchExpressionValue;

    public ControlDependency(Branch branch, boolean branchExpressionValue) {
        if (branch == null) {
            throw new IllegalArgumentException("control dependencies for the root branch are not permitted (null)");
        }
        this.branch = branch;
        this.branchExpressionValue = branchExpressionValue;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public boolean getBranchExpressionValue() {
        return this.branchExpressionValue;
    }

    public String toString() {
        String r = "CD " + this.branch.toString();
        if (!this.branch.isSwitchCaseBranch()) {
            r = this.branchExpressionValue ? r + " - TRUE" : r + " - FALSE";
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlDependency that = (ControlDependency)o;
        return this.branchExpressionValue == that.branchExpressionValue && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.branch, this.branchExpressionValue);
    }

    @Override
    public int compareTo(ControlDependency o) {
        int x = this.branch.compareTo(o.branch);
        if (x != 0) {
            return x;
        }
        if (this.branchExpressionValue == o.branchExpressionValue) {
            return 0;
        }
        if (this.branchExpressionValue) {
            return 1;
        }
        return -1;
    }
}

