/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndOfClassInitializerVisitor
extends ClassVisitor {
    private static Logger logger = LoggerFactory.getLogger(EndOfClassInitializerVisitor.class);
    private final String className;
    private boolean isInterface = false;
    private boolean clinitFound = false;
    private boolean hasStaticFields = false;
    private static final String EXIT_CLASS_INIT = "exitClassInit";

    public EndOfClassInitializerVisitor(ClassVisitor visitor, String className) {
        super(327680, visitor);
        this.className = className;
    }

    public MethodVisitor visitMethod(int methodAccess, String methodName, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, methodName, descriptor, signature, exceptions);
        if (methodName.equals("<clinit>")) {
            this.clinitFound = true;
            EndOfClassInitializerMethodVisitor staticResetMethodAdapter = new EndOfClassInitializerMethodVisitor(this.className, methodName, mv);
            return staticResetMethodAdapter;
        }
        return mv;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isInterface = (access & 0x200) == 512;
    }

    public void visitEnd() {
        if (!this.clinitFound && !this.isInterface && this.hasStaticFields) {
            this.createEmptyClassInit();
        }
        super.visitEnd();
    }

    private static boolean isStatic(int access) {
        return (access & 8) == 8;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (EndOfClassInitializerVisitor.isStatic(access)) {
            this.hasStaticFields = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private void createEmptyClassInit() {
        logger.info("Creating <clinit> in class " + this.className);
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        String executionTracerClassName = ExecutionTracer.class.getName().replace('.', '/');
        String executionTracerDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)});
        String classNameWithDots = this.className.replace('/', '.');
        mv.visitLdcInsn((Object)classNameWithDots);
        mv.visitMethodInsn(184, executionTracerClassName, EXIT_CLASS_INIT, executionTracerDescriptor, false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static class EndOfClassInitializerMethodVisitor
    extends MethodVisitor {
        private final String className;
        private final String methodName;
        private Label startingTryLabel;
        private Label endingTryLabel;
        private final List<TryCatchBlock> tryCatchBlocks = new LinkedList<TryCatchBlock>();

        public EndOfClassInitializerMethodVisitor(String className, String methodName, MethodVisitor mv) {
            super(327680, mv);
            this.className = className;
            this.methodName = methodName;
        }

        public void visitInsn(int opcode) {
            if (opcode == 177 && this.methodName.equals("<clinit>")) {
                String executionTracerClassName = ExecutionTracer.class.getName().replace('.', '/');
                String executionTracerDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)});
                String classNameWithDots = this.className.replace('/', '.');
                super.visitLdcInsn((Object)classNameWithDots);
                super.visitMethodInsn(184, executionTracerClassName, EndOfClassInitializerVisitor.EXIT_CLASS_INIT, executionTracerDescriptor, false);
            }
            super.visitInsn(opcode);
        }

        public void visitCode() {
            super.visitCode();
            if (this.methodName.equals("<clinit>")) {
                this.startingTryLabel = new Label();
                this.endingTryLabel = new Label();
                super.visitLabel(this.startingTryLabel);
            }
        }

        public void visitEnd() {
            if (this.methodName.equals("<clinit>")) {
                super.visitLabel(this.endingTryLabel);
                String executionTracerClassName = ExecutionTracer.class.getName().replace('.', '/');
                String executionTracerDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)});
                String classNameWithDots = this.className.replace('/', '.');
                super.visitLdcInsn((Object)classNameWithDots);
                super.visitMethodInsn(184, executionTracerClassName, EndOfClassInitializerVisitor.EXIT_CLASS_INIT, executionTracerDescriptor, false);
                super.visitInsn(191);
                for (TryCatchBlock tryCatchBlock : this.tryCatchBlocks) {
                    super.visitTryCatchBlock(tryCatchBlock.start, tryCatchBlock.end, tryCatchBlock.handler, tryCatchBlock.type);
                }
                super.visitTryCatchBlock(this.startingTryLabel, this.endingTryLabel, this.endingTryLabel, null);
            }
            super.visitEnd();
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (this.methodName.equals("<clinit>")) {
                TryCatchBlock block = new TryCatchBlock(start, end, handler, type);
                this.tryCatchBlocks.add(block);
            }
            super.visitTryCatchBlock(start, end, handler, type);
        }

        private static class TryCatchBlock {
            Label start;
            Label end;
            Label handler;
            String type;

            public TryCatchBlock(Label start, Label end, Label handler, String type) {
                this.start = start;
                this.end = end;
                this.handler = handler;
                this.type = type;
            }
        }
    }
}

