/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.HashMap;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.instrumentation.PurityAnalysisMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PurityAnalysisClassVisitor
extends ClassVisitor {
    private final CheapPurityAnalyzer purityAnalyzer;
    private final String className;
    private final HashMap<MethodEntry, PurityAnalysisMethodVisitor> method_adapters = new HashMap();
    private boolean visitingInterface = false;

    public PurityAnalysisClassVisitor(ClassVisitor visitor, String className, CheapPurityAnalyzer purityAnalyzer) {
        super(327680, visitor);
        this.className = className;
        this.purityAnalyzer = purityAnalyzer;
    }

    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        if (this.visitingInterface) {
            this.purityAnalyzer.addInterfaceMethod(this.className.replace('/', '.'), name, descriptor);
        } else {
            this.purityAnalyzer.addMethod(this.className.replace('/', '.'), name, descriptor);
            if ((methodAccess & 0x400) != 1024) {
                this.purityAnalyzer.addMethodWithBody(this.className.replace('/', '.'), name, descriptor);
            }
        }
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        PurityAnalysisMethodVisitor purityAnalysisMethodVisitor = new PurityAnalysisMethodVisitor(this.className, name, descriptor, mv, this.purityAnalyzer);
        MethodEntry methodEntry = new MethodEntry(this.className, name, descriptor);
        this.method_adapters.put(methodEntry, purityAnalysisMethodVisitor);
        return purityAnalysisMethodVisitor;
    }

    public void visitEnd() {
        for (MethodEntry method_entry : this.method_adapters.keySet()) {
            if (!this.method_adapters.get(method_entry).updatesField()) continue;
            this.purityAnalyzer.addUpdatesFieldMethod(method_entry.className, method_entry.methodName, method_entry.descriptor);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) == 512) {
            this.visitingInterface = true;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public static class MethodEntry {
        private final String className;
        private final String methodName;
        private final String descriptor;

        public MethodEntry(String className, String methodName, String descriptor) {
            this.className = className;
            this.methodName = methodName;
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!o.getClass().equals(MethodEntry.class)) {
                return false;
            }
            MethodEntry that = (MethodEntry)o;
            return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode() + this.descriptor.hashCode();
        }
    }
}

