/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStatement
implements MutationOperator {
    private static Logger logger = LoggerFactory.getLogger(DeleteStatement.class);
    public static final String NAME = "DeleteStatement";

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        MethodInsnNode node = (MethodInsnNode)instruction.getASMNode();
        Type returnType = Type.getReturnType((String)node.desc);
        InsnList mutation = new InsnList();
        logger.info("Mutation deletestatement for statement " + node.name + node.desc);
        for (Type argType : Type.getArgumentTypes((String)node.desc)) {
            if (argType.getSize() == 0) {
                logger.info("Ignoring parameter of type " + argType);
                continue;
            }
            if (argType.getSize() == 2) {
                mutation.insert((AbstractInsnNode)new InsnNode(88));
                logger.debug("Deleting parameter of 2 type " + argType);
                continue;
            }
            logger.debug("Deleting parameter of 1 type " + argType);
            mutation.insert((AbstractInsnNode)new InsnNode(87));
        }
        if (node.getOpcode() == 182) {
            logger.debug("Deleting callee of type " + node.owner);
            mutation.add((AbstractInsnNode)new InsnNode(87));
        } else if (node.getOpcode() == 185) {
            boolean isStatic = false;
            try {
                Class<?> clazz = Class.forName(node.owner.replace('/', '.'), false, DeleteStatement.class.getClassLoader());
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(node.name) || !Type.getMethodDescriptor((Method)method).equals(node.desc) || !Modifier.isStatic(method.getModifiers())) continue;
                    isStatic = true;
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not find class: " + node.owner + ", this is likely a severe problem");
            }
            if (!isStatic) {
                logger.info("Deleting callee of type " + node.owner);
                mutation.add((AbstractInsnNode)new InsnNode(87));
            }
        }
        mutation.add(DeleteStatement.getDefault(returnType));
        Mutation mutationObject = MutationPool.addMutation(className, methodName, "DeleteStatement " + node.name + node.desc, instruction, mutation, Mutation.getDefaultInfectionDistance());
        mutations.add(mutationObject);
        return mutations;
    }

    private static AbstractInsnNode getDefault(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return new LdcInsnNode((Object)0.0);
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return new LdcInsnNode((Object)Float.valueOf(0.0f));
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return new LdcInsnNode((Object)0L);
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.VOID_TYPE)) {
            return new LabelNode();
        }
        return new InsnNode(1);
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.isMethodCall() && instruction.getASMNode().getOpcode() != 183;
    }
}

