/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Frame;

public class ReplaceArithmeticOperator
implements MutationOperator {
    public static final String NAME = "ReplaceArithmeticOperator";
    private static Set<Integer> opcodesInt = new HashSet<Integer>();
    private static Set<Integer> opcodesLong = new HashSet<Integer>();
    private static Set<Integer> opcodesFloat = new HashSet<Integer>();
    private static Set<Integer> opcodesDouble = new HashSet<Integer>();
    private int numVariable = 0;

    private String getOp(int opcode) {
        switch (opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return "+";
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return "-";
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return "*";
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return "/";
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return "%";
            }
        }
        throw new RuntimeException("Unknown opcode: " + opcode);
    }

    public static int getNextIndex(MethodNode mn) {
        Iterator it = mn.localVariables.iterator();
        int max = 0;
        int next = 0;
        while (it.hasNext()) {
            LocalVariableNode var = (LocalVariableNode)it.next();
            int index = var.index;
            if (index < max) continue;
            max = index;
            next = max + Type.getType((String)var.desc).getSize();
        }
        if (next == 0) {
            next = ReplaceArithmeticOperator.getNextIndexFromLoad(mn);
        }
        return next;
    }

    private static int getNextIndexFromLoad(MethodNode mn) {
        ListIterator it = mn.instructions.iterator();
        int index = 0;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (!(node instanceof VarInsnNode)) continue;
            VarInsnNode varNode = (VarInsnNode)node;
            int varIndex = varNode.var;
            switch (varNode.getOpcode()) {
                case 21: 
                case 23: 
                case 25: 
                case 46: 
                case 50: 
                case 51: 
                case 52: 
                case 54: 
                case 56: 
                case 58: 
                case 79: 
                case 83: 
                case 84: 
                case 85: {
                    index = Math.max(index, varIndex + 1);
                    break;
                }
                case 22: 
                case 24: 
                case 47: 
                case 49: 
                case 55: 
                case 57: 
                case 80: 
                case 82: {
                    index = Math.max(index, varIndex + 2);
                }
            }
        }
        return index;
    }

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        this.numVariable = ReplaceArithmeticOperator.getNextIndex(mn);
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        InsnNode node = (InsnNode)instruction.getASMNode();
        for (int opcode : this.getMutations(node.getOpcode())) {
            InsnNode mutation = new InsnNode(opcode);
            Mutation mutationObject = MutationPool.addMutation(className, methodName, "ReplaceArithmeticOperator " + this.getOp(node.getOpcode()) + " -> " + this.getOp(opcode), instruction, (AbstractInsnNode)mutation, this.getInfectionDistance(node.getOpcode(), opcode));
            mutations.add(mutationObject);
        }
        return mutations;
    }

    private Set<Integer> getMutations(int opcode) {
        HashSet<Integer> replacement = new HashSet<Integer>();
        if (opcodesInt.contains(opcode)) {
            replacement.addAll(opcodesInt);
        } else if (opcodesLong.contains(opcode)) {
            replacement.addAll(opcodesLong);
        } else if (opcodesFloat.contains(opcode)) {
            replacement.addAll(opcodesFloat);
        } else if (opcodesDouble.contains(opcode)) {
            replacement.addAll(opcodesDouble);
        }
        replacement.remove(opcode);
        return replacement;
    }

    public InsnList getInfectionDistance(int opcodeOrig, int opcodeNew) {
        InsnList distance = new InsnList();
        if (opcodesInt.contains(opcodeOrig)) {
            distance.add((AbstractInsnNode)new InsnNode(92));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
            distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceArithmeticOperator.class), "getInfectionDistanceInt", "(IIII)D", false));
        } else if (opcodesLong.contains(opcodeOrig)) {
            distance.add((AbstractInsnNode)new VarInsnNode(55, this.numVariable));
            distance.add((AbstractInsnNode)new InsnNode(92));
            distance.add((AbstractInsnNode)new VarInsnNode(22, this.numVariable));
            distance.add((AbstractInsnNode)new InsnNode(94));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
            distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceArithmeticOperator.class), "getInfectionDistanceLong", "(JJII)D", false));
            this.numVariable += 2;
        } else if (opcodesFloat.contains(opcodeOrig)) {
            distance.add((AbstractInsnNode)new InsnNode(92));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
            distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceArithmeticOperator.class), "getInfectionDistanceFloat", "(FFII)D", false));
        } else if (opcodesDouble.contains(opcodeOrig)) {
            distance.add((AbstractInsnNode)new VarInsnNode(57, this.numVariable));
            distance.add((AbstractInsnNode)new InsnNode(92));
            distance.add((AbstractInsnNode)new VarInsnNode(24, this.numVariable));
            distance.add((AbstractInsnNode)new InsnNode(94));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
            distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
            distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceArithmeticOperator.class), "getInfectionDistanceDouble", "(DDII)D", false));
            this.numVariable += 2;
        }
        return distance;
    }

    private static boolean hasDivZeroError(int opcode) {
        switch (opcode) {
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    public static double getInfectionDistanceInt(int x, int y, int opcodeOrig, int opcodeNew) {
        int newValue;
        if (y == 0) {
            return ReplaceArithmeticOperator.hasDivZeroError(opcodeOrig) == ReplaceArithmeticOperator.hasDivZeroError(opcodeNew) ? 1.0 : 0.0;
        }
        int origValue = ReplaceArithmeticOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceArithmeticOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static double getInfectionDistanceLong(long x, long y, int opcodeOrig, int opcodeNew) {
        long newValue;
        if (y == 0L) {
            return ReplaceArithmeticOperator.hasDivZeroError(opcodeOrig) == ReplaceArithmeticOperator.hasDivZeroError(opcodeNew) ? 1.0 : 0.0;
        }
        long origValue = ReplaceArithmeticOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceArithmeticOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static double getInfectionDistanceFloat(float x, float y, int opcodeOrig, int opcodeNew) {
        float newValue;
        if (y == 0.0f) {
            return ReplaceArithmeticOperator.hasDivZeroError(opcodeOrig) == ReplaceArithmeticOperator.hasDivZeroError(opcodeNew) ? 1.0 : 0.0;
        }
        float origValue = ReplaceArithmeticOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceArithmeticOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static double getInfectionDistanceDouble(double x, double y, int opcodeOrig, int opcodeNew) {
        double newValue;
        if (y == 0.0) {
            return ReplaceArithmeticOperator.hasDivZeroError(opcodeOrig) == ReplaceArithmeticOperator.hasDivZeroError(opcodeNew) ? 1.0 : 0.0;
        }
        double origValue = ReplaceArithmeticOperator.calculate(x, y, opcodeOrig);
        return origValue == (newValue = ReplaceArithmeticOperator.calculate(x, y, opcodeNew)) ? 1.0 : 0.0;
    }

    public static int calculate(int x, int y, int opcode) {
        switch (opcode) {
            case 96: {
                return x + y;
            }
            case 100: {
                return x - y;
            }
            case 104: {
                return x * y;
            }
            case 108: {
                return x / y;
            }
            case 112: {
                return x % y;
            }
        }
        throw new RuntimeException("Unknown integer opcode: " + opcode);
    }

    public static long calculate(long x, long y, int opcode) {
        switch (opcode) {
            case 97: {
                return x + y;
            }
            case 101: {
                return x - y;
            }
            case 105: {
                return x * y;
            }
            case 109: {
                return x / y;
            }
            case 113: {
                return x % y;
            }
        }
        throw new RuntimeException("Unknown integer opcode: " + opcode);
    }

    public static float calculate(float x, float y, int opcode) {
        switch (opcode) {
            case 98: {
                return x + y;
            }
            case 102: {
                return x - y;
            }
            case 106: {
                return x * y;
            }
            case 110: {
                return x / y;
            }
            case 114: {
                return x % y;
            }
        }
        throw new RuntimeException("Unknown integer opcode: " + opcode);
    }

    public static double calculate(double x, double y, int opcode) {
        switch (opcode) {
            case 99: {
                return x + y;
            }
            case 103: {
                return x - y;
            }
            case 107: {
                return x * y;
            }
            case 111: {
                return x / y;
            }
            case 115: {
                return x % y;
            }
        }
        throw new RuntimeException("Unknown integer opcode: " + opcode);
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        AbstractInsnNode node = instruction.getASMNode();
        int opcode = node.getOpcode();
        if (opcodesInt.contains(opcode)) {
            return true;
        }
        if (opcodesLong.contains(opcode)) {
            return true;
        }
        if (opcodesFloat.contains(opcode)) {
            return true;
        }
        return opcodesDouble.contains(opcode);
    }

    static {
        opcodesInt.addAll(Arrays.asList(96, 100, 104, 108, 112));
        opcodesLong.addAll(Arrays.asList(97, 101, 105, 109, 113));
        opcodesFloat.addAll(Arrays.asList(98, 102, 106, 110, 114));
        opcodesDouble.addAll(Arrays.asList(99, 103, 107, 111, 115));
    }
}

