/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability.transformer;

import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.testability.BooleanHelper;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.DescriptorMapping;
import org.evosuite.instrumentation.testability.transformer.MethodNodeTransformer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class BooleanCallsTransformer
extends MethodNodeTransformer {
    private final BooleanTestabilityTransformation booleanTestabilityTransformation;

    public BooleanCallsTransformer(BooleanTestabilityTransformation booleanTestabilityTransformation) {
        this.booleanTestabilityTransformation = booleanTestabilityTransformation;
    }

    @Override
    protected AbstractInsnNode transformMethodInsnNode(MethodNode mn, MethodInsnNode methodNode) {
        if (methodNode.owner.equals(Type.getInternalName(BooleanHelper.class))) {
            return methodNode;
        }
        methodNode.desc = this.booleanTestabilityTransformation.transformMethodDescriptor(methodNode.owner, methodNode.name, methodNode.desc);
        methodNode.name = DescriptorMapping.getInstance().getMethodName(methodNode.owner, methodNode.name, methodNode.desc);
        if (DescriptorMapping.getInstance().isBooleanMethod(methodNode.desc)) {
            BooleanTestabilityTransformation.logger.info("Method needs value transformation: " + methodNode.name);
            if (DescriptorMapping.getInstance().hasBooleanParameters(methodNode.desc)) {
                BooleanTestabilityTransformation.logger.info("Method needs parameter transformation: " + methodNode.name);
                TransformationStatistics.transformBackToBooleanParameter();
                int firstBooleanParameterIndex = -1;
                Type[] types = Type.getArgumentTypes((String)methodNode.desc);
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].getDescriptor().equals("Z") || firstBooleanParameterIndex != -1) continue;
                    firstBooleanParameterIndex = i;
                    break;
                }
                if (firstBooleanParameterIndex != -1) {
                    int numOfPushs = types.length - 1 - firstBooleanParameterIndex;
                    if (numOfPushs == 0) {
                        if (methodNode.getPrevious().getOpcode() != 4 && methodNode.getPrevious().getOpcode() != 3) {
                            MethodInsnNode booleanHelperInvoke = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intToBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
                            mn.instructions.insertBefore((AbstractInsnNode)methodNode, (AbstractInsnNode)booleanHelperInvoke);
                        }
                    } else {
                        int i;
                        InsnList insnlist = new InsnList();
                        for (i = 0; i < numOfPushs; ++i) {
                            MethodInsnNode booleanHelperPushParameter = types[types.length - 1 - i] == Type.BOOLEAN_TYPE || types[types.length - 1 - i] == Type.CHAR_TYPE || types[types.length - 1 - i] == Type.BYTE_TYPE || types[types.length - 1 - i] == Type.SHORT_TYPE || types[types.length - 1 - i] == Type.INT_TYPE || types[types.length - 1 - i] == Type.FLOAT_TYPE || types[types.length - 1 - i] == Type.LONG_TYPE || types[types.length - 1 - i] == Type.DOUBLE_TYPE ? (types[types.length - 1 - i] == Type.BOOLEAN_TYPE ? new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})) : new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{types[types.length - 1 - i]}))) : new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}));
                            insnlist.add((AbstractInsnNode)booleanHelperPushParameter);
                        }
                        for (i = firstBooleanParameterIndex; i < types.length; ++i) {
                            MethodInsnNode booleanHelperPopParameter;
                            if (i == firstBooleanParameterIndex) {
                                MethodInsnNode booleanHelperInvoke = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intToBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
                                insnlist.add((AbstractInsnNode)booleanHelperInvoke);
                                continue;
                            }
                            boolean objectNeedCast = false;
                            if (types[i] == Type.BOOLEAN_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterBooleanFromInt", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.CHAR_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterChar", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.BYTE_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterByte", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.SHORT_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterShort", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.INT_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterInt", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.FLOAT_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterFloat", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.LONG_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterLong", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else if (types[i] == Type.DOUBLE_TYPE) {
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterDouble", Type.getMethodDescriptor((Type)types[i], (Type[])new Type[0]));
                            } else {
                                objectNeedCast = true;
                                booleanHelperPopParameter = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterObject", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]));
                            }
                            insnlist.add((AbstractInsnNode)booleanHelperPopParameter);
                            if (!objectNeedCast) continue;
                            TypeInsnNode tin = new TypeInsnNode(192, types[i].getInternalName());
                            insnlist.add((AbstractInsnNode)tin);
                        }
                        mn.instructions.insertBefore((AbstractInsnNode)methodNode, insnlist);
                    }
                }
            }
            if (Type.getReturnType((String)methodNode.desc).equals((Object)Type.BOOLEAN_TYPE)) {
                BooleanTestabilityTransformation.logger.info("Method needs return transformation: " + methodNode.name);
                TransformationStatistics.transformBackToBooleanParameter();
                MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "booleanToInt", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}));
                mn.instructions.insert((AbstractInsnNode)methodNode, (AbstractInsnNode)n);
                return n;
            }
        } else {
            BooleanTestabilityTransformation.logger.info("Method needs no transformation: " + methodNode.name);
        }
        return methodNode;
    }

    @Override
    protected AbstractInsnNode transformFieldInsnNode(MethodNode mn, FieldInsnNode fieldNode) {
        fieldNode.desc = this.booleanTestabilityTransformation.transformFieldDescriptor(fieldNode.owner, fieldNode.name, fieldNode.desc);
        if (Type.getType((String)fieldNode.desc).equals((Object)Type.BOOLEAN_TYPE)) {
            if (fieldNode.getOpcode() == 181 || fieldNode.getOpcode() == 179) {
                MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intToBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
                TransformationStatistics.transformBackToBooleanField();
                mn.instructions.insertBefore((AbstractInsnNode)fieldNode, (AbstractInsnNode)n);
            } else {
                MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "booleanToInt", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}));
                mn.instructions.insert((AbstractInsnNode)fieldNode, (AbstractInsnNode)n);
                TransformationStatistics.transformBackToBooleanField();
                return n;
            }
        }
        return fieldNode;
    }
}

