/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.List;
import org.evosuite.junit.JUnitFailure;
import org.evosuite.junit.JUnitResult;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class JUnitResultBuilder {
    public JUnitResult build(Result result) {
        boolean wasSuccessful = result.wasSuccessful();
        int failureCount = result.getFailureCount();
        int runCount = result.getRunCount();
        JUnitResult junitResult = new JUnitResult(wasSuccessful, failureCount, runCount);
        List failures = result.getFailures();
        for (Failure failure : failures) {
            String descriptionMethodName = failure.getDescription().getMethodName();
            String exceptionClassName = failure.getException().getClass().toString();
            String message = failure.getMessage();
            String trace = failure.getTrace();
            boolean isAssertionError = failure.getException() instanceof AssertionError;
            JUnitFailure junitFailure = new JUnitFailure(message, exceptionClassName, descriptionMethodName, isAssertionError, trace);
            for (StackTraceElement elem : failure.getException().getStackTrace()) {
                String elemToString = elem.toString();
                junitFailure.addToExceptionStackTrace(elemToString);
            }
            junitResult.addFailure(junitFailure);
        }
        return junitResult;
    }
}

