/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.rules;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DebugGraphics;
import org.evosuite.Properties;
import org.evosuite.junit.rules.BaseRule;
import org.evosuite.runtime.Runtime;

public class Stubbing
extends BaseRule {
    private Map<String, String> propertiesToSet = new HashMap<String, String>();
    private Set<String> propertiesToClear = new LinkedHashSet<String>();
    private static final java.util.Properties defaultProperties = (java.util.Properties)System.getProperties().clone();
    private PrintStream systemOut = null;
    private PrintStream systemErr = null;
    private PrintStream logStream = null;

    public Stubbing() {
        Properties.REPLACE_CALLS = true;
        this.initProperties();
    }

    public void initProperties() {
    }

    public void setProperty(String key, String value) {
        this.propertiesToSet.put(key, value);
    }

    public void clearProperty(String key) {
        this.propertiesToClear.add(key);
    }

    @Override
    protected void before() {
        Runtime.getInstance().resetRuntime();
        this.systemErr = System.err;
        this.systemOut = System.out;
        this.logStream = DebugGraphics.logStream();
        for (String key : this.propertiesToSet.keySet()) {
            System.setProperties((java.util.Properties)defaultProperties.clone());
            System.setProperty(key, this.propertiesToSet.get(key));
        }
        for (String key : this.propertiesToClear) {
            System.clearProperty(key);
        }
    }

    @Override
    protected void after() {
        System.setErr(this.systemErr);
        System.setOut(this.systemOut);
        DebugGraphics.setLogStream(this.logStream);
        System.setProperties((java.util.Properties)defaultProperties.clone());
    }
}

