/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.novelty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class NoveltyFitnessEvaluationListener
implements SearchListener {
    private List<TestSuiteFitnessFunction> fitnessFunctions;

    public NoveltyFitnessEvaluationListener(List<TestSuiteFitnessFunction> fitnessFunctions) {
        this.fitnessFunctions = new ArrayList<TestSuiteFitnessFunction>(fitnessFunctions);
    }

    public TestSuiteChromosome createMergedSolution(Collection<TestChromosome> population) {
        TestSuiteChromosome suite = new TestSuiteChromosome();
        suite.addTests(population);
        return suite;
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        List<TestChromosome> population = algorithm.getPopulation();
        TestSuiteChromosome suite = this.createMergedSolution(population);
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(suite);
        }
        algorithm.updateFitnessFunctionsAndValues();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

