/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.parameterize;

import java.lang.reflect.Type;
import java.util.Map;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.objectweb.asm.commons.GeneratorAdapter;

public class InputVariable
implements VariableReference {
    private static final long serialVersionUID = -5552253395284020019L;
    private int numInput = 0;
    private String originalCode;
    protected GenericClass type;

    public InputVariable(Type clazz, int num) {
        this.numInput = num;
        this.type = new GenericClass(clazz);
    }

    @Override
    public int getStPosition() {
        return 0;
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public void setDistance(int distance) {
    }

    @Override
    public VariableReference clone(TestCase newTest) {
        return this.copy(newTest, 0);
    }

    @Override
    public VariableReference clone() {
        throw new UnsupportedOperationException("This method SHOULD not be used, as only the original reference is keeped up to date");
    }

    @Override
    public VariableReference copy(TestCase newTest, int offset) {
        return newTest.getStatement(this.getStPosition() + offset).getReturnValue();
    }

    @Override
    public String getClassName() {
        return this.type.getClassName();
    }

    @Override
    public String getComponentName() {
        return this.type.getComponentName();
    }

    @Override
    public Type getComponentType() {
        return this.type.getComponentType();
    }

    @Override
    public boolean isAccessible() {
        return TestUsageChecker.canUse(this.type.getRawClass());
    }

    @Override
    public boolean isArray() {
        return this.type.isArray();
    }

    @Override
    public boolean isArrayIndex() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public boolean isVoid() {
        return this.type.isVoid();
    }

    @Override
    public boolean isString() {
        return this.type.isString();
    }

    @Override
    public boolean isWrapperType() {
        return this.type.isWrapperType();
    }

    @Override
    public boolean isAssignableFrom(Type other) {
        return this.type.isAssignableFrom(other);
    }

    @Override
    public boolean isAssignableTo(Type other) {
        return this.type.isAssignableTo(other);
    }

    @Override
    public boolean isAssignableFrom(VariableReference other) {
        return this.type.isAssignableFrom(other.getType());
    }

    @Override
    public boolean isAssignableTo(VariableReference other) {
        return this.type.isAssignableTo(other.getType());
    }

    @Override
    public Type getType() {
        return this.type.getType();
    }

    @Override
    public void setType(Type type) {
        this.type = new GenericClass(type);
    }

    @Override
    public Class<?> getVariableClass() {
        return this.type.getRawClass();
    }

    @Override
    public Class<?> getComponentClass() {
        return this.type.getRawClass().getComponentType();
    }

    @Override
    public String getSimpleClassName() {
        if (this.type.isPrimitive() || this.type.isArray() && new GenericClass(this.type.getComponentType()).isPrimitive()) {
            return this.type.getRawClass().getSimpleName();
        }
        return this.type.getSimpleName();
    }

    @Override
    public GenericClass getGenericClass() {
        return this.type;
    }

    @Override
    public Object getObject(Scope scope) throws CodeUnderTestException {
        return scope.getObject(this);
    }

    @Override
    public void setObject(Scope scope, Object value) throws CodeUnderTestException {
        scope.setObject(this, value);
    }

    @Override
    public String getName() {
        return "input" + this.numInput;
    }

    @Override
    public VariableReference getAdditionalVariableReference() {
        return null;
    }

    @Override
    public void setAdditionalVariableReference(VariableReference var) {
    }

    @Override
    public void replaceAdditionalVariableReference(VariableReference var1, VariableReference var2) {
    }

    @Override
    public void loadBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
    }

    @Override
    public void storeBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public String getDefaultValueString() {
        return null;
    }

    @Override
    public int compareTo(VariableReference other) {
        return 0;
    }

    @Override
    public boolean same(VariableReference r) {
        return false;
    }

    @Override
    public String getOriginalCode() {
        return this.originalCode;
    }

    @Override
    public void setOriginalCode(String originalCode) {
        this.originalCode = originalCode;
    }

    @Override
    public TestCase getTestCase() {
        return this.getTestCase();
    }

    @Override
    public boolean isFieldReference() {
        return false;
    }
}

