/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi.service;

import org.evosuite.Properties;

public enum ClientState {
    NOT_STARTED("Not started", "EvoSuite has not started client process", 0),
    STARTED("Started", "Client process has been launched", 1),
    INITIALIZATION("Initializing", "Analyzing classpath and dependencies", 2),
    CARVING("Carving", "Carving JUnit tests", 3),
    SEARCH("Search", "Generating test cases", 4),
    INLINING("Inlining", "Inlining constants", 5),
    MINIMIZING_VALUES("Minimizing values", "Minimizing primitive values in the tests", 6),
    MINIMIZATION("Minimizing", "Minimizing size/length of test cases", 7),
    COVERAGE_ANALYSIS("Coverage Analysis", "Compute and the different coverage criteria of the generated test suite", 8),
    ASSERTION_GENERATION("Generating assertions", "Adding assertions to the test cases", 9),
    JUNIT_CHECK("Check JUnit", "Validate and fix the generated tests", 10),
    WRITING_TESTS("JUnit", "Writing JUnit tests to disk", 11),
    WRITING_STATISTICS("Statistics", "Writing statistics to disk", 12),
    DONE("Done", "Test case generation is finished", 13),
    FINISHED("Finished", "Client process is fully finished", 14);

    private String name;
    private String description;
    private int numPhase = 0;
    private int progress = 0;
    private int startProgress = 0;
    private int maxProgress = 0;

    private ClientState(String name, String description, int numPhase) {
        this.name = name;
        this.description = description;
        this.numPhase = numPhase;
        this.setProgressBoundaries(numPhase);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumPhase() {
        return this.numPhase;
    }

    public int getOverallProgress() {
        return this.progress;
    }

    public int getStartProgress() {
        return this.startProgress;
    }

    public int getEndProgress() {
        return this.maxProgress;
    }

    public int getPhaseProgress() {
        int divisor = this.maxProgress - this.startProgress;
        if (divisor == 0) {
            return 0;
        }
        return (this.progress - this.startProgress) / divisor;
    }

    public void setProgressOfPhase(float progress) {
        this.progress = this.startProgress + (int)((float)(this.maxProgress - this.startProgress) * progress);
    }

    private void setProgressBoundaries(int numPhase) {
        switch (numPhase) {
            case 1: {
                this.progress = 1;
                this.startProgress = 1;
                this.maxProgress = 1;
                break;
            }
            case 2: {
                this.progress = 2;
                this.startProgress = 2;
                this.maxProgress = 9;
                break;
            }
            case 3: {
                this.progress = 5;
                this.startProgress = 5;
                this.maxProgress = 9;
                break;
            }
            case 4: {
                this.progress = 10;
                this.startProgress = 10;
                if (Properties.ASSERTIONS) {
                    this.maxProgress = 33;
                    break;
                }
                this.maxProgress = 66;
                break;
            }
            case 5: {
                this.startProgress = Properties.ASSERTIONS ? 33 : 66;
                this.maxProgress = this.startProgress + 5;
                this.progress = this.startProgress;
                break;
            }
            case 6: {
                this.startProgress = Properties.ASSERTIONS ? (Properties.INLINE ? 38 : 33) : (Properties.INLINE ? 71 : 66);
                this.maxProgress = this.startProgress + 5;
                this.progress = this.startProgress;
                break;
            }
            case 7: {
                if (Properties.ASSERTIONS) {
                    this.startProgress = Properties.INLINE ? 38 : 33;
                    this.maxProgress = 66;
                } else {
                    this.startProgress = Properties.INLINE ? 71 : 66;
                    this.maxProgress = 93;
                }
                if (Properties.MINIMIZE_VALUES) {
                    this.startProgress += 5;
                }
                this.progress = this.startProgress;
                break;
            }
            case 8: {
                this.startProgress = 67;
                this.maxProgress = 75;
                this.progress = this.startProgress;
                break;
            }
            case 9: {
                this.startProgress = 76;
                this.maxProgress = 92;
                this.progress = this.startProgress;
                break;
            }
            case 10: {
                this.startProgress = 93;
                this.maxProgress = 94;
                this.progress = this.startProgress;
                break;
            }
            case 11: {
                this.startProgress = 95;
                this.maxProgress = 98;
                this.progress = this.startProgress;
                break;
            }
            case 12: {
                this.startProgress = 99;
                this.maxProgress = 100;
                this.progress = this.startProgress;
                break;
            }
            default: {
                this.startProgress = 100;
                this.maxProgress = 100;
                this.progress = 100;
            }
        }
    }
}

