/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectParameterTypesVisitor
extends SignatureVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CollectParameterTypesVisitor.class);
    private final Set<Type> classes = new LinkedHashSet<Type>();
    private final String className;
    private boolean topLevel = true;

    public Set<Type> getClasses() {
        return this.classes;
    }

    public CollectParameterTypesVisitor(String className) {
        super(327680);
        this.className = className;
        logger.debug("Target class name: " + className);
    }

    public void visitFormalTypeParameter(String name) {
        logger.debug("  visitFormalTypeParameter(" + name + ")");
    }

    public SignatureVisitor visitClassBound() {
        logger.debug("  visitClassBound()");
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        logger.debug("  visitInterfaceBound()");
        this.topLevel = false;
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        logger.debug("  visitSuperclass()");
        this.topLevel = true;
        return this;
    }

    public SignatureVisitor visitInterface() {
        logger.debug("  visitInterface()");
        this.topLevel = true;
        return this;
    }

    public SignatureVisitor visitParameterType() {
        logger.debug("  visitParameterType()");
        this.topLevel = true;
        return this;
    }

    public void visitClassType(String name) {
        logger.debug("  visitClassType(" + name + ")");
        if (this.topLevel) {
            this.topLevel = false;
        } else if (!name.equals(this.className)) {
            this.classes.add(Type.getObjectType((String)name));
        }
        super.visitClassType(name);
    }

    public void visitTypeVariable(String name) {
        logger.debug("  visitTypeVariable(" + name + ")");
        super.visitTypeVariable(name);
    }

    public void visitTypeArgument() {
        logger.debug("  visitTypeArgument");
        super.visitTypeArgument();
    }

    public SignatureVisitor visitReturnType() {
        logger.debug("  visitReturnType");
        this.topLevel = true;
        return super.visitReturnType();
    }
}

