/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.seeding.PrimitivePoolMethodAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PrimitiveClassAdapter
extends ClassVisitor {
    private final String className;
    private final ConstantPoolManager poolManager = ConstantPoolManager.getInstance();
    private boolean isEnum = false;

    public PrimitiveClassAdapter(ClassVisitor visitor, String className) {
        super(327680, visitor);
        this.className = className.replaceAll("/", ".");
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (superName.equals("java/lang/Enum")) {
            this.isEnum = true;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!"serialVersionUID".equals(name)) {
            if (DependencyAnalysis.isTargetClassName(this.className)) {
                this.poolManager.addSUTConstant(value);
                this.poolManager.addSUTConstant(Type.getType((String)desc));
            } else {
                this.poolManager.addNonSUTConstant(value);
            }
            if (this.isEnum && (access & 0x10) == 16 && (access & 8) == 8) {
                if (DependencyAnalysis.isTargetClassName(this.className)) {
                    this.poolManager.addSUTConstant(name);
                } else {
                    this.poolManager.addNonSUTConstant(name);
                }
            }
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        if (DependencyAnalysis.isTargetClassName(this.className)) {
            for (Type argumentType : Type.getArgumentTypes((String)descriptor)) {
                this.poolManager.addSUTConstant(argumentType);
            }
        }
        mv = new PrimitivePoolMethodAdapter(mv, this.className);
        return mv;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 1) == 1 && DependencyAnalysis.isTargetClassName(this.className)) {
            Type type = Type.getObjectType((String)name);
            this.poolManager.addSUTConstant(type);
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }
}

