/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.FrequencyBasedPool;
import org.evosuite.utils.LoggingUtils;
import org.objectweb.asm.Type;

public class StaticConstantVariableProbabilityPool
implements ConstantPool {
    private final FrequencyBasedPool<String> stringPool = new FrequencyBasedPool();
    private final FrequencyBasedPool<Type> typePool = new FrequencyBasedPool();
    private final FrequencyBasedPool<Integer> intPool = new FrequencyBasedPool();
    private final FrequencyBasedPool<Double> doublePool = new FrequencyBasedPool();
    private final FrequencyBasedPool<Long> longPool = new FrequencyBasedPool();
    private final FrequencyBasedPool<Float> floatPool = new FrequencyBasedPool();

    public StaticConstantVariableProbabilityPool() {
        this.stringPool.addConstant("");
        if (Properties.TARGET_CLASS != null && !Properties.TARGET_CLASS.isEmpty()) {
            this.typePool.addConstant(Type.getObjectType((String)Properties.TARGET_CLASS));
        } else {
            this.typePool.addConstant(Type.getType(Object.class));
        }
        this.intPool.addConstant(0);
        this.intPool.addConstant(1);
        this.intPool.addConstant(-1);
        this.longPool.addConstant(0L);
        this.longPool.addConstant(1L);
        this.longPool.addConstant(-1L);
        this.floatPool.addConstant(Float.valueOf(0.0f));
        this.floatPool.addConstant(Float.valueOf(1.0f));
        this.floatPool.addConstant(Float.valueOf(-1.0f));
        this.doublePool.addConstant(0.0);
        this.doublePool.addConstant(1.0);
        this.doublePool.addConstant(-1.0);
    }

    @Override
    public String getRandomString() {
        return this.stringPool.getRandomConstant();
    }

    @Override
    public Type getRandomType() {
        return this.typePool.getRandomConstant();
    }

    @Override
    public int getRandomInt() {
        return this.intPool.getRandomConstant();
    }

    @Override
    public float getRandomFloat() {
        return this.floatPool.getRandomConstant().floatValue();
    }

    @Override
    public double getRandomDouble() {
        return this.doublePool.getRandomConstant();
    }

    @Override
    public long getRandomLong() {
        return this.longPool.getRandomConstant();
    }

    @Override
    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > Properties.MAX_STRING) {
                return;
            }
            if (string.length() > 65535) {
                return;
            }
            this.stringPool.addConstant(string);
        } else if (object instanceof Type) {
            while (((Type)object).getSort() == 9) {
                object = ((Type)object).getElementType();
            }
            this.typePool.addConstant((Type)object);
        } else if (object instanceof Integer) {
            if (Properties.RESTRICT_POOL) {
                int val = (Integer)object;
                if (Math.abs(val) < Properties.MAX_INT) {
                    this.intPool.addConstant((Integer)object);
                }
            } else {
                this.intPool.addConstant((Integer)object);
            }
        } else if (object instanceof Long) {
            if (Properties.RESTRICT_POOL) {
                long val = (Long)object;
                if (Math.abs(val) < (long)Properties.MAX_INT) {
                    this.longPool.addConstant((Long)object);
                }
            } else {
                this.longPool.addConstant((Long)object);
            }
        } else if (object instanceof Float) {
            if (Properties.RESTRICT_POOL) {
                float val = ((Float)object).floatValue();
                if (Math.abs(val) < (float)Properties.MAX_INT) {
                    this.floatPool.addConstant((Float)object);
                }
            } else {
                this.floatPool.addConstant((Float)object);
            }
        } else if (object instanceof Double) {
            if (Properties.RESTRICT_POOL) {
                double val = (Double)object;
                if (Math.abs(val) < (double)Properties.MAX_INT) {
                    this.doublePool.addConstant((Double)object);
                }
            } else {
                this.doublePool.addConstant((Double)object);
            }
        } else {
            LoggingUtils.getEvoLogger().info("Constant of unknown type: " + object.getClass());
        }
    }
}

