/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding.factories;

import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class RandomIndividualTestSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = 1L;
    private final ChromosomeFactory<TestSuiteChromosome> defaultFactory;
    private final GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm;

    public RandomIndividualTestSuiteChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> defaultFactory, GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm) {
        this.defaultFactory = defaultFactory;
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        if (this.geneticAlgorithm != null && Randomness.nextDouble() < Properties.SEED_PROBABILITY) {
            int populationSize = this.geneticAlgorithm.getPopulation().size();
            TestSuiteChromosome ri = this.geneticAlgorithm.getPopulation().get(Randomness.nextInt(populationSize));
            if (ri != null) {
                return ri;
            }
        }
        return this.defaultFactory.getChromosome();
    }
}

