/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.PrivateAccess;
import org.evosuite.runtime.classhandling.ModifiedTargetStaticFields;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.seeding.CastClassAnalyzer;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.setup.ConcreteClassAnalyzer;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.DependencyPair;
import org.evosuite.setup.GetStaticGraph;
import org.evosuite.setup.GetStaticGraphGenerator;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.PutStaticMethodCollector;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericField;
import org.evosuite.utils.generic.GenericMethod;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClusterGenerator {
    private static Logger logger = LoggerFactory.getLogger(TestClusterGenerator.class);
    private final Set<GenericAccessibleObject<?>> dependencyCache = new LinkedHashSet();
    private final Set<GenericClass> genericCastClasses = new LinkedHashSet<GenericClass>();
    private final Set<Class<?>> concreteCastClasses = new LinkedHashSet();
    private final Set<Class<?>> containerClasses = new LinkedHashSet();
    private final Set<DependencyPair> dependencies = new LinkedHashSet<DependencyPair>();
    private final Set<GenericClass> analyzedAbstractClasses = new LinkedHashSet<GenericClass>();
    private final Set<Class<?>> analyzedClasses = new LinkedHashSet();
    private final InheritanceTree inheritanceTree;

    public TestClusterGenerator(InheritanceTree tree) {
        this.inheritanceTree = tree;
    }

    public void generateCluster(CallGraph callGraph) throws RuntimeException, ClassNotFoundException {
        TestCluster.setInheritanceTree(this.inheritanceTree);
        if (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE)) {
            for (String callTreeClass : callGraph.getClasses()) {
                try {
                    if (!callGraph.isCalledClass(callTreeClass) || !Properties.INSTRUMENT_LIBRARIES && !DependencyAnalysis.isTargetProject(callTreeClass)) continue;
                    TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(callTreeClass);
                }
                catch (ClassNotFoundException e) {
                    logger.info("Class not found: " + callTreeClass + ": " + e);
                }
            }
        }
        this.dependencyCache.clear();
        LinkedHashSet<String> blackList = new LinkedHashSet<String>();
        this.initBlackListWithEvoSuitePrimitives(blackList);
        logger.info("Handling cast classes");
        this.handleCastClasses();
        logger.info("Initialising target class");
        this.initializeTargetMethods();
        logger.info("Resolving dependencies");
        this.resolveDependencies(blackList);
        this.handleSpecialCases();
        if (Properties.JEE) {
            this.addInjectionDependencies(blackList);
        }
        logger.info("Removing unusable generators");
        TestCluster.getInstance().removeUnusableGenerators();
        if (logger.isDebugEnabled()) {
            logger.debug(TestCluster.getInstance().toString());
        }
        this.gatherStatistics();
    }

    public void addNewDependencies(Collection<Class<?>> rawTypes) {
        Inputs.checkNull((Object[])new Object[]{rawTypes});
        LinkedHashSet<String> blackList = new LinkedHashSet<String>();
        this.initBlackListWithEvoSuitePrimitives(blackList);
        rawTypes.stream().forEach(c -> this.dependencies.add(new DependencyPair(0, new GenericClass((Class<?>)c).getRawClass())));
        this.resolveDependencies(blackList);
    }

    private void addInjectionDependencies(Set<String> blackList) {
        LinkedHashSet toAdd = new LinkedHashSet();
        try {
            this.analyzedClasses.stream().flatMap(c -> Injector.getAllFieldsToInject((Class)c).stream()).map(f -> f.getType()).forEach(t -> this.addInjectionRecursively((Class<?>)t, toAdd, blackList));
        }
        catch (Throwable t2) {
            logger.warn("Error during initialisation of injection dependencies: " + t2 + ", continuing anyway.");
        }
        toAdd.stream().forEach(c -> this.dependencies.add(new DependencyPair(0, new GenericClass((Class<?>)c).getRawClass())));
        this.resolveDependencies(blackList);
    }

    private void addInjectionRecursively(Class<?> target, Set<Class<?>> toAdd, Set<String> blackList) {
        if (toAdd.contains(target) || blackList.contains(target.getName())) {
            return;
        }
        toAdd.add(target);
        for (Field f : Injector.getAllFieldsToInject(target)) {
            this.addInjectionRecursively(f.getType(), toAdd, blackList);
        }
    }

    private void handleSpecialCases() {
        if (Properties.P_REFLECTION_ON_PRIVATE > 0.0 && Properties.REFLECTION_START_PERCENT < 1.0) {
            Class<?> target = Properties.getTargetClassAndDontInitialise();
            Constructor<?> constructor = null;
            try {
                constructor = target.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null && Modifier.isPrivate(constructor.getModifiers()) && target.getDeclaredConstructors().length == 1 && !target.isEnum()) {
                Method m = null;
                try {
                    m = PrivateAccess.class.getDeclaredMethod("callDefaultConstructorOfTheClassUnderTest", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    logger.error("Missing method: " + e.toString());
                    return;
                }
                GenericMethod gm = new GenericMethod(m, PrivateAccess.class);
                TestCluster.getInstance().addEnvironmentTestCall(gm);
            }
        }
    }

    private void handleCastClasses() {
        if (Properties.SEED_TYPES) {
            LinkedHashSet<String> blackList = new LinkedHashSet<String>();
            this.initBlackListWithPrimitives(blackList);
            LinkedHashSet<String> classNames = new LinkedHashSet<String>();
            CastClassAnalyzer analyzer = new CastClassAnalyzer();
            Map<org.objectweb.asm.Type, Integer> castMap = analyzer.analyze(Properties.TARGET_CLASS);
            for (Map.Entry<org.objectweb.asm.Type, Integer> castEntry : castMap.entrySet()) {
                String className = castEntry.getKey().getClassName();
                if (blackList.contains(className) || !this.addCastClassDependencyIfAccessible(className, blackList)) continue;
                CastClassManager.getInstance().addCastClass(className, (int)castEntry.getValue());
                classNames.add(castEntry.getKey().getClassName());
            }
            logger.debug("Cast classes used: " + classNames);
        }
    }

    private void gatherStatistics() {
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Analyzed_Classes, this.analyzedClasses.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Generators, TestCluster.getInstance().getGenerators().size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Modifiers, TestCluster.getInstance().getModifiers().size());
    }

    private void initBlackListWithEvoSuitePrimitives(Set<String> blackList) throws NullPointerException {
        blackList.add("int");
        blackList.add("short");
        blackList.add("float");
        blackList.add("double");
        blackList.add("byte");
        blackList.add("char");
        blackList.add("boolean");
        blackList.add("long");
        blackList.add(Enum.class.getName());
        blackList.add(String.class.getName());
        blackList.add(Class.class.getName());
        blackList.add(ThreadGroup.class.getName());
    }

    private void initBlackListWithPrimitives(Set<String> blackList) throws NullPointerException {
        blackList.add("int");
        blackList.add("short");
        blackList.add("float");
        blackList.add("double");
        blackList.add("byte");
        blackList.add("char");
        blackList.add("boolean");
        blackList.add("long");
    }

    private boolean addCastClassDependencyIfAccessible(String className, Set<String> blackList) {
        if (className.equals(String.class.getName())) {
            return true;
        }
        if (blackList.contains(className)) {
            logger.info("Cast class in blacklist: " + className);
            return false;
        }
        try {
            Class<?> clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(className);
            if (!TestUsageChecker.canUse(clazz)) {
                logger.debug("Cannot use cast class: " + className);
                return false;
            }
            this.addDependency(new GenericClass(clazz), 1);
            this.genericCastClasses.add(new GenericClass(clazz));
            this.concreteCastClasses.add(clazz);
            blackList.add(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found", (Throwable)e);
            blackList.add(className);
            return false;
        }
    }

    private void resolveDependencies(Set<String> blackList) {
        while (!this.dependencies.isEmpty() && TimeController.getInstance().isThereStillTimeInThisPhase()) {
            String className;
            logger.debug("Dependencies left: {}", (Object)this.dependencies.size());
            Iterator<DependencyPair> iterator = this.dependencies.iterator();
            DependencyPair dependency = iterator.next();
            iterator.remove();
            if (this.analyzedClasses.contains(dependency.getDependencyClass().getRawClass()) || blackList.contains(className = dependency.getDependencyClass().getClassName())) continue;
            boolean added = false;
            added = this.addDependencyClass(dependency.getDependencyClass(), dependency.getRecursion());
            if (added) continue;
            blackList.add(className);
        }
    }

    private void addDeclaredClasses(Set<Class<?>> targetClasses, Class<?> currentClass) {
        for (Class<?> c : currentClass.getDeclaredClasses()) {
            logger.info("Adding declared class " + c);
            targetClasses.add(c);
            this.addDeclaredClasses(targetClasses, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTargetMethods() throws RuntimeException, ClassNotFoundException {
        logger.info("Analyzing target class");
        Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
        TestCluster cluster = TestCluster.getInstance();
        LinkedHashSet targetClasses = new LinkedHashSet();
        if (targetClass == null) {
            throw new RuntimeException("Failed to load " + Properties.TARGET_CLASS);
        }
        targetClasses.add(targetClass);
        this.addDeclaredClasses(targetClasses, targetClass);
        if (Modifier.isAbstract(targetClass.getModifiers())) {
            logger.info("SUT is an abstract class");
            Set<Class<?>> subclasses = ConcreteClassAnalyzer.getInstance().getConcreteClasses(targetClass, this.inheritanceTree);
            logger.info("Found " + subclasses.size() + " concrete subclasses");
            targetClasses.addAll(subclasses);
        }
        LinkedHashSet tmp_targetClasses = new LinkedHashSet(targetClasses);
        for (Class clazz : tmp_targetClasses) {
            ClassNode targetClassNode = DependencyAnalysis.getClassNode(clazz.getName());
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(targetClassNode.innerClasses);
            while (!linkedList.isEmpty()) {
                InnerClassNode icn = (InnerClassNode)linkedList.poll();
                try {
                    logger.debug("Loading inner class: " + icn.innerName + ", " + icn.name + "," + icn.outerName);
                    String innerClassName = ResourceList.getClassNameFromResourcePath(icn.name);
                    if (!innerClassName.startsWith(Properties.TARGET_CLASS)) {
                        logger.debug("Ignoring inner class that is outside SUT {}", (Object)innerClassName);
                        continue;
                    }
                    Class<?> innerClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(innerClassName);
                    if (targetClasses.contains(innerClass) || innerClassName.contains("Map$Entry")) continue;
                    logger.info("Adding inner class {}", (Object)innerClassName);
                    targetClasses.add(innerClass);
                    ClassNode innerClassNode = DependencyAnalysis.getClassNode(innerClassName);
                    linkedList.addAll(innerClassNode.innerClasses);
                }
                catch (Throwable t) {
                    logger.error("Problem for " + Properties.TARGET_CLASS + ". Error loading inner class: " + icn.innerName + ", " + icn.name + "," + icn.outerName + ": " + t);
                }
            }
        }
        for (Class clazz : targetClasses) {
            String orig;
            String name;
            logger.info("Current SUT class: " + clazz);
            if (!TestUsageChecker.canUse(clazz)) {
                logger.info("Cannot access SUT class: " + clazz);
                continue;
            }
            for (Constructor constructor : TestClusterUtils.getConstructors(clazz)) {
                logger.info("Checking target constructor " + constructor);
                name = "<init>" + org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getName(), "<init>", org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestUsageChecker.canUse(constructor)) {
                    GenericConstructor genericConstructor = new GenericConstructor(constructor, clazz);
                    if (constructor.getDeclaringClass().equals(clazz)) {
                        cluster.addTestCall(genericConstructor);
                    }
                    cluster.addGenerator(new GenericClass(clazz), genericConstructor);
                    this.addDependencies(genericConstructor, 1);
                    logger.debug("Keeping track of " + constructor.getDeclaringClass().getName() + "." + constructor.getName() + org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor));
                    continue;
                }
                logger.debug("Constructor cannot be used: " + constructor);
            }
            for (Method method : TestClusterUtils.getMethods(clazz)) {
                GenericMethod genericMethod;
                logger.info("Checking target method " + method);
                name = method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)method);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getName(), method.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)method)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestUsageChecker.canUse(method, clazz)) {
                    logger.debug("Adding method " + clazz.getName() + "." + method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)method));
                    genericMethod = new GenericMethod(method, clazz);
                    if (method.getDeclaringClass().equals(clazz)) {
                        cluster.addTestCall(genericMethod);
                    }
                    if (!CheapPurityAnalyzer.getInstance().isPure(method)) {
                        cluster.addModifier(new GenericClass(clazz), genericMethod);
                    }
                    this.addDependencies(genericMethod, 1);
                    GenericClass retClass = new GenericClass(method.getReturnType());
                    if (retClass.isVoid()) continue;
                    cluster.addGenerator(retClass, genericMethod);
                    continue;
                }
                logger.debug("Method cannot be used: " + method);
                if (!(Properties.P_REFLECTION_ON_PRIVATE > 0.0) || !method.getDeclaringClass().equals(clazz)) continue;
                genericMethod = new GenericMethod(method, clazz);
                this.addDependencies(genericMethod, 1);
            }
            for (Field field : TestClusterUtils.getFields(clazz)) {
                GenericField genericField;
                logger.info("Checking target field " + field);
                if (TestUsageChecker.canUse(field, clazz)) {
                    genericField = new GenericField(field, clazz);
                    this.addDependencies(genericField, 1);
                    cluster.addGenerator(new GenericClass(field.getGenericType()), genericField);
                    logger.debug("Adding field " + field);
                    boolean isFinalField = TestClusterGenerator.isFinalField(field);
                    if (!isFinalField) {
                        logger.debug("Is not final");
                        cluster.addModifier(new GenericClass(clazz), genericField);
                        continue;
                    }
                    logger.debug("Is final");
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    logger.debug("Is static non-primitive");
                    try {
                        Object o = field.get(null);
                        if (o == null) {
                            logger.info("Field is not yet initialized: " + field);
                            continue;
                        }
                        Class<?> actualClass = o.getClass();
                        logger.debug("Actual class is " + actualClass);
                        if (actualClass.isAssignableFrom(genericField.getRawGeneratedType()) || !genericField.getRawGeneratedType().isAssignableFrom(actualClass)) continue;
                        GenericField superClassField = new GenericField(field, clazz);
                        cluster.addGenerator(new GenericClass(actualClass), superClassField);
                    }
                    catch (IllegalAccessException e) {
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                logger.debug("Can't use field " + field);
                if (!(Properties.P_REFLECTION_ON_PRIVATE > 0.0) || !Modifier.isPrivate(field.getModifiers()) || field.isSynthetic() || field.getName().equals("serialVersionUID") || field.getType().isPrimitive() || Modifier.isFinal(field.getModifiers()) && field.getType().equals(String.class) || Modifier.isStatic(field.getModifiers())) continue;
                genericField = new GenericField(field, clazz);
                this.addDependencies(genericField, 1);
            }
            this.analyzedClasses.add(clazz);
            cluster.getAnalyzedClasses().add(clazz);
        }
        if (Properties.INSTRUMENT_PARENT) {
            for (String string : this.inheritanceTree.getSuperclasses(Properties.TARGET_CLASS)) {
                try {
                    Class<?> superClazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(string);
                    this.dependencies.add(new DependencyPair(0, superClazz));
                }
                catch (ClassNotFoundException e) {
                    logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found: " + string, (Throwable)e);
                }
            }
        }
        if (Properties.HANDLE_STATIC_FIELDS) {
            GetStaticGraph getStaticGraph = GetStaticGraphGenerator.generate(Properties.TARGET_CLASS);
            Map<String, Set<String>> map = getStaticGraph.getStaticFields();
            for (String string : map.keySet()) {
                Class<?> clazz;
                logger.info("Adding static fields to cluster for class " + string);
                try {
                    Sandbox.goingToExecuteUnsafeCodeOnSameThread();
                    clazz = TestClusterUtils.getClass(string);
                }
                catch (ExceptionInInitializerError ex) {
                    logger.debug("Class class init caused exception " + string);
                    continue;
                }
                finally {
                    Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                    continue;
                }
                if (clazz == null) {
                    logger.debug("Class not found " + string);
                    continue;
                }
                if (!TestUsageChecker.canUse(clazz)) continue;
                Set<String> fields = map.get(string);
                for (Field field : TestClusterUtils.getFields(clazz)) {
                    if (!TestUsageChecker.canUse(field, clazz) || !fields.contains(field.getName()) || TestClusterGenerator.isFinalField(field)) continue;
                    logger.debug("Is not final");
                    GenericField genericField = new GenericField(field, clazz);
                    cluster.addModifier(new GenericClass(Properties.getTargetClassAndDontInitialise()), genericField);
                }
            }
            PutStaticMethodCollector collector = new PutStaticMethodCollector(Properties.TARGET_CLASS, map);
            Set<PutStaticMethodCollector.MethodIdentifier> set = collector.collectMethods();
            for (PutStaticMethodCollector.MethodIdentifier methodId : set) {
                Method method;
                Class<?> clazz = TestClusterUtils.getClass(methodId.getClassName());
                if (clazz == null || !TestUsageChecker.canUse(clazz) || (method = TestClusterUtils.getMethod(clazz, methodId.getMethodName(), methodId.getDesc())) == null) continue;
                GenericMethod genericMethod = new GenericMethod(method, clazz);
                cluster.addModifier(new GenericClass(Properties.getTargetClassAndDontInitialise()), genericMethod);
            }
        }
        logger.info("Finished analyzing target class");
    }

    public static boolean isFinalField(Field field) {
        if (Properties.RESET_STATIC_FINAL_FIELDS) {
            if (Modifier.isFinal(field.getModifiers())) {
                return true;
            }
            String fieldName = field.getName();
            boolean isModifiedStaticField = ModifiedTargetStaticFields.getInstance().containsField(fieldName);
            return isModifiedStaticField;
        }
        boolean isFinalField = Modifier.isFinal(field.getModifiers());
        return isFinalField;
    }

    private void addDependencies(GenericConstructor constructor, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)constructor);
            return;
        }
        if (this.dependencyCache.contains(constructor)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + constructor);
        this.dependencyCache.add(constructor);
        for (Type parameterClass : constructor.getRawParameterTypes()) {
            logger.debug("Adding dependency " + parameterClass);
            this.addDependency(new GenericClass(parameterClass), recursionLevel);
        }
    }

    private void addDependencies(GenericMethod method, int recursionLevel) {
        GenericClass returnClass;
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)method);
            return;
        }
        if (this.dependencyCache.contains(method)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + method);
        this.dependencyCache.add(method);
        for (Class<?> parameter : method.getRawParameterTypes()) {
            logger.debug("Current parameter " + parameter);
            GenericClass parameterClass = new GenericClass((Type)parameter);
            if (parameterClass.isPrimitive() || parameterClass.isString()) continue;
            logger.debug("Adding dependency " + parameterClass.getClassName());
            this.addDependency(parameterClass, recursionLevel);
        }
        if (Properties.P_FUNCTIONAL_MOCKING > 0.0 && recursionLevel == 1 && !(returnClass = method.getGeneratedClass()).isPrimitive() && !returnClass.isString()) {
            this.addDependency(returnClass, recursionLevel);
        }
    }

    private void addDependencies(GenericField field, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)field);
            return;
        }
        if (this.dependencyCache.contains(field)) {
            return;
        }
        if (field.getField().getType().isPrimitive() || field.getField().getType().equals(String.class)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + field);
        this.dependencyCache.add(field);
        logger.debug("Adding dependency " + field.getName());
        this.addDependency(new GenericClass(field.getGenericFieldType()), recursionLevel);
    }

    private void addDependency(GenericClass clazz, int recursionLevel) {
        if (this.analyzedClasses.contains((clazz = clazz.getRawGenericClass()).getRawClass())) {
            return;
        }
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.isString()) {
            return;
        }
        if (clazz.getRawClass().equals(Enum.class)) {
            return;
        }
        if (clazz.isArray()) {
            this.addDependency(new GenericClass(clazz.getComponentType()), recursionLevel);
            return;
        }
        if (!TestUsageChecker.canUse(clazz.getRawClass())) {
            return;
        }
        Class mock = MockList.getMockClass((String)clazz.getRawClass().getCanonicalName());
        if (mock != null) {
            logger.debug("Adding mock {} instead of {}", (Object)mock, (Object)clazz);
            clazz = new GenericClass(mock);
        } else if (!TestClusterUtils.checkIfCanUse(clazz.getClassName())) {
            return;
        }
        for (DependencyPair pair : this.dependencies) {
            if (!pair.getDependencyClass().equals(clazz)) continue;
            return;
        }
        if (this.analyzedAbstractClasses.contains(clazz)) {
            return;
        }
        logger.debug("Getting concrete classes for " + clazz.getClassName());
        ConstantPoolManager.getInstance().addNonSUTConstant(org.objectweb.asm.Type.getType(clazz.getRawClass()));
        ArrayList actualClasses = new ArrayList(ConcreteClassAnalyzer.getInstance().getConcreteClasses(clazz.getRawClass(), this.inheritanceTree));
        logger.debug("Concrete classes for " + clazz.getClassName() + ": " + actualClasses.size());
        this.analyzedAbstractClasses.add(clazz);
        for (Class clazz2 : actualClasses) {
            logger.debug("Adding concrete class: " + clazz2);
            this.dependencies.add(new DependencyPair(recursionLevel, clazz2));
        }
    }

    private boolean addDependencyClass(GenericClass clazz, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependency {}", (Object)clazz.getClassName());
            return false;
        }
        if (this.analyzedClasses.contains((clazz = clazz.getRawGenericClass()).getRawClass())) {
            return true;
        }
        this.analyzedClasses.add(clazz.getRawClass());
        if ((clazz.isAssignableTo((Type)((Object)Collection.class)) || clazz.isAssignableTo((Type)((Object)Map.class))) && clazz.getNumParameters() > 0) {
            this.containerClasses.add(clazz.getRawClass());
        }
        if (clazz.isString()) {
            return false;
        }
        try {
            String orig;
            String name;
            TestCluster cluster = TestCluster.getInstance();
            logger.debug("Adding dependency class " + clazz.getClassName());
            if (!TestUsageChecker.canUse(clazz.getRawClass())) {
                logger.info("*** Cannot use class: " + clazz.getClassName());
                return false;
            }
            for (Constructor<?> constructor : TestClusterUtils.getConstructors(clazz.getRawClass())) {
                name = "<init>" + org.objectweb.asm.Type.getConstructorDescriptor(constructor);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getClassName(), "<init>", org.objectweb.asm.Type.getConstructorDescriptor(constructor)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestUsageChecker.canUse(constructor)) {
                    GenericConstructor genericConstructor = new GenericConstructor(constructor, clazz);
                    try {
                        cluster.addGenerator(clazz, genericConstructor);
                        this.addDependencies(genericConstructor, recursionLevel + 1);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Keeping track of " + constructor.getDeclaringClass().getName() + "." + constructor.getName() + org.objectweb.asm.Type.getConstructorDescriptor(constructor));
                    }
                    catch (Throwable t) {
                        logger.info("Error adding constructor {}: {}", (Object)constructor.getName(), (Object)t.getMessage());
                    }
                    continue;
                }
                logger.debug("Constructor cannot be used: {}", constructor);
            }
            for (Method method : TestClusterUtils.getMethods(clazz.getRawClass())) {
                name = method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)method);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getClassName(), method.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)method)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestUsageChecker.canUse(method, clazz.getRawClass()) && !method.getName().equals("hashCode")) {
                    logger.debug("Adding method " + clazz.getClassName() + "." + method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)method));
                    GenericMethod genericMethod = new GenericMethod(method, clazz);
                    try {
                        GenericClass retClass;
                        this.addDependencies(genericMethod, recursionLevel + 1);
                        if (!Properties.PURE_INSPECTORS) {
                            cluster.addModifier(new GenericClass(clazz), genericMethod);
                        } else if (!CheapPurityAnalyzer.getInstance().isPure(method)) {
                            cluster.addModifier(new GenericClass(clazz), genericMethod);
                        }
                        if ((retClass = new GenericClass(method.getReturnType())).isPrimitive() || retClass.isVoid() || retClass.isObject() || retClass.isString()) continue;
                        cluster.addGenerator(retClass, genericMethod);
                    }
                    catch (Throwable t) {
                        logger.info("Error adding method " + method.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                logger.debug("Method cannot be used: " + method);
            }
            for (Field field : TestClusterUtils.getFields(clazz.getRawClass())) {
                logger.debug("Checking field " + field);
                if (TestUsageChecker.canUse(field, clazz.getRawClass())) {
                    logger.debug("Adding field " + field + " for class " + clazz);
                    try {
                        boolean isFinalField;
                        GenericField genericField = new GenericField(field, clazz);
                        GenericClass retClass = new GenericClass(field.getType());
                        if (!(retClass.isPrimitive() || retClass.isObject() || retClass.isString())) {
                            cluster.addGenerator(new GenericClass(field.getGenericType()), genericField);
                        }
                        if (isFinalField = TestClusterGenerator.isFinalField(field)) continue;
                        cluster.addModifier(clazz, genericField);
                        this.addDependencies(genericField, recursionLevel + 1);
                    }
                    catch (Throwable t) {
                        logger.info("Error adding field " + field.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                logger.debug("Field cannot be used: " + field);
            }
            logger.info("Finished analyzing " + clazz.getTypeName() + " at recursion level " + recursionLevel);
            cluster.getAnalyzedClasses().add(clazz.getRawClass());
        }
        catch (Throwable t) {
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Failed to add dependencies for class " + clazz.getClassName() + ": " + t + "\n" + Arrays.asList(t.getStackTrace()));
            return false;
        }
        return true;
    }

    private static Set<Class<?>> loadClasses(Collection<String> classNames) {
        LinkedHashSet loadedClasses = new LinkedHashSet();
        for (String subClass : classNames) {
            try {
                Class subClazz = Class.forName(subClass, false, TestGenerationContext.getInstance().getClassLoaderForSUT());
                if (!TestUsageChecker.canUse(subClazz) || subClazz.isInterface() || Modifier.isAbstract(subClazz.getModifiers()) && !TestClusterUtils.hasStaticGenerator(subClazz)) continue;
                Class mock = MockList.getMockClass((String)subClazz.getCanonicalName());
                if (mock != null) {
                    subClazz = mock;
                } else if (!TestClusterUtils.checkIfCanUse(subClazz.getCanonicalName())) continue;
                loadedClasses.add(subClazz);
            }
            catch (ClassNotFoundException e) {
                logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found: " + subClass, (Throwable)e);
                logger.error("Removing class from inheritance tree");
            }
        }
        return loadedClasses;
    }

    private List<List<GenericClass>> getAssignableTypes(GenericClass clazz) {
        ArrayList<List<GenericClass>> tuples = new ArrayList<List<GenericClass>>();
        boolean first = true;
        for (Type parameterType : clazz.getParameterTypes()) {
            List<GenericClass> assignableClasses = this.getAssignableTypes(parameterType);
            ArrayList newTuples = new ArrayList();
            for (GenericClass concreteClass : assignableClasses) {
                if (first) {
                    ArrayList<GenericClass> tuple = new ArrayList<GenericClass>();
                    tuple.add(concreteClass);
                    newTuples.add(tuple);
                    continue;
                }
                for (List list : tuples) {
                    ArrayList<GenericClass> tuple = new ArrayList<GenericClass>(list);
                    tuple.add(concreteClass);
                    newTuples.add(tuple);
                }
            }
            tuples = newTuples;
            first = false;
        }
        return tuples;
    }

    private void addCastClassForContainer(Class<?> clazz) {
        if (this.concreteCastClasses.contains(clazz)) {
            return;
        }
        this.concreteCastClasses.add(clazz);
        this.genericCastClasses.add(new GenericClass(clazz));
        CastClassManager.getInstance().addCastClass(clazz, 1);
        TestCluster.getInstance().clearGeneratorCache(new GenericClass(clazz));
    }

    private List<GenericClass> getAssignableTypes(Type type) {
        ArrayList<GenericClass> types = new ArrayList<GenericClass>();
        for (GenericClass clazz : this.genericCastClasses) {
            if (!clazz.isAssignableTo(type)) continue;
            logger.debug(clazz + " is assignable to " + type);
            types.add(clazz);
        }
        return types;
    }
}

