/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.evosuite.PackageInfo;
import org.evosuite.TestGenerationContext;
import org.evosuite.runtime.Reflection;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.util.ReflectionUtils;
import org.evosuite.setup.TestUsageChecker;
import org.junit.Test;
import org.junit.runners.Suite;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClusterUtils {
    protected static final Logger logger = LoggerFactory.getLogger(TestClusterUtils.class);
    private static final List<String> classExceptions = Collections.unmodifiableList(Arrays.asList("com.apple.", "apple.", "sun.", "com.sun.", "com.oracle.", "sun.awt."));
    private static final Map<Class<?>, Set<Field>> accessibleFieldCache = new LinkedHashMap();
    private static final Map<Class<?>, Set<Method>> methodCache = new LinkedHashMap();

    @Deprecated
    public static boolean isTest(String className) {
        try {
            Class<?> clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(className);
            Class<?> superClazz = clazz.getSuperclass();
            while (!superClazz.equals(Object.class)) {
                if (superClazz.equals(Suite.class)) {
                    return true;
                }
                if (superClazz.equals(Test.class)) {
                    return true;
                }
                superClazz = clazz.getSuperclass();
            }
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            logger.info("Could not load class: ", (Object)className);
        }
        return false;
    }

    public static boolean isAnonymousClass(String className) {
        int pos = className.lastIndexOf(36);
        if (pos < 0) {
            return false;
        }
        char firstLetter = className.charAt(pos + 1);
        return firstLetter >= '0' && firstLetter <= '9';
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            constructor.setAccessible(true);
        }
    }

    public static boolean isEvoSuiteClass(Class<?> c) {
        return c.getName().startsWith(PackageInfo.getEvoSuitePackage());
    }

    public static int getPackageDistance(String className1, String className2) {
        String[] package1 = StringUtils.split((String)className1, (char)'.');
        String[] package2 = StringUtils.split((String)className2, (char)'.');
        int distance = 0;
        int same = 1;
        for (int num = 0; num < package1.length && num < package2.length && package1[num].equals(package2[num]); ++num) {
            ++same;
        }
        if (package1.length > same) {
            distance += package1.length - same;
        }
        if (package2.length > same) {
            distance += package2.length - same;
        }
        return distance;
    }

    public static boolean checkIfCanUse(String className) {
        if (MockList.shouldBeMocked((String)className)) {
            return false;
        }
        for (String s : classExceptions) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    public static Set<Constructor<?>> getConstructors(Class<?> clazz) {
        TreeMap<String, Constructor> helper = new TreeMap<String, Constructor>();
        LinkedHashSet constructors = new LinkedHashSet();
        for (Constructor c : Reflection.getDeclaredConstructors(clazz)) {
            helper.put(Type.getConstructorDescriptor((Constructor)c), c);
        }
        for (Constructor c : helper.values()) {
            constructors.add(c);
        }
        return constructors;
    }

    public static Set<Field> getFields(Class<?> clazz) {
        TreeMap<String, Object> helper = new TreeMap<String, Object>();
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        if (clazz.getSuperclass() != null) {
            for (Field f : TestClusterUtils.getFields(clazz.getSuperclass())) {
                helper.put(f.toGenericString(), f);
            }
        }
        for (Class in : Reflection.getInterfaces(clazz)) {
            for (Field f : TestClusterUtils.getFields(in)) {
                helper.put(f.toGenericString(), f);
            }
        }
        for (Field f : Reflection.getDeclaredFields(clazz)) {
            helper.put(f.toGenericString(), f);
        }
        fields.addAll(helper.values());
        return fields;
    }

    public static boolean hasStaticGenerator(Class<?> clazz) {
        for (Method m : ReflectionUtils.getMethods(clazz)) {
            if (!Modifier.isStatic(m.getModifiers()) || !clazz.isAssignableFrom(m.getReturnType())) continue;
            return true;
        }
        return false;
    }

    public static Set<Field> getAccessibleFields(Class<?> clazz) {
        if (accessibleFieldCache.containsKey(clazz)) {
            return accessibleFieldCache.get(clazz);
        }
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Field f : Reflection.getFields(clazz)) {
            if (!TestUsageChecker.canUse(f) || Modifier.isFinal(f.getModifiers())) continue;
            fields.add(f);
        }
        accessibleFieldCache.put(clazz, fields);
        return fields;
    }

    public static Set<Method> getMethods(Class<?> clazz) {
        if (methodCache.containsKey(clazz)) {
            return methodCache.get(clazz);
        }
        TreeMap<String, Object> helper = new TreeMap<String, Object>();
        if (clazz.getSuperclass() != null) {
            for (Method m : TestClusterUtils.getMethods(clazz.getSuperclass())) {
                helper.put(m.getName() + Type.getMethodDescriptor((Method)m), m);
            }
        }
        for (Class in : Reflection.getInterfaces(clazz)) {
            for (Method m : TestClusterUtils.getMethods(in)) {
                helper.put(m.getName() + Type.getMethodDescriptor((Method)m), m);
            }
        }
        for (Method m : Reflection.getDeclaredMethods(clazz)) {
            helper.put(m.getName() + Type.getMethodDescriptor((Method)m), m);
        }
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        methods.addAll(helper.values());
        methodCache.put(clazz, methods);
        return methods;
    }

    public static Method getMethod(Class<?> clazz, String methodName, String desc) {
        for (Method method : Reflection.getMethods(clazz)) {
            if (!method.getName().equals(methodName) || !Type.getMethodDescriptor((Method)method).equals(desc)) continue;
            return method;
        }
        return null;
    }

    public static Class<?> getClass(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }
}

