/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Variable;

public abstract class Constraint<T>
implements Serializable {
    private static final long serialVersionUID = 7547747352755232472L;
    private int hash = 0;
    protected int size = 0;

    public abstract Comparator getComparator();

    public abstract Expression<?> getLeftOperand();

    public abstract Expression<?> getRightOperand();

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.getLeftOperand().hashCode() + this.getComparator().hashCode() + this.getRightOperand().hashCode();
        }
        return this.hash;
    }

    public int getSize() {
        if (this.size == 0) {
            this.size = 1 + this.getLeftOperand().getSize() + this.getRightOperand().getSize();
        }
        return this.size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Constraint)) {
            return false;
        }
        Constraint other = (Constraint)obj;
        return this.getComparator().equals((Object)other.getComparator()) && this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public boolean isSolveable() {
        return !this.getLeftOperand().equals(this.getRightOperand()) || this.getComparator() != Comparator.LT && this.getComparator() != Comparator.GT && this.getComparator() != Comparator.NE;
    }

    public abstract Constraint<T> negate();

    protected static double normalize(double x) {
        return x / (x + 1.0);
    }

    public Set<Variable<?>> getVariables() {
        HashSet result = new HashSet();
        result.addAll(this.getLeftOperand().getVariables());
        result.addAll(this.getRightOperand().getVariables());
        return result;
    }

    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.getLeftOperand().getConstants());
        result.addAll(this.getRightOperand().getConstants());
        return result;
    }

    public abstract <K, V> K accept(ConstraintVisitor<K, V> var1, V var2);
}

