/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.bv;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;

public final class IntegerVariable
extends AbstractExpression<Long>
implements IntegerValue,
Variable<Long> {
    private static final long serialVersionUID = 6302073364874210525L;
    private final String name;
    private final long minValue;
    private final long maxValue;

    public IntegerVariable(String name, long conV, long minValue, long maxValue) {
        super(conV, 1, true);
        this.name = name;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setConcreteValue(Long con) {
        this.concreteValue = con;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getMinValue() {
        return this.minValue;
    }

    @Override
    public Long getMaxValue() {
        return this.maxValue;
    }

    public String toString() {
        return this.name + "(" + this.concreteValue + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerVariable) {
            IntegerVariable v = (IntegerVariable)obj;
            return this.getName().equals(v.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.add(this);
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return new HashSet<Object>();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

