/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.reader;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.str.StringValue;

public final class StringReaderExpr
extends AbstractExpression<Long>
implements IntegerValue {
    private static final long serialVersionUID = -744964586007203884L;
    private final StringValue string;
    private final int readerPosition;

    public StringReaderExpr(Long conc_value, StringValue string) {
        this(conc_value, string, 0);
    }

    public StringReaderExpr(Long conc_value, StringValue string, int readerPosition) {
        super(conc_value, 1 + string.getSize(), string.containsSymbolicVariable());
        this.string = string;
        this.readerPosition = readerPosition;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.string.getVariables());
        return variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringReaderExpr) {
            StringReaderExpr that = (StringReaderExpr)obj;
            return this.string.equals(that.string) && this.readerPosition == that.readerPosition;
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode() + this.readerPosition;
    }

    public String toString() {
        String toString = String.format("STRING_READER(%s, %s)", this.string.toString(), this.readerPosition);
        return toString;
    }

    public int getReaderPosition() {
        return this.readerPosition;
    }

    public StringValue getString() {
        return this.string;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.add(this.string.getConcreteValue());
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

