/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerComparison;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.RealComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstraintNormalizer {
    static Logger log = LoggerFactory.getLogger(ConstraintNormalizer.class);

    public static Constraint<?> normalize(IntegerConstraint c) {
        Expression<?> left = c.getLeftOperand();
        Expression<?> right = c.getRightOperand();
        if (left instanceof StringComparison || right instanceof StringComparison) {
            return ConstraintNormalizer.createStringConstraint(c);
        }
        if (left instanceof RealComparison || right instanceof RealComparison) {
            return ConstraintNormalizer.createRealConstraint(c);
        }
        if (left instanceof IntegerComparison || right instanceof IntegerComparison) {
            return ConstraintNormalizer.normalizeIntegerConstriant(c);
        }
        log.debug("Un-normalized constraint: " + c);
        return c;
    }

    private static Constraint<?> createStringConstraint(IntegerConstraint c) {
        if (c.getLeftOperand() instanceof StringComparison) {
            StringComparison string_comparison = (StringComparison)c.getLeftOperand();
            Expression<?> number_expr = c.getRightOperand();
            IntegerConstant constant = new IntegerConstant((Long)number_expr.getConcreteValue());
            return new StringConstraint(string_comparison, c.getComparator(), constant);
        }
        assert (c.getRightOperand() instanceof StringComparison);
        StringComparison string_comparison = (StringComparison)c.getRightOperand();
        Expression<?> number_expr = c.getLeftOperand();
        IntegerConstant constant = new IntegerConstant((Long)number_expr.getConcreteValue());
        return new StringConstraint(string_comparison, c.getComparator(), constant);
    }

    private static Constraint<?> createRealConstraint(IntegerConstraint c) {
        if (c.getLeftOperand() instanceof RealComparison) {
            RealComparison cmp = (RealComparison)c.getLeftOperand();
            int value = ((Number)c.getRightOperand().getConcreteValue()).intValue();
            Comparator op = c.getComparator();
            Expression<Double> cmp_left = cmp.getLeftOperant();
            Expression<Double> cmp_right = cmp.getRightOperant();
            return ConstraintNormalizer.createRealConstraint(cmp_left, op, cmp_right, value);
        }
        assert (c.getRightOperand() instanceof RealComparison);
        RealComparison cmp = (RealComparison)c.getRightOperand();
        Comparator op = c.getComparator();
        Comparator swap_op = op.swap();
        int value = ((Number)c.getLeftOperand().getConcreteValue()).intValue();
        int swap_value = -value;
        Expression<Double> cmp_left = cmp.getLeftOperant();
        Expression<Double> cmp_right = cmp.getRightOperant();
        return ConstraintNormalizer.createRealConstraint(cmp_left, swap_op, cmp_right, swap_value);
    }

    private static RealConstraint createRealConstraint(Expression<Double> cmp_left, Comparator op, Expression<Double> cmp_right, int value) {
        switch (op) {
            case EQ: {
                if (value < 0) {
                    return new RealConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.EQ, cmp_right);
                }
                return new RealConstraint(cmp_left, Comparator.GT, cmp_right);
            }
            case NE: {
                if (value < 0) {
                    return new RealConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.NE, cmp_right);
                }
                return new RealConstraint(cmp_left, Comparator.LE, cmp_right);
            }
            case LE: {
                if (value < 0) {
                    return new RealConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.LE, cmp_right);
                }
                throw new RuntimeException("Unexpected Constraint");
            }
            case LT: {
                if (value < 0) {
                    throw new RuntimeException("Unexpected Constraint");
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                return new RealConstraint(cmp_left, Comparator.LE, cmp_right);
            }
            case GE: {
                if (value < 0) {
                    throw new RuntimeException("Unexpected Constraint");
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                return new RealConstraint(cmp_left, Comparator.GT, cmp_right);
            }
            case GT: {
                if (value < 0) {
                    return new RealConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                if (value == 0) {
                    return new RealConstraint(cmp_left, Comparator.GT, cmp_right);
                }
                throw new RuntimeException("Unexpected Constraint");
            }
        }
        throw new IllegalArgumentException("Unknown operator : " + (Object)((Object)op));
    }

    private static Constraint<?> normalizeIntegerConstriant(IntegerConstraint c) {
        if (c.getLeftOperand() instanceof IntegerComparison) {
            IntegerComparison cmp = (IntegerComparison)c.getLeftOperand();
            int value = ((Number)c.getRightOperand().getConcreteValue()).intValue();
            Comparator op = c.getComparator();
            Expression<Long> cmp_left = cmp.getLeftOperant();
            Expression<Long> cmp_right = cmp.getRightOperant();
            return ConstraintNormalizer.createIntegerConstraint(cmp_left, op, cmp_right, value);
        }
        assert (c.getRightOperand() instanceof IntegerComparison);
        IntegerComparison cmp = (IntegerComparison)c.getRightOperand();
        int value = ((Number)c.getLeftOperand().getConcreteValue()).intValue();
        Comparator op = c.getComparator();
        Expression<Long> cmp_left = cmp.getLeftOperant();
        Expression<Long> cmp_right = cmp.getRightOperant();
        Comparator swap_op = op.swap();
        int swap_value = -value;
        return ConstraintNormalizer.createIntegerConstraint(cmp_left, swap_op, cmp_right, swap_value);
    }

    private static IntegerConstraint createIntegerConstraint(Expression<Long> cmp_left, Comparator op, Expression<Long> cmp_right, int value) {
        switch (op) {
            case EQ: {
                if (value < 0) {
                    return new IntegerConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.EQ, cmp_right);
                }
                return new IntegerConstraint(cmp_left, Comparator.GT, cmp_right);
            }
            case NE: {
                if (value < 0) {
                    return new IntegerConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.NE, cmp_right);
                }
                return new IntegerConstraint(cmp_left, Comparator.LE, cmp_right);
            }
            case LE: {
                if (value < 0) {
                    return new IntegerConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.LE, cmp_right);
                }
                throw new RuntimeException("Unexpected Constraint");
            }
            case LT: {
                if (value < 0) {
                    throw new RuntimeException("Unexpected Constraint");
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.LT, cmp_right);
                }
                return new IntegerConstraint(cmp_left, Comparator.LE, cmp_right);
            }
            case GE: {
                if (value < 0) {
                    throw new RuntimeException("Unexpected Constraint");
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                return new IntegerConstraint(cmp_left, Comparator.GT, cmp_right);
            }
            case GT: {
                if (value < 0) {
                    return new IntegerConstraint(cmp_left, Comparator.GE, cmp_right);
                }
                if (value == 0) {
                    return new IntegerConstraint(cmp_left, Comparator.GT, cmp_right);
                }
                throw new RuntimeException("Unexpected Constraint");
            }
        }
        throw new IllegalStateException("Unknown operator " + (Object)((Object)op));
    }
}

