/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.evosuite.dse.AbstractVM;
import org.evosuite.dse.util.Assertions;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.instrument.ConcolicInstrumentingClassLoader;
import org.evosuite.symbolic.vm.ConstraintFactory;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.IntegerOperand;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.PathConditionCollector;
import org.evosuite.symbolic.vm.RealOperand;
import org.evosuite.symbolic.vm.ReferenceOperand;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapVM
extends AbstractVM {
    private static Logger logger = LoggerFactory.getLogger(HeapVM.class);
    private static final String ARRAY_LENGTH = "length";
    private final SymbolicEnvironment env;
    private final ConcolicInstrumentingClassLoader classLoader;
    private final PathConditionCollector pc;

    public HeapVM(SymbolicEnvironment env, PathConditionCollector pc, ConcolicInstrumentingClassLoader classLoader) {
        this.env = env;
        this.pc = pc;
        this.classLoader = classLoader;
    }

    public static Field resolveField(Class<?> claz, String name) {
        Class<?>[] suprs;
        Field[] fields;
        Assertions.notNull(claz, name);
        for (Field field : fields = claz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        for (Class<?> supr : suprs = claz.getInterfaces()) {
            Field res = HeapVM.resolveField(supr, name);
            if (res == null) continue;
            return res;
        }
        Class<?> supr = claz.getSuperclass();
        if (supr != null) {
            return HeapVM.resolveField(supr, name);
        }
        return null;
    }

    @Override
    public void GETSTATIC(String owner, String fieldName, String desc) {
        boolean isAccessible;
        Class<?> claz = this.env.ensurePrepared(owner);
        Field concrete_field = HeapVM.resolveField(claz, fieldName);
        Class<?> declaringClass = concrete_field.getDeclaringClass();
        if (declaringClass.isInterface()) {
            logger.debug("Do we have to prepare the static fields of an interface?");
            this.env.ensurePrepared(declaringClass);
        }
        if (!(isAccessible = concrete_field.isAccessible())) {
            concrete_field.setAccessible(true);
        }
        Type type = Type.getType((String)desc);
        try {
            if (type.equals((Object)Type.INT_TYPE)) {
                int value = concrete_field.getInt(null);
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.CHAR_TYPE)) {
                char value = concrete_field.getChar(null);
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.SHORT_TYPE)) {
                short value = concrete_field.getShort(null);
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.BOOLEAN_TYPE)) {
                boolean booleanValue = concrete_field.getBoolean(null);
                int value = booleanValue ? 1 : 0;
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.BYTE_TYPE)) {
                byte value = concrete_field.getByte(null);
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.LONG_TYPE)) {
                long value = concrete_field.getLong(null);
                IntegerValue intExpr = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushBv64(intExpr);
            } else if (type.equals((Object)Type.FLOAT_TYPE)) {
                float value = concrete_field.getFloat(null);
                RealValue fp32 = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushFp32(fp32);
            } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
                double value = concrete_field.getDouble(null);
                RealValue fp64 = this.env.heap.getStaticField(owner, fieldName, value);
                this.env.topFrame().operandStack.pushFp64(fp64);
            } else {
                Object value = concrete_field.get(null);
                ReferenceExpression ref = this.env.heap.getReference(value);
                this.env.topFrame().operandStack.pushRef(ref);
            }
            if (!isAccessible) {
                concrete_field.setAccessible(false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void PUTSTATIC(String owner, String name, String desc) {
        Class<?> claz = this.env.ensurePrepared(owner);
        Field field = HeapVM.resolveField(claz, name);
        Class<?> declaringClass = field.getDeclaringClass();
        if (declaringClass.isInterface()) {
            logger.debug("Do we have to prepare the static fields of an interface?");
            this.env.ensurePrepared(declaringClass);
        }
        Operand value_operand = this.env.topFrame().operandStack.popOperand();
        Expression<Long> symb_value = null;
        if (value_operand instanceof IntegerOperand) {
            IntegerOperand intOp = (IntegerOperand)value_operand;
            symb_value = intOp.getIntegerExpression();
        } else if (value_operand instanceof RealOperand) {
            RealOperand realOp = (RealOperand)value_operand;
            symb_value = realOp.getRealExpression();
        } else if (value_operand instanceof ReferenceOperand) {
            return;
        }
        this.env.heap.putStaticField(owner, name, symb_value);
    }

    @Override
    public void NEW(String className) {
        Class<?> clazz = this.classLoader.getClassForName(className);
        Type objectType = Type.getType(clazz);
        ReferenceConstant newObject = this.env.heap.buildNewReferenceConstant(objectType);
        this.env.topFrame().operandStack.pushRef(newObject);
    }

    @Override
    public void GETFIELD(Object conc_receiver, String className, String fieldName, String desc) {
        ReferenceExpression receiver_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_receiver, receiver_ref);
        Field field = HeapVM.resolveField(this.classLoader.getClassForName(className), fieldName);
        this.env.ensurePrepared(field.getDeclaringClass());
        boolean isAccessible = field.isAccessible();
        if (!isAccessible) {
            field.setAccessible(true);
        }
        if (this.nullReferenceViolation(receiver_ref, conc_receiver)) {
            return;
        }
        ReferenceExpression symb_receiver = receiver_ref;
        Type type = Type.getType((String)desc);
        try {
            if (type.equals((Object)Type.INT_TYPE)) {
                int value = field.getInt(conc_receiver);
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.LONG_TYPE)) {
                long value = field.getLong(conc_receiver);
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv64(intExpr);
            } else if (type.equals((Object)Type.FLOAT_TYPE)) {
                float value = field.getFloat(conc_receiver);
                RealValue fp32 = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushFp32(fp32);
            } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
                double value = field.getDouble(conc_receiver);
                RealValue fp64 = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushFp64(fp64);
            } else if (type.equals((Object)Type.CHAR_TYPE)) {
                char value = field.getChar(conc_receiver);
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.SHORT_TYPE)) {
                short value = field.getShort(conc_receiver);
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.BOOLEAN_TYPE)) {
                boolean booleanValue = field.getBoolean(conc_receiver);
                int value = booleanValue ? 1 : 0;
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else if (type.equals((Object)Type.BYTE_TYPE)) {
                byte value = field.getByte(conc_receiver);
                IntegerValue intExpr = this.env.heap.getField(className, fieldName, conc_receiver, symb_receiver, value);
                this.env.topFrame().operandStack.pushBv32(intExpr);
            } else {
                Object value = field.get(conc_receiver);
                ReferenceExpression ref = this.env.heap.getReference(value);
                this.env.topFrame().operandStack.pushRef(ref);
            }
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void PUTFIELD(Object conc_receiver, String className, String fieldName, String desc) {
        Operand value_operand = this.env.topFrame().operandStack.popOperand();
        ReferenceExpression receiver_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_receiver, receiver_ref);
        Field field = HeapVM.resolveField(this.classLoader.getClassForName(className), fieldName);
        this.env.ensurePrepared(field.getDeclaringClass());
        if (this.nullReferenceViolation(receiver_ref, conc_receiver)) {
            return;
        }
        ReferenceExpression symb_receiver = receiver_ref;
        Expression<Long> symb_value = null;
        if (value_operand instanceof IntegerOperand) {
            IntegerOperand intOp = (IntegerOperand)value_operand;
            symb_value = intOp.getIntegerExpression();
        } else if (value_operand instanceof RealOperand) {
            RealOperand realOp = (RealOperand)value_operand;
            symb_value = realOp.getRealExpression();
        } else if (value_operand instanceof ReferenceOperand) {
            return;
        }
        this.env.heap.putField(className, fieldName, conc_receiver, symb_receiver, symb_value);
    }

    @Override
    public void NEWARRAY(int conc_array_length, Class<?> componentType) {
        IntegerValue symb_array_length = this.env.topFrame().operandStack.popBv32();
        if (this.negativeArrayLengthViolation(conc_array_length, symb_array_length)) {
            return;
        }
        int[] lenghts = new int[]{0};
        Class<?> array_class = Array.newInstance(componentType, lenghts).getClass();
        Type arrayType = Type.getType(array_class);
        ReferenceConstant symb_array_ref = this.env.heap.buildNewReferenceConstant(arrayType);
        this.env.heap.putField("", ARRAY_LENGTH, null, symb_array_ref, symb_array_length);
        this.env.topFrame().operandStack.pushRef(symb_array_ref);
    }

    @Override
    public void ANEWARRAY(int conc_array_length, String componentTypeName) {
        IntegerValue symb_array_length = this.env.topFrame().operandStack.popBv32();
        if (this.negativeArrayLengthViolation(conc_array_length, symb_array_length)) {
            return;
        }
        Type componentType = Type.getType((String)componentTypeName.replace('/', '.'));
        Class<?> componentClass = this.classLoader.getClassForType(componentType);
        int[] lenghts = new int[]{0};
        Class<?> array_class = Array.newInstance(componentClass, lenghts).getClass();
        Type arrayType = Type.getType(array_class);
        ReferenceConstant symb_array_ref = this.env.heap.buildNewReferenceConstant(arrayType);
        this.env.heap.putField("", ARRAY_LENGTH, null, symb_array_ref, symb_array_length);
        this.env.topFrame().operandStack.pushRef(symb_array_ref);
    }

    @Override
    public void MULTIANEWARRAY(String arrayTypeDesc, int nrDimensions) {
        for (int i = 0; i < nrDimensions; ++i) {
            IntegerValue symb_length = this.env.topFrame().operandStack.popBv32();
            int conc_length = ((Long)symb_length.getConcreteValue()).intValue();
            if (!this.negativeArrayLengthViolation(conc_length, symb_length)) continue;
            return;
        }
        Type multiArrayType = Type.getType((String)arrayTypeDesc);
        ReferenceConstant newMultiArray = this.env.heap.buildNewReferenceConstant(multiArrayType);
        this.env.topFrame().operandStack.pushRef(newMultiArray);
    }

    @Override
    public void ARRAYLENGTH(Object conc_array) {
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        int conc_array_length = Array.getLength(conc_array);
        ReferenceExpression symb_array_ref = array_ref;
        IntegerValue symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array_ref, conc_array_length);
        this.env.topFrame().operandStack.pushBv32(symb_array_length);
    }

    @Override
    public void IALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        int bv32 = Array.getInt(conc_array, conc_index);
        IntegerValue c = this.env.heap.array_load(symb_array, conc_index, bv32);
        this.env.topFrame().operandStack.pushBv32(c);
    }

    @Override
    public void LALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        long bv64 = Array.getLong(conc_array, conc_index);
        IntegerValue c = this.env.heap.array_load(symb_array, conc_index, bv64);
        this.env.topFrame().operandStack.pushBv64(c);
    }

    @Override
    public void FALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        float fp32 = Array.getFloat(conc_array, conc_index);
        RealValue c = this.env.heap.array_load(symb_array, conc_index, fp32);
        this.env.topFrame().operandStack.pushFp32(c);
    }

    @Override
    public void DALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        double fp64 = Array.getDouble(conc_array, conc_index);
        RealValue c = this.env.heap.array_load(symb_array, conc_index, fp64);
        this.env.topFrame().operandStack.pushFp64(c);
    }

    @Override
    public void AALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        Object conc_value = Array.get(conc_array, conc_index);
        ReferenceExpression symb_value = conc_value == null ? ExpressionFactory.buildNewNullExpression() : this.env.heap.getReference(conc_value);
        this.env.topFrame().operandStack.pushRef(symb_value);
    }

    private boolean indexTooBigViolation(int conc_index, IntegerValue symb_index, int conc_array_length, IntegerValue symb_array_length) {
        if (conc_index >= conc_array_length) {
            IntegerConstraint indexTooBigConstraint = ConstraintFactory.gte(symb_index, symb_array_length);
            if (indexTooBigConstraint.getLeftOperand().containsSymbolicVariable() || indexTooBigConstraint.getRightOperand().containsSymbolicVariable()) {
                this.pc.addSupportingConstraint(indexTooBigConstraint);
            }
            return true;
        }
        IntegerConstraint indexTooBigConstraint = ConstraintFactory.lt(symb_index, symb_array_length);
        if (indexTooBigConstraint.getLeftOperand().containsSymbolicVariable() || indexTooBigConstraint.getRightOperand().containsSymbolicVariable()) {
            this.pc.addSupportingConstraint(indexTooBigConstraint);
        }
        return false;
    }

    private boolean nullReferenceViolation(ReferenceExpression symb_ref, Object conc_ref) {
        return conc_ref == null;
    }

    private boolean negativeIndexViolation(int conc_index, IntegerValue symb_index) {
        if (conc_index < 0) {
            IntegerConstraint negative_index_constraint = ConstraintFactory.lt(symb_index, ExpressionFactory.ICONST_0);
            if (negative_index_constraint.getLeftOperand().containsSymbolicVariable() || negative_index_constraint.getRightOperand().containsSymbolicVariable()) {
                this.pc.addSupportingConstraint(negative_index_constraint);
            }
            return true;
        }
        IntegerConstraint negative_index_constraint = ConstraintFactory.gte(symb_index, ExpressionFactory.ICONST_0);
        if (negative_index_constraint.getLeftOperand().containsSymbolicVariable() || negative_index_constraint.getRightOperand().containsSymbolicVariable()) {
            this.pc.addSupportingConstraint(negative_index_constraint);
        }
        return false;
    }

    private boolean negativeArrayLengthViolation(int conc_array_length, IntegerValue array_length_index) {
        if (conc_array_length < 0) {
            IntegerConstraint negative_array_length_constraint = ConstraintFactory.lt(array_length_index, ExpressionFactory.ICONST_0);
            if (negative_array_length_constraint.getLeftOperand().containsSymbolicVariable() || negative_array_length_constraint.getRightOperand().containsSymbolicVariable()) {
                this.pc.addSupportingConstraint(negative_array_length_constraint);
            }
            return true;
        }
        IntegerConstraint negative_array_length_constraint = ConstraintFactory.gte(array_length_index, ExpressionFactory.ICONST_0);
        if (negative_array_length_constraint.getLeftOperand().containsSymbolicVariable() || negative_array_length_constraint.getRightOperand().containsSymbolicVariable()) {
            this.pc.addSupportingConstraint(negative_array_length_constraint);
        }
        return false;
    }

    @Override
    public void BALOAD(Object conc_array, int conc_index) {
        short intValue;
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        Object object = Array.get(conc_array, conc_index);
        if (object instanceof Boolean) {
            boolean booleanValue = (Boolean)object;
            intValue = booleanValue ? (short)1 : 0;
        } else {
            assert (object instanceof Byte);
            intValue = ((Byte)object).shortValue();
        }
        IntegerValue c = this.env.heap.array_load(symb_array, conc_index, intValue);
        this.env.topFrame().operandStack.pushBv32(c);
    }

    @Override
    public void CALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        char bv32 = Array.getChar(conc_array, conc_index);
        IntegerValue c = this.env.heap.array_load(symb_array, conc_index, bv32);
        this.env.topFrame().operandStack.pushBv32(c);
    }

    @Override
    public void SALOAD(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        short conc_value = Array.getShort(conc_array, conc_index);
        IntegerValue e = this.env.heap.array_load(symb_array, conc_index, conc_value);
        this.env.topFrame().operandStack.pushBv32(e);
    }

    @Override
    public void IASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_value = this.env.topFrame().operandStack.popBv32();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void LASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_value = this.env.topFrame().operandStack.popBv64();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void FASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        RealValue symb_value = this.env.topFrame().operandStack.popFp32();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void DASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        RealValue symb_value = this.env.topFrame().operandStack.popFp64();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void AASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        ReferenceExpression value_ref = this.env.topFrame().operandStack.popRef();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
    }

    @Override
    public void BASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_value = this.env.topFrame().operandStack.popBv32();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void CASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_value = this.env.topFrame().operandStack.popBv32();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void SASTORE(Object conc_array, int conc_index) {
        IntegerValue symb_array_length;
        IntegerValue symb_value = this.env.topFrame().operandStack.popBv32();
        IntegerValue symb_index = this.env.topFrame().operandStack.popBv32();
        ReferenceExpression array_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_array, array_ref);
        if (this.nullReferenceViolation(array_ref, conc_array)) {
            return;
        }
        if (this.negativeIndexViolation(conc_index, symb_index)) {
            return;
        }
        ReferenceExpression symb_array = array_ref;
        int conc_array_length = Array.getLength(conc_array);
        if (this.indexTooBigViolation(conc_index, symb_index, conc_array_length, symb_array_length = this.env.heap.getField("", ARRAY_LENGTH, conc_array, symb_array, conc_array_length))) {
            return;
        }
        this.env.heap.array_store(conc_array, symb_array, conc_index, symb_value);
    }

    @Override
    public void CHECKCAST(Object conc_ref, String typeName) {
        ReferenceExpression symb_ref = this.env.topFrame().operandStack.peekRef();
        this.env.heap.initializeReference(conc_ref, symb_ref);
    }

    @Override
    public void INSTANCEOF(Object conc_ref, String typeName) {
        ReferenceExpression symb_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_ref, symb_ref);
        Type type = Type.getType((String)typeName);
        Class<?> myClazz = this.classLoader.getClassForType(type);
        boolean instanceOf = myClazz.isInstance(conc_ref);
        IntegerConstant ret = instanceOf ? ExpressionFactory.ICONST_1 : ExpressionFactory.ICONST_0;
        this.env.topFrame().operandStack.pushBv32(ret);
    }
}

