/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.expr.ref.ReferenceVariable;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolicHeap {
    protected static final Logger logger = LoggerFactory.getLogger(SymbolicHeap.class);
    private int newInstanceCount = 0;
    private final Map<Integer, ReferenceExpression> nonNullRefs = new HashMap<Integer, ReferenceExpression>();
    private final Map<FieldKey, Map<ReferenceExpression, Expression<?>>> symb_fields = new HashMap();
    private final Map<FieldKey, Expression<?>> symb_static_fields = new HashMap();
    private final Map<ReferenceExpression, Map<Integer, Expression<?>>> symb_arrays = new HashMap();
    public static final String $STRING_BUILDER_CONTENTS = "$stringBuilder_contents";
    public static final String $STRING_BUFFER_CONTENTS = "$stringBuffer_contents";
    public static final String $BIG_INTEGER_CONTENTS = "$bigInteger_contents";
    public static final String $STRING_TOKENIZER_VALUE = "$stringTokenizerValue";
    public static final String $STRING_READER_VALUE = "$stringReaderValue";
    public static final String $MATCHER_INPUT = "$matcherInput";
    public static final String $BOOLEAN_VALUE = "$booleanValue";
    public static final String $BYTE_VALUE = "$byteValue";
    public static final String $CHAR_VALUE = "$charValue";
    public static final String $SHORT_VALUE = "$shortValue";
    public static final String $LONG_VALUE = "$longValue";
    public static final String $INT_VALUE = "$intValue";
    public static final String $FLOAT_VALUE = "$floatValue";
    public static final String $DOUBLE_VALUE = "$doubleValue";
    public static final String $STRING_VALUE = "$stringValue";

    public ReferenceConstant buildNewReferenceConstant(Type objectType) {
        if (objectType.getClassName() == null) {
            throw new IllegalArgumentException();
        }
        int newInstanceId = this.newInstanceCount++;
        return new ReferenceConstant(objectType, newInstanceId);
    }

    public void putField(String className, String fieldName, Object conc_receiver, ReferenceExpression symb_receiver, Expression<?> symb_value) {
        Map<ReferenceExpression, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            symb_field.remove(symb_receiver);
        } else {
            symb_field.put(symb_receiver, symb_value);
        }
    }

    private Map<ReferenceExpression, Expression<?>> getOrCreateSymbolicField(String owner, String name) {
        FieldKey k = new FieldKey(owner, name);
        Map<ReferenceExpression, Expression<?>> symb_field = this.symb_fields.get(k);
        if (symb_field == null) {
            symb_field = new HashMap();
            this.symb_fields.put(k, symb_field);
        }
        return symb_field;
    }

    public IntegerValue getField(String owner, String name, Object conc_receiver, ReferenceExpression symb_receiver, long conc_value) {
        Map<ReferenceExpression, Expression<?>> symb_field = this.getOrCreateSymbolicField(owner, name);
        IntegerValue symb_value = (IntegerValue)symb_field.get(symb_receiver);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        return symb_value;
    }

    public RealValue getField(String className, String fieldName, Object conc_receiver, ReferenceExpression symb_receiver, double conc_value) {
        Map<ReferenceExpression, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        RealValue symb_value = (RealValue)symb_field.get(symb_receiver);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        return symb_value;
    }

    public StringValue getField(String className, String fieldName, Object conc_receiver, ReferenceExpression symb_receiver, String conc_value) {
        Map<ReferenceExpression, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        StringValue symb_value = (StringValue)symb_field.get(symb_receiver);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            symb_field.remove(symb_receiver);
        }
        return symb_value;
    }

    public Expression<?> getField(String className, String fieldName, Object conc_receiver, ReferenceExpression symb_receiver) {
        Map<ReferenceExpression, Expression<?>> symb_field = this.getOrCreateSymbolicField(className, fieldName);
        Expression<?> symb_value = symb_field.get(symb_receiver);
        return symb_value;
    }

    public void putStaticField(String owner, String name, Expression<?> symb_value) {
        FieldKey k = new FieldKey(owner, name);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            this.symb_static_fields.remove(k);
        } else {
            this.symb_static_fields.put(k, symb_value);
        }
    }

    public IntegerValue getStaticField(String owner, String name, long conc_value) {
        FieldKey k = new FieldKey(owner, name);
        IntegerValue symb_value = (IntegerValue)this.symb_static_fields.get(k);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        return symb_value;
    }

    public RealValue getStaticField(String owner, String name, double conc_value) {
        FieldKey k = new FieldKey(owner, name);
        RealValue symb_value = (RealValue)this.symb_static_fields.get(k);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        return symb_value;
    }

    public StringValue getStaticField(String owner, String name, String conc_value) {
        FieldKey k = new FieldKey(owner, name);
        StringValue symb_value = (StringValue)this.symb_static_fields.get(k);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            this.symb_static_fields.remove(k);
        }
        return symb_value;
    }

    public ReferenceExpression getReference(Object conc_ref) {
        if (conc_ref == null) {
            ReferenceConstant nullConstant = ExpressionFactory.buildNewNullExpression();
            return nullConstant;
        }
        int identityHashCode = System.identityHashCode(conc_ref);
        if (this.nonNullRefs.containsKey(identityHashCode)) {
            ReferenceExpression symb_ref = this.nonNullRefs.get(identityHashCode);
            return symb_ref;
        }
        Type type = Type.getType(conc_ref.getClass());
        ReferenceConstant ref_constant = new ReferenceConstant(type, this.newInstanceCount++);
        ref_constant.initializeReference(conc_ref);
        this.nonNullRefs.put(identityHashCode, ref_constant);
        return ref_constant;
    }

    public ReferenceVariable buildNewReferenceVariable(Object conc_object, String var_name) {
        Type referenceType = conc_object == null ? Type.getType(Object.class) : Type.getType(conc_object.getClass());
        int newInstanceId = this.newInstanceCount++;
        ReferenceVariable r = new ReferenceVariable(referenceType, newInstanceId, var_name, conc_object);
        return r;
    }

    public void array_store(Object conc_array, ReferenceExpression symb_array, int conc_index, Expression<?> symb_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        if (symb_value == null || !symb_value.containsSymbolicVariable()) {
            symb_array_contents.remove(conc_index);
        } else {
            symb_array_contents.put(conc_index, symb_value);
        }
    }

    private Map<Integer, Expression<?>> getOrCreateSymbolicArray(ReferenceExpression symb_array_ref) {
        Map<Integer, Expression<?>> symb_array_contents = this.symb_arrays.get(symb_array_ref);
        if (symb_array_contents == null) {
            symb_array_contents = new HashMap();
            this.symb_arrays.put(symb_array_ref, symb_array_contents);
        }
        return symb_array_contents;
    }

    public StringValue array_load(ReferenceExpression symb_array, int conc_index, String conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        StringValue symb_value = (StringValue)symb_array_contents.get(conc_index);
        if (symb_value == null || !((String)symb_value.getConcreteValue()).equals(conc_value)) {
            symb_value = ExpressionFactory.buildNewStringConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        return symb_value;
    }

    public IntegerValue array_load(ReferenceExpression symb_array, int conc_index, long conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        IntegerValue symb_value = (IntegerValue)symb_array_contents.get(conc_index);
        if (symb_value == null || (Long)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewIntegerConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        return symb_value;
    }

    public RealValue array_load(ReferenceExpression symb_array, int conc_index, double conc_value) {
        Map<Integer, Expression<?>> symb_array_contents = this.getOrCreateSymbolicArray(symb_array);
        RealValue symb_value = (RealValue)symb_array_contents.get(conc_index);
        if (symb_value == null || (Double)symb_value.getConcreteValue() != conc_value) {
            symb_value = ExpressionFactory.buildNewRealConstant(conc_value);
            symb_array_contents.remove(conc_index);
        }
        return symb_value;
    }

    public void initializeReference(Object conc_ref, ReferenceExpression symb_ref) {
        if (conc_ref != null && !symb_ref.isInitialized()) {
            symb_ref.initializeReference(conc_ref);
            int identityHashCode = System.identityHashCode(conc_ref);
            this.nonNullRefs.put(identityHashCode, symb_ref);
        }
    }

    private static final class FieldKey {
        private String owner;
        private String name;

        public FieldKey(String owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public int hashCode() {
            return this.owner.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass().equals(FieldKey.class)) {
                FieldKey that = (FieldKey)o;
                return this.owner.equals(that.owner) && this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.owner + "/" + this.name;
        }
    }
}

