/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.extraction;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.runtime.instrumentation.JSRInlinerClassVisitor;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.testcarver.instrument.Instrumenter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarvingClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(CarvingClassLoader.class);
    private final Instrumenter instrumenter = new Instrumenter();
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public CarvingClassLoader() {
        this.classLoader = CarvingClassLoader.class.getClassLoader();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!RuntimeInstrumentation.checkIfCanInstrument((String)name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        logger.info("Seeing class for first time: " + name);
        Class<?> instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        logger.warn("Instrumenting class '" + fullyQualifiedTargetClass + "'.");
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            InputStream is = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class' should be in target project, but could not be found!");
            }
            ClassReader reader = new ClassReader(is);
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 4);
            this.instrumenter.transformClassNode(classNode, className);
            ClassWriter writer = new ClassWriter(2);
            classNode.accept((ClassVisitor)new JSRInlinerClassVisitor((ClassVisitor)writer));
            byte[] byteBuffer = writer.toByteArray();
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            if (Modifier.isPrivate(result.getModifiers())) {
                logger.info("REPLACING PRIVATE CLASS " + fullyQualifiedTargetClass);
                result = super.loadClass(fullyQualifiedTargetClass);
            }
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Keeping class: " + fullyQualifiedTargetClass);
            return result;
        }
        catch (Throwable t) {
            logger.info("Error: " + t);
            for (StackTraceElement e : t.getStackTrace()) {
                logger.info(e.toString());
            }
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }
}

