/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.runtime.annotation.BoundInputVariable;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteAssertionOnly;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.testcase.ConstraintHelper;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintVerifier {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintVerifier.class);

    public static boolean hasAnyOnlyForAssertionMethod(TestCase tc) {
        for (int i = 0; i < tc.size(); ++i) {
            Statement st = tc.getStatement(i);
            if (!ConstraintVerifier.canStatementHaveConstraints(st)) continue;
            Constructor<?> ao = null;
            if (st instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)st;
                ao = ms.getMethod().getMethod();
            } else if (st instanceof ConstructorStatement) {
                ConstructorStatement cs = (ConstructorStatement)st;
                ao = cs.getConstructor().getConstructor();
            }
            for (Annotation annotation : ((AccessibleObject)ao).getDeclaredAnnotations()) {
                if (!(annotation instanceof EvoSuiteAssertionOnly)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canDelete(TestCase tc, int pos) throws IllegalArgumentException {
        return ConstraintVerifier.dependentPositions(tc, pos).isEmpty();
    }

    public static Set<Integer> dependentPositions(TestCase tc, int pos) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{tc});
        LinkedHashSet<Integer> dep = new LinkedHashSet<Integer>();
        Statement st = tc.getStatement(pos);
        if (!ConstraintVerifier.canStatementHaveConstraints(st)) {
            VariableReference ret = st.getReturnValue();
            for (int i = pos + 1; i < tc.size(); ++i) {
                Statement toCheck = tc.getStatement(i);
                Constraints constraint = ConstraintHelper.getConstraints(toCheck);
                if (constraint == null || !constraint.noNullInputs() || !(toCheck instanceof EntityWithParametersStatement)) continue;
                EntityWithParametersStatement entity = (EntityWithParametersStatement)toCheck;
                for (VariableReference input : entity.getParameterReferences()) {
                    if (!input.same(ret)) continue;
                    dep.add(i);
                }
            }
            return dep;
        }
        for (Annotation[] array : ConstraintVerifier.getParameterAnnotations(st)) {
            for (int i = 0; i < array.length; ++i) {
                Annotation an = array[i];
                if (!(an instanceof BoundInputVariable)) continue;
                EntityWithParametersStatement e = (EntityWithParametersStatement)st;
                int boundingVarPos = e.getParameterReferences().get(i).getStPosition();
                dep.add(boundingVarPos);
            }
        }
        if (st instanceof MethodStatement) {
            MethodStatement current = (MethodStatement)st;
            String currentKlassName = current.getMethod().getDeclaringClass().getCanonicalName();
            String currentMethodName = current.getMethod().getName();
            for (int i = pos + 1; i < tc.size(); ++i) {
                String after;
                Statement toCheck = tc.getStatement(i);
                Constraints constraints = ConstraintHelper.getConstraints(toCheck);
                if (constraints == null || (after = constraints.after()) == null || after.trim().isEmpty()) continue;
                MethodStatement ms = (MethodStatement)toCheck;
                String[] klassAndMethod = ConstraintHelper.getClassAndMethod(after, ms.getMethod().getDeclaringClass());
                String afterKlassName = klassAndMethod[0];
                String afterMethodName = klassAndMethod[1];
                if (!afterKlassName.equals(currentKlassName) || !afterMethodName.equals(currentMethodName)) continue;
                dep.add(i);
            }
        }
        return dep;
    }

    public static boolean isValidPositionForInsertion(GenericAccessibleObject<?> obj, TestCase tc, int pos) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{obj, tc});
        List<VariableReference> possibleCallees = tc.getObjects(obj.getOwnerType(), pos);
        for (VariableReference ref : possibleCallees) {
            int boundPos = ConstraintHelper.getLastPositionOfBounded(ref, tc);
            if (boundPos < pos) continue;
            return false;
        }
        Constraints constraints = obj.getAccessibleObject().getAnnotation(Constraints.class);
        if (constraints == null) {
            return true;
        }
        if (!ConstraintVerifier.canBeInsertedRegardlessOfPosition(obj, tc)) {
            return false;
        }
        int minPos = ConstraintVerifier.getMinPosForAfter(obj, tc, tc.size());
        return minPos >= 0 && pos >= minPos;
    }

    public static int getAValidPositionForInsertion(GenericAccessibleObject<?> obj, TestCase tc, int lastValid) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{obj, tc});
        Constraints constraints = obj.getAccessibleObject().getAnnotation(Constraints.class);
        if (constraints == null) {
            if (lastValid <= 0) {
                return 0;
            }
            return Randomness.nextInt(0, lastValid);
        }
        if (!ConstraintVerifier.canBeInsertedRegardlessOfPosition(obj, tc)) {
            return -1;
        }
        int minPos = ConstraintVerifier.getMinPosForAfter(obj, tc, lastValid);
        if (minPos < 0) {
            return -1;
        }
        if (minPos > 0) {
            return minPos;
        }
        assert (minPos == 0);
        if (lastValid <= 0) {
            return 0;
        }
        return Randomness.nextInt(0, lastValid);
    }

    private static int getMinPosForAfter(GenericAccessibleObject<?> obj, TestCase tc, int lastValid) {
        Constraints constraints = obj.getAccessibleObject().getAnnotation(Constraints.class);
        Class<?> declaringClass = obj.getDeclaringClass();
        int minPos = 0;
        String after = constraints.after();
        if (after != null && !after.isEmpty()) {
            String[] pair = ConstraintHelper.getClassAndMethod(after, declaringClass);
            int afterPos = ConstraintHelper.getLastPositionOfMethodCall(tc, pair[0], pair[1], lastValid);
            if (afterPos < 0) {
                return -1;
            }
            minPos = afterPos + 1;
        }
        return minPos;
    }

    private static boolean canBeInsertedRegardlessOfPosition(GenericAccessibleObject<?> obj, TestCase tc) {
        String[] properties;
        List<String[]> othersExcluded;
        Constraints constraints = obj.getAccessibleObject().getAnnotation(Constraints.class);
        if (constraints == null) {
            return true;
        }
        if (constraints.noDirectInsertion()) {
            return false;
        }
        Class<?> declaringClass = obj.getDeclaringClass();
        String declaringClassName = declaringClass.getCanonicalName();
        String name = obj.getName();
        if (constraints.atMostOnce()) {
            int counter = ConstraintHelper.countNumberOfMethodCalls(tc, declaringClass, name);
            if (counter == 1) {
                return false;
            }
            if (counter > 1) {
                throw new RuntimeException("Violated 'atMostOnce' constraint for " + obj.getName());
            }
        }
        if ((othersExcluded = ConstraintHelper.getExcludedMethods(tc)) != null && othersExcluded.size() > 0) {
            for (String[] pair : othersExcluded) {
                if (!pair[0].equals(declaringClassName) || !pair[1].equals(name)) continue;
                return false;
            }
        }
        if ((properties = constraints.dependOnProperties()) != null && properties.length > 0) {
            for (String property : properties) {
                if (tc.getAccessedEnvironment().hasProperty(property)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean verifyTest(TestChromosome tc) {
        return ConstraintVerifier.verifyTest(tc.getTestCase());
    }

    public static boolean verifyTest(TestCase tc) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{tc});
        LinkedHashSet<Executable> seenAtMostOnce = new LinkedHashSet<Executable>();
        block0: for (int i = 0; i < tc.size(); ++i) {
            boolean declaringClassExcluded;
            Statement st = tc.getStatement(i);
            if (!ConstraintVerifier.canStatementHaveConstraints(st)) continue;
            if (!ConstraintVerifier.checkFunctionalMockUsage(st, tc)) {
                return false;
            }
            Executable reflectionRef = null;
            List<VariableReference> inputs = null;
            List<VariableReference> boundedInitializingInputs = null;
            Annotation[] methodAnnotations = null;
            Annotation[][] parameterAnnotations = null;
            Class<?> declaringClass = null;
            if (st instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)st;
                inputs = ms.getParameterReferences();
                Method m = ms.getMethod().getMethod();
                reflectionRef = m;
                methodAnnotations = m.getDeclaredAnnotations();
                declaringClass = m.getDeclaringClass();
                parameterAnnotations = m.getParameterAnnotations();
                boundedInitializingInputs = ConstraintVerifier.getBoundedInitializingVariables(inputs, parameterAnnotations);
                if (!ConstraintVerifier.checkBoundedVariableAtMostOnce(tc, i, ms)) {
                    return false;
                }
            } else if (st instanceof ConstructorStatement) {
                ConstructorStatement cs = (ConstructorStatement)st;
                inputs = cs.getParameterReferences();
                Constructor<?> c = cs.getConstructor().getConstructor();
                reflectionRef = c;
                methodAnnotations = c.getDeclaredAnnotations();
                declaringClass = c.getDeclaringClass();
                parameterAnnotations = c.getParameterAnnotations();
                boundedInitializingInputs = ConstraintVerifier.getBoundedInitializingVariables(inputs, parameterAnnotations);
            }
            if ((declaringClassExcluded = ConstraintVerifier.isDeclaringExcluded(declaringClass)) && !ConstraintVerifier.hasIncludeAnnotation(methodAnnotations)) {
                logger.error("'excludeClass' constraint violated at position " + i + " in test case:\n" + tc.toCode());
                return false;
            }
            if (!boundedInitializingInputs.isEmpty()) {
                for (VariableReference vr : boundedInitializingInputs) {
                    if (ConstraintVerifier.checkInitializingBoundedVariable(tc, i, vr)) continue;
                    return false;
                }
            }
            for (Annotation annotation : methodAnnotations) {
                if (annotation instanceof EvoSuiteExclude && declaringClassExcluded) {
                    logger.error("Wrong constraints: class " + declaringClass.getName() + " is a " + EvoSuiteClassExclude.class.getSimpleName() + " but uses " + EvoSuiteExclude.class.getSimpleName() + " on the method" + reflectionRef.toString());
                    return false;
                }
                if (annotation instanceof EvoSuiteInclude && !declaringClassExcluded) {
                    logger.error("Wrong constraints: class " + declaringClass.getName() + " is not a " + EvoSuiteClassExclude.class.getSimpleName() + " but uses " + EvoSuiteInclude.class.getSimpleName() + " on the method" + reflectionRef.toString());
                    return false;
                }
                if (annotation instanceof EvoSuiteExclude) {
                    logger.error("'excludeMethod' constraint violated at position " + i + " in test case:\n" + tc.toCode());
                    return false;
                }
                if (!(annotation instanceof Constraints)) continue;
                Constraints c = (Constraints)annotation;
                if (c.atMostOnce()) {
                    if (seenAtMostOnce.contains(reflectionRef)) {
                        logger.error("'atMostOne' constraint violated at position " + i + " in test case:\n" + tc.toCode());
                        return false;
                    }
                    seenAtMostOnce.add(reflectionRef);
                }
                if (c.noNullInputs()) {
                    for (VariableReference vr : inputs) {
                        boolean invalid = ConstraintHelper.isNull(vr, tc);
                        if (!invalid) continue;
                        logger.error("'noNullInputs' constraint violated at position " + i + " in test case:\n" + tc.toCode());
                        return false;
                    }
                }
                if (c.excludeOthers() != null && c.excludeOthers().length > 0 && !ConstraintVerifier.checkExcludeOthers(tc, i, declaringClass, c)) {
                    return false;
                }
                if (c.after() == null || c.after().trim().isEmpty() || ConstraintVerifier.checkAfter(tc, i, declaringClass, c)) continue block0;
                return false;
            }
        }
        return true;
    }

    private static boolean checkFunctionalMockUsage(Statement st, TestCase tc) {
        if (!(st instanceof MethodStatement)) {
            return true;
        }
        MethodStatement ms = (MethodStatement)st;
        VariableReference callee = ms.getCallee();
        if (callee == null) {
            return true;
        }
        Statement source = tc.getStatement(callee.getStPosition());
        if (source instanceof FunctionalMockStatement) {
            logger.error("Mock object created at position " + source.getPosition() + " has a method called in position " + st.getPosition());
            return false;
        }
        return true;
    }

    private static Annotation[][] getParameterAnnotations(Statement st) {
        if (st instanceof MethodStatement) {
            return ((MethodStatement)st).getMethod().getMethod().getParameterAnnotations();
        }
        if (st instanceof ConstructorStatement) {
            return ((ConstructorStatement)st).getConstructor().getConstructor().getParameterAnnotations();
        }
        return null;
    }

    private static AccessibleObject getAccessibleObject(Statement st) {
        if (st instanceof MethodStatement) {
            return ((MethodStatement)st).getMethod().getMethod();
        }
        if (st instanceof ConstructorStatement) {
            return ((ConstructorStatement)st).getConstructor().getConstructor();
        }
        return null;
    }

    private static boolean canStatementHaveConstraints(Statement st) {
        return st instanceof MethodStatement || st instanceof ConstructorStatement;
    }

    private static boolean checkBoundedVariableAtMostOnce(TestCase tc, int i, MethodStatement ms) {
        int j;
        Annotation[][] annotations = ms.getMethod().getMethod().getParameterAnnotations();
        List<VariableReference> inputs = ms.getParameterReferences();
        ArrayList<VariableReference> atMostOnce = new ArrayList<VariableReference>();
        block0: for (j = 0; j < annotations.length; ++j) {
            Annotation[] array;
            for (Annotation annotation : array = annotations[j]) {
                BoundInputVariable biv;
                if (!(annotation instanceof BoundInputVariable) || !(biv = (BoundInputVariable)annotation).atMostOnce()) continue;
                atMostOnce.add(inputs.get(j));
                continue block0;
            }
        }
        if (atMostOnce.isEmpty()) {
            return true;
        }
        for (j = i - 1; j >= 0; --j) {
            MethodStatement other;
            Statement st = tc.getStatement(j);
            if (!(st instanceof MethodStatement) || !(other = (MethodStatement)st).getMethod().getMethod().equals(ms.getMethod().getMethod())) continue;
            for (VariableReference ref : other.getParameterReferences()) {
                for (VariableReference bounded : atMostOnce) {
                    if (!ref.same(bounded)) continue;
                    logger.error("Bounded variable declared in " + ref.getStPosition() + " can only be used once as input for the method " + other.getMethod().getName() + " : it is wrongly used both at position " + j + " and " + i);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkInitializingBoundedVariable(TestCase tc, int i, VariableReference vr) {
        for (int j = i - 1; j > vr.getStPosition(); --j) {
            Statement st = tc.getStatement(j);
            MethodStatement ms = null;
            ConstructorStatement cs = null;
            Annotation[][] annotations = null;
            List<VariableReference> inputs = null;
            if (st instanceof MethodStatement) {
                ms = (MethodStatement)st;
                annotations = ms.getMethod().getMethod().getParameterAnnotations();
                inputs = ms.getParameterReferences();
                VariableReference callee = ms.getCallee();
                if (vr.same(callee)) {
                    logger.error("Invalid method call at position " + j + " on bounded variable created in " + vr.getStPosition() + " and initialized in " + i + "\nTest case code:\n" + tc.toCode());
                    return false;
                }
            }
            if (st instanceof ConstructorStatement) {
                cs = (ConstructorStatement)st;
                annotations = cs.getConstructor().getConstructor().getParameterAnnotations();
                inputs = cs.getParameterReferences();
            }
            if (inputs == null || inputs.isEmpty()) continue;
            block1: for (int k = 0; k < inputs.size(); ++k) {
                Annotation[] varAnns;
                VariableReference input = inputs.get(k);
                for (Annotation ann : varAnns = annotations[k]) {
                    if (ann instanceof BoundInputVariable) continue block1;
                }
                if (!vr.same(input)) continue;
                logger.error("Bounded variable of type " + vr.getType() + " created at position " + vr.getStPosition() + " is used as input in " + j + " before its bounding initializer at position " + i + ". Statement at position " + j + " is:\n" + tc.getStatement(j).getCode() + "\nTest case code:\n" + tc.toCode());
                return false;
            }
        }
        Statement declaration = tc.getStatement(vr.getStPosition());
        if (!(declaration instanceof ConstructorStatement)) {
            logger.error("Bounded variable is declared in " + vr.getStPosition() + " but not with a 'new' constructor.Statement:\n" + declaration + "\nTest code:\n" + tc.toCode());
            return false;
        }
        return true;
    }

    private static List<VariableReference> getBoundedInitializingVariables(List<VariableReference> inputs, Annotation[][] annotations) {
        ArrayList<VariableReference> bounded = new ArrayList<VariableReference>();
        block0: for (int i = 0; i < inputs.size(); ++i) {
            Annotation[] array;
            for (Annotation annotation : array = annotations[i]) {
                BoundInputVariable biv;
                if (!(annotation instanceof BoundInputVariable) || !(biv = (BoundInputVariable)annotation).initializer()) continue;
                bounded.add(inputs.get(i));
                continue block0;
            }
        }
        return bounded;
    }

    private static boolean checkAfter(TestCase tc, int i, Class<?> declaringClass, Constraints c) {
        String after = c.after();
        String[] klassAndMethod = ConstraintHelper.getClassAndMethod(after, declaringClass);
        String afterKlassName = klassAndMethod[0];
        String afterMethodName = klassAndMethod[1];
        for (int j = i - 1; j >= 0; --j) {
            MethodStatement ms;
            Statement previous = tc.getStatement(j);
            if (!(previous instanceof MethodStatement) || !(ms = (MethodStatement)previous).getMethod().getName().equals(afterMethodName) || !ms.getMethod().getDeclaringClass().getName().equals(afterKlassName)) continue;
            return true;
        }
        logger.error("'after' constraint violated at position " + i + ". Not found previous call to '" + after + "' in test case:\n" + tc.toCode());
        return false;
    }

    private static boolean hasIncludeAnnotation(Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (!(annotation instanceof EvoSuiteInclude)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeclaringExcluded(Class<?> declaringClass) {
        EvoSuiteClassExclude ann = declaringClass.getAnnotation(EvoSuiteClassExclude.class);
        return ann != null;
    }

    private static boolean checkExcludeOthers(TestCase tc, int i, Class<?> declaringClass, Constraints c) {
        Statement st = tc.getStatement(i);
        for (String excluded : c.excludeOthers()) {
            String[] klassAndMethod = ConstraintHelper.getClassAndMethod(excluded, declaringClass);
            String klassName = klassAndMethod[0];
            String excludedName = klassAndMethod[1];
            try {
                Class<?> klass = Class.forName(klassName);
                boolean found = false;
                for (Method k : klass.getDeclaredMethods()) {
                    if (!k.getName().equals(excludedName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.error("Invalid constraint definition for " + declaringClass.getCanonicalName() + ". The excluded method " + excludedName + " does not exist.");
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Invalid constraint definition for " + declaringClass.getCanonicalName() + ". The excluded method in class " + klassName + " does not exist.");
                return false;
            }
            for (int j = 0; j < tc.size(); ++j) {
                MethodStatement oms;
                Statement other = tc.getStatement(j);
                if (j == i || !(other instanceof MethodStatement) || !(oms = (MethodStatement)other).getMethod().getName().equals(excludedName) || !oms.getMethod().getDeclaringClass().getName().equals(klassName)) continue;
                logger.error("'excludeOthers' constraint violated at position " + i + " in test case:\n" + tc.toCode());
                return false;
            }
        }
        return true;
    }
}

