/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.Collections;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.ConstraintVerifier;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.ValueMinimizer;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseMinimizer {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseMinimizer.class);
    private final TestFitnessFunction fitnessFunction;

    public TestCaseMinimizer(TestFitnessFunction fitnessFunction) {
        this.fitnessFunction = fitnessFunction;
    }

    public static boolean removeUnusedVariables(TestCase t) {
        ArrayList<Integer> to_delete = new ArrayList<Integer>();
        boolean has_deleted = false;
        int num = 0;
        for (Statement s : t) {
            VariableReference var = s.getReturnValue();
            if (!t.hasReferences(var)) {
                to_delete.add(num);
                has_deleted = true;
            }
            ++num;
        }
        Collections.sort(to_delete, Collections.reverseOrder());
        for (Integer position : to_delete) {
            t.remove(position);
        }
        return has_deleted;
    }

    private static boolean isWorse(FitnessFunction<TestChromosome> fitness, TestChromosome oldChromosome, TestChromosome newChromosome) {
        if (fitness.isMaximizationFunction() ? oldChromosome.getFitness(fitness) > fitness.getFitness(newChromosome) : fitness.getFitness(newChromosome) > oldChromosome.getFitness(fitness)) {
            return true;
        }
        for (SecondaryObjective<?> objective : TestChromosome.getSecondaryObjectives()) {
            if (objective.compareChromosomes(oldChromosome, newChromosome) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isTimeoutReached() {
        return !TimeController.getInstance().isThereStillTimeInThisPhase();
    }

    public void minimize(TestChromosome c) {
        if (!Properties.MINIMIZE) {
            return;
        }
        logger.info("Minimizing test case");
        double fitness = this.fitnessFunction.getFitness(c);
        if (this.isTimeoutReached()) {
            return;
        }
        logger.debug("Start fitness values: {}", (Object)fitness);
        assert (ConstraintVerifier.verifyTest(c));
        if (this.isTimeoutReached()) {
            logger.debug("Timeout reached after verifying test");
            return;
        }
        boolean changed = true;
        block2: while (changed) {
            changed = false;
            for (int i = c.test.size() - 1; i >= 0; --i) {
                boolean modified;
                if (this.isTimeoutReached()) {
                    logger.debug("Timeout reached before minimizing statement {}", (Object)c.test.getStatement(i).getCode());
                    return;
                }
                logger.debug("Deleting statement {}", (Object)c.test.getStatement(i).getCode());
                TestChromosome copy = (TestChromosome)c.clone();
                try {
                    modified = TestFactory.getInstance().deleteStatementGracefully(c.test, i);
                }
                catch (ConstructionFailedException e) {
                    modified = false;
                }
                if (!modified) {
                    c.setChanged(false);
                    c.test = copy.test;
                    logger.debug("Deleting failed");
                    continue;
                }
                c.setChanged(true);
                if (this.isTimeoutReached()) {
                    logger.debug("Keeping original version due to timeout");
                    TestCaseMinimizer.restoreTestCase(c, copy);
                    return;
                }
                if (!TestCaseMinimizer.isWorse(this.fitnessFunction, copy, c)) {
                    logger.debug("Keeping shorter version");
                    changed = true;
                    continue block2;
                }
                logger.debug("Keeping original version");
                TestCaseMinimizer.restoreTestCase(c, copy);
            }
        }
        assert (!this.fitnessFunction.isMaximizationFunction() ? this.fitnessFunction.getFitness(c) <= fitness : this.fitnessFunction.getFitness(c) >= fitness) : "Minimization worsened " + this.fitnessFunction.getClass().getName() + " fitness from " + fitness + " to " + this.fitnessFunction.getFitness(c) + " on test " + c.getTestCase().toCode();
        if (Properties.MINIMIZE_VALUES) {
            logger.info("Minimizing values of test case");
            ValueMinimizer minimizer = new ValueMinimizer();
            minimizer.minimize(c, this.fitnessFunction);
        }
        assert (ConstraintVerifier.verifyTest(c));
        if (logger.isDebugEnabled()) {
            logger.debug("Minimized test case: ");
            logger.debug(c.test.toCode());
        }
    }

    private static void restoreTestCase(TestChromosome c, TestChromosome copy) {
        c.test = copy.test;
        c.copyCachedResults(copy);
        c.setFitnessValues(copy.getFitnessValues());
        c.setPreviousFitnessValues(copy.getPreviousFitnessValues());
        c.setChanged(false);
    }
}

