/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.fm;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evosuite.testcase.fm.MethodDescriptor;
import org.evosuite.utils.generic.GenericClass;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;

public class EvoInvocationListener
implements InvocationListener,
Serializable {
    private static final long serialVersionUID = 8351121388007697168L;
    private final Map<String, MethodDescriptor> map = new LinkedHashMap<String, MethodDescriptor>();
    private volatile boolean active = false;
    private final GenericClass retvalType;

    public EvoInvocationListener(Type retvalType) {
        this.retvalType = new GenericClass(retvalType);
    }

    public EvoInvocationListener(GenericClass retvalType) {
        this.retvalType = retvalType;
    }

    public void activate() {
        this.active = true;
    }

    public void changeClassLoader(ClassLoader loader) {
        for (MethodDescriptor descriptor : this.map.values()) {
            if (descriptor == null) continue;
            descriptor.changeClassLoader(loader);
        }
    }

    public List<MethodDescriptor> getCopyOfMethodDescriptors() {
        return this.map.values().stream().sorted().collect(Collectors.toList());
    }

    protected boolean onlyMockAbstractMethods() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportInvocation(MethodInvocationReport methodInvocationReport) {
        if (!this.active) {
            return;
        }
        DescribedInvocation di = methodInvocationReport.getInvocation();
        MethodDescriptor md = null;
        if (di instanceof InvocationOnMock) {
            InvocationOnMock impl = (InvocationOnMock)di;
            Method method = impl.getMethod();
            md = new MethodDescriptor(method, this.retvalType);
        } else {
            md = this.getMethodDescriptor_old(di);
        }
        if (md.getMethodName().equals("finalize")) {
            return;
        }
        if (this.onlyMockAbstractMethods() && !md.getGenericMethod().isAbstract()) {
            return;
        }
        Map<String, MethodDescriptor> map = this.map;
        synchronized (map) {
            MethodDescriptor current = this.map.get(md.getID());
            if (current == null) {
                current = md;
            }
            current.increaseCounter();
            this.map.put(md.getID(), current);
        }
    }

    @Deprecated
    private MethodDescriptor getMethodDescriptor_old(DescribedInvocation di) {
        String description = di.toString();
        int openingP = description.indexOf(40);
        assert (openingP >= 0);
        String[] leftTokens = description.substring(0, openingP).split("\\.");
        String className = "";
        String methodName = leftTokens[leftTokens.length - 1];
        int closingP = description.lastIndexOf(41);
        String[] inputTokens = description.substring(openingP + 1, closingP).split(",");
        String mockitoMatchers = "";
        if (inputTokens.length > 0) {
            mockitoMatchers = mockitoMatchers + "any()";
            for (int i = 1; i < inputTokens.length; ++i) {
                mockitoMatchers = mockitoMatchers + " , any()";
            }
        }
        return new MethodDescriptor(className, methodName, mockitoMatchers);
    }
}

